/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.mail.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.attachment.dto.SysFile;
import com.hand.hap.attachment.service.ISysFileService;
import com.hand.hap.cache.impl.MessageEmailConfigCache;
import com.hand.hap.core.exception.EmailException;
import com.hand.hap.mail.EmailStatusEnum;
import com.hand.hap.mail.EnvironmentEnum;
import com.hand.hap.mail.MailSender;
import com.hand.hap.mail.ReceiverTypeEnum;
import com.hand.hap.mail.dto.Message;
import com.hand.hap.mail.dto.MessageAddress;
import com.hand.hap.mail.dto.MessageAttachment;
import com.hand.hap.mail.dto.MessageEmailAccount;
import com.hand.hap.mail.dto.MessageEmailAccountVo;
import com.hand.hap.mail.dto.MessageEmailConfig;
import com.hand.hap.mail.dto.MessageEmailProperty;
import com.hand.hap.mail.dto.MessageEmailWhiteList;
import com.hand.hap.mail.dto.MessageReceiver;
import com.hand.hap.mail.dto.MessageTransaction;
import com.hand.hap.mail.mapper.MessageAttachmentMapper;
import com.hand.hap.mail.mapper.MessageEmailAccountMapper;
import com.hand.hap.mail.mapper.MessageEmailConfigMapper;
import com.hand.hap.mail.mapper.MessageEmailPropertyMapper;
import com.hand.hap.mail.mapper.MessageEmailWhiteListMapper;
import com.hand.hap.mail.mapper.MessageMapper;
import com.hand.hap.mail.mapper.MessageReceiverMapper;
import com.hand.hap.mail.mapper.MessageTransactionMapper;
import com.hand.hap.mail.service.IEmailService;
import com.hand.hap.security.service.IAESClientService;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Service
public class EmailServiceImpl
implements IEmailService,
BeanFactoryAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final int dbTryTime = 3;
    private static final int TWENTY = 20;
    private static final int FIFTY = 50;
    @Autowired
    private MessageMapper messageMapper;
    @Autowired
    private MessageAttachmentMapper attachmentMapper;
    @Autowired
    private MessageReceiverMapper receiverMapper;
    @Autowired
    private MessageTransactionMapper transactionMapper;
    @Autowired
    private MessageEmailAccountMapper emailAccountMapper;
    @Autowired
    private MessageEmailWhiteListMapper emailWhiteListMapper;
    @Autowired
    private MessageEmailConfigMapper emailConfigMapper;
    private BeanFactory beanFactory;
    @Autowired
    private ISysFileService sysFileService;
    @Autowired
    private IAESClientService aceClientService;
    @Autowired
    private MessageEmailPropertyMapper emailPropertyMapper;
    @Autowired
    private MessageEmailConfigCache configCache;

    @Override
    public boolean sendMessages(Map<String, Object> params) throws Exception {
        Integer batch = (Integer)params.get("batch");
        boolean isVipQueue = (Boolean)params.get("isVipQueue");
        if (batch == null) {
            batch = 20;
        }
        if (batch == 0) {
            batch = 20;
        }
        PageHelper.startPage(1, batch);
        List<Message> userEmailToSend = null;
        userEmailToSend = isVipQueue ? this.messageMapper.selectVipEmailToSend() : this.messageMapper.selectEmailToSend();
        boolean result = this.sendMessage(userEmailToSend, params);
        return result;
    }

    @Override
    public boolean reSendMessages(List<Message> messages, Map<String, Object> params) throws Exception {
        boolean result = this.sendMessage(messages, params);
        return result;
    }

    private void messageSetPending(List<Message> messages) {
        for (Message current : messages) {
            current.setSendFlag("P");
            this.trySaveTransaction(current, null);
        }
    }

    @Override
    public boolean sendMessageByReceiver(Message message, Map<String, Object> params) throws Exception {
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.add(message);
        boolean rs = this.sendMessage(messages, params);
        return rs;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, noRollbackFor={Exception.class})
    public boolean sendEmailMessageWithFile(List<Message> userEmailToSend, List<File> fileList) throws Exception {
        int success = 0;
        try {
            for (Message currentMessage : userEmailToSend) {
                List<MessageReceiver> receivers = this.receiverMapper.selectByMessageId(currentMessage.getMessageId());
                MessageEmailAccount messageEmailAccount = this.emailAccountMapper.selectByAccountCode(currentMessage.getMessageFrom());
                MailSender mailSender = (MailSender)((Object)this.beanFactory.getBean("mailSender"));
                MessageEmailConfig config = null;
                config = this.configCache.getValue(messageEmailAccount.getConfigId().toString());
                if (null == config) {
                    config = (MessageEmailConfig)this.emailConfigMapper.selectByPrimaryKey(messageEmailAccount.getConfigId());
                    config.setWhiteLists(this.emailWhiteListMapper.selectByConfigId(config.getConfigId()));
                    config.setPropertyLists(this.emailPropertyMapper.selectByConfigId(config.getConfigId()));
                }
                mailSender.setHost(config.getHost());
                mailSender.setPort(Integer.parseInt(config.getPort()));
                mailSender.setMessageAccount(messageEmailAccount.getUserName());
                if (StringUtils.isEmpty((CharSequence)messageEmailAccount.getPassword())) {
                    mailSender.setUsername(config.getUserName());
                    mailSender.setPassword(config.getPassword());
                } else {
                    mailSender.setUsername(messageEmailAccount.getUserName());
                    mailSender.setPassword(messageEmailAccount.getPassword());
                }
                if ("Y".equalsIgnoreCase(config.getUseWhiteList())) {
                    List<MessageEmailWhiteList> whitelist = config.getWhiteLists();
                    ArrayList<String> stringList = new ArrayList<String>();
                    for (MessageEmailWhiteList current : whitelist) {
                        stringList.add(current.getAddress());
                    }
                    mailSender.setWhiteList(stringList);
                }
                if (config.getPropertyLists() != null) {
                    List<MessageEmailProperty> propertyLists = config.getPropertyLists();
                    Properties props = new Properties();
                    for (MessageEmailProperty emailProperty : propertyLists) {
                        props.put(emailProperty.getPropertyName(), emailProperty.getPropertyCode());
                    }
                    mailSender.setJavaMailProperties(props);
                }
                MessageTransaction obj = new MessageTransaction();
                Date time = new Date();
                obj.setCreatedBy(-1L);
                obj.setLastUpdatedBy(-1L);
                obj.setCreationDate(time);
                obj.setLastUpdateDate(time);
                obj.setMessageId(currentMessage.getMessageId());
                obj.setObjectVersionNumber(0L);
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{currentMessage.getSubject(), currentMessage.getContent()})) {
                    this.error(currentMessage, "subject or content is null");
                    continue;
                }
                MimeMessage mimeMessage = mailSender.createMimeMessage();
                MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
                helper.setFrom(mailSender.getMessageAccount());
                helper.setSubject(this.setEmailSubject(mailSender, currentMessage.getSubject()));
                if (CollectionUtils.isNotEmpty(fileList)) {
                    Object messageBodyPart = new MimeBodyPart();
                    messageBodyPart.setText(currentMessage.getContent());
                    MimeMultipart multipart = new MimeMultipart();
                    multipart.addBodyPart((BodyPart)messageBodyPart);
                    for (File file : fileList) {
                        messageBodyPart = new MimeBodyPart();
                        FileDataSource fileDataSource = new FileDataSource(file);
                        messageBodyPart.setDataHandler(new DataHandler((DataSource)fileDataSource));
                        try {
                            messageBodyPart.setFileName(MimeUtility.encodeText((String)file.getName()));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        multipart.addBodyPart((BodyPart)messageBodyPart);
                    }
                    mimeMessage.setContent((Multipart)multipart);
                } else {
                    helper.setText(currentMessage.getContent(), true);
                }
                for (MessageReceiver receiver : receivers) {
                    if (receiver.getMessageAddress() == null || mailSender.getWhiteList() != null && !mailSender.getWhiteList().contains(receiver.getMessageAddress())) continue;
                    if (ReceiverTypeEnum.NORMAL.getCode().equalsIgnoreCase(receiver.getMessageType())) {
                        helper.addTo(receiver.getMessageAddress());
                        continue;
                    }
                    if (ReceiverTypeEnum.CC.getCode().equalsIgnoreCase(receiver.getMessageType())) {
                        helper.addCc(receiver.getMessageAddress());
                        continue;
                    }
                    if (!ReceiverTypeEnum.BCC.getCode().equalsIgnoreCase(receiver.getMessageType())) continue;
                    helper.addBcc(receiver.getMessageAddress());
                }
                if (ArrayUtils.isEmpty((Object[])mimeMessage.getAllRecipients())) {
                    this.error(currentMessage, "The recipient is empty!");
                    continue;
                }
                try {
                    mailSender.send(mimeMessage);
                    ++success;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Send mail success.");
                    }
                    obj.setTransactionStatus(EmailStatusEnum.SUCCESS.getCode());
                    currentMessage.setSendFlag("Y");
                    this.trySaveTransaction(currentMessage, obj);
                }
                catch (Exception e) {
                    obj.setTransactionMessage(this.getExceptionStack(e));
                    obj.setTransactionStatus(EmailStatusEnum.ERROR.getCode());
                    currentMessage.setSendFlag("F");
                    this.trySaveTransaction(currentMessage, obj);
                    if (!this.log.isErrorEnabled()) continue;
                    this.log.error("Send mail failed.", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            for (Message message : userEmailToSend) {
                this.error(message, e.getMessage());
            }
            if (this.log.isErrorEnabled()) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        return true;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, noRollbackFor={Exception.class})
    public boolean sendEmailMessage(List<Message> userEmailToSend, Map<String, Object> params) throws Exception {
        int success = 0;
        try {
            for (Message currentMessage : userEmailToSend) {
                List<MessageReceiver> receivers = this.receiverMapper.selectByMessageId(currentMessage.getMessageId());
                List<MessageAttachment> attachments = this.attachmentMapper.selectByMessageId(currentMessage.getMessageId());
                MessageEmailAccount messageEmailAccount = this.emailAccountMapper.selectByAccountCode(currentMessage.getMessageFrom());
                MessageEmailConfig config = null;
                config = this.configCache.getValue(messageEmailAccount.getConfigId().toString());
                if (null == config) {
                    config = (MessageEmailConfig)this.emailConfigMapper.selectByPrimaryKey(messageEmailAccount.getConfigId());
                    config.setWhiteLists(this.emailWhiteListMapper.selectByConfigId(config.getConfigId()));
                    config.setPropertyLists(this.emailPropertyMapper.selectByConfigId(config.getConfigId()));
                }
                MailSender mailSender = (MailSender)((Object)this.beanFactory.getBean("mailSender"));
                mailSender.setHost(config.getHost());
                mailSender.setPort(Integer.parseInt(config.getPort()));
                mailSender.setMessageAccount(messageEmailAccount.getUserName());
                if (StringUtils.isEmpty((CharSequence)messageEmailAccount.getPassword())) {
                    mailSender.setUsername(config.getUserName());
                    mailSender.setPassword(config.getPassword());
                } else {
                    mailSender.setUsername(messageEmailAccount.getUserName());
                    mailSender.setPassword(messageEmailAccount.getPassword());
                }
                if ("Y".equalsIgnoreCase(config.getUseWhiteList())) {
                    List<MessageEmailWhiteList> whitelist = config.getWhiteLists();
                    ArrayList<String> stringList = new ArrayList<String>();
                    for (MessageEmailWhiteList current : whitelist) {
                        stringList.add(current.getAddress());
                    }
                    mailSender.setWhiteList(stringList);
                }
                if (config.getPropertyLists() != null) {
                    List<MessageEmailProperty> propertyLists = config.getPropertyLists();
                    Properties props = new Properties();
                    for (MessageEmailProperty emailProperty : propertyLists) {
                        props.put(emailProperty.getPropertyName(), emailProperty.getPropertyCode());
                    }
                    mailSender.setJavaMailProperties(props);
                }
                MessageTransaction obj = new MessageTransaction();
                Date time = new Date();
                obj.setCreatedBy(-1L);
                obj.setLastUpdatedBy(-1L);
                obj.setCreationDate(time);
                obj.setLastUpdateDate(time);
                obj.setMessageId(currentMessage.getMessageId());
                obj.setObjectVersionNumber(0L);
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{currentMessage.getSubject(), currentMessage.getContent()})) {
                    this.error(currentMessage, "subject or content is null");
                    continue;
                }
                MimeMessage mimeMessage = mailSender.createMimeMessage();
                MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
                helper.setFrom(mailSender.getMessageAccount());
                helper.setSubject(this.setEmailSubject(mailSender, currentMessage.getSubject()));
                helper.setText(currentMessage.getContent(), true);
                if (CollectionUtils.isNotEmpty(attachments)) {
                    ArrayList attachmentIds = new ArrayList();
                    for (MessageAttachment attachment : attachments) {
                        attachmentIds.add(attachment.getFileId().toString());
                    }
                    List<SysFile> fileNames = this.sysFileService.selectByIds(null, attachmentIds);
                    for (SysFile sysFile : fileNames) {
                        File file = new File(sysFile.getFilePath());
                        if (!file.isFile()) continue;
                        helper.addAttachment(FilenameUtils.getName((String)sysFile.getFileName()), file);
                    }
                }
                for (MessageReceiver receiver : receivers) {
                    if (receiver.getMessageAddress() == null || mailSender.getWhiteList() != null && !mailSender.getWhiteList().contains(receiver.getMessageAddress())) continue;
                    if (ReceiverTypeEnum.NORMAL.getCode().equalsIgnoreCase(receiver.getMessageType())) {
                        helper.addTo(receiver.getMessageAddress());
                        continue;
                    }
                    if (ReceiverTypeEnum.CC.getCode().equalsIgnoreCase(receiver.getMessageType())) {
                        helper.addCc(receiver.getMessageAddress());
                        continue;
                    }
                    if (!ReceiverTypeEnum.BCC.getCode().equalsIgnoreCase(receiver.getMessageType())) continue;
                    helper.addBcc(receiver.getMessageAddress());
                }
                if (ArrayUtils.isEmpty((Object[])mimeMessage.getAllRecipients())) {
                    this.error(currentMessage, "The recipient is empty!");
                    continue;
                }
                try {
                    mailSender.send(mimeMessage);
                    ++success;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Send mail success.");
                    }
                    obj.setTransactionStatus(EmailStatusEnum.SUCCESS.getCode());
                    currentMessage.setSendFlag("Y");
                    this.trySaveTransaction(currentMessage, obj);
                }
                catch (Exception e) {
                    obj.setTransactionMessage(this.getExceptionStack(e));
                    obj.setTransactionStatus(EmailStatusEnum.ERROR.getCode());
                    currentMessage.setSendFlag("F");
                    this.trySaveTransaction(currentMessage, obj);
                    if (!this.log.isErrorEnabled()) continue;
                    this.log.error("Send mail failed.", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            if (params != null) {
                params.put("ERROR_MESSAGE", e.getMessage());
            }
            for (Message message : userEmailToSend) {
                this.error(message, e.getMessage());
            }
            if (this.log.isErrorEnabled()) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        if (params != null) {
            this.prepareSummary(userEmailToSend, params, success);
        }
        return true;
    }

    public boolean sendMessage(List<Message> userEmailToSend, Map<String, Object> params) throws Exception {
        HashMap<String, MailSender> senders = new HashMap<String, MailSender>();
        int success = 0;
        this.messageSetPending(userEmailToSend);
        try {
            block4: for (Message currentMessage : userEmailToSend) {
                List<MessageReceiver> receivers = this.receiverMapper.selectByMessageId(currentMessage.getMessageId());
                List<MessageAttachment> attachments = this.attachmentMapper.selectByMessageId(currentMessage.getMessageId());
                String messageFrom = currentMessage.getMessageFrom();
                MessageAddress address = MessageAddress.toAddressObject(messageFrom);
                MailSender mailSender = (MailSender)((Object)senders.get(messageFrom = address.getAddress()));
                if (mailSender == null) {
                    mailSender = (MailSender)((Object)this.beanFactory.getBean("mailSender"));
                    MessageEmailAccount record = new MessageEmailAccount();
                    record.setAccountCode(messageFrom);
                    List<MessageEmailAccountVo> selectMessageEmailAccounts = this.emailAccountMapper.selectMessageEmailAccounts(record);
                    if (selectMessageEmailAccounts == null || selectMessageEmailAccounts.size() == 0) {
                        this.error(currentMessage, "email account is no more exists:" + messageFrom);
                        continue;
                    }
                    MessageEmailAccountVo mailAccount = selectMessageEmailAccounts.get(0);
                    if (mailAccount == null) {
                        this.error(currentMessage, "email account is no more exists:" + messageFrom);
                        continue;
                    }
                    MessageEmailConfig config = (MessageEmailConfig)this.emailConfigMapper.selectByPrimaryKey(mailAccount.getConfigId());
                    mailSender.setHost(config.getHost());
                    mailSender.setPort(Integer.parseInt(config.getPort()));
                    if (config.getTryTimes() != null) {
                        mailSender.setTryTimes(config.getTryTimes().intValue());
                    }
                    mailSender.setMessageAccount(mailAccount.getUserName());
                    if (StringUtils.isEmpty((CharSequence)mailAccount.getPassword())) {
                        mailSender.setUsername(config.getUserName());
                        mailSender.setPassword(config.getPassword());
                    } else {
                        mailSender.setUsername(mailAccount.getUserName());
                        mailSender.setPassword(mailAccount.getPassword());
                    }
                    if ("Y".equalsIgnoreCase(config.getUseWhiteList())) {
                        List<MessageEmailWhiteList> whitelist = this.emailWhiteListMapper.selectByConfigId(config.getConfigId());
                        ArrayList stringList = new ArrayList();
                        for (MessageEmailWhiteList current : whitelist) {
                            stringList.add(current.getAddress());
                        }
                        mailSender.setWhiteList(stringList);
                    }
                    senders.put(messageFrom, mailSender);
                }
                MessageTransaction obj = new MessageTransaction();
                Date time = new Date();
                obj.setCreatedBy(-1L);
                obj.setLastUpdatedBy(-1L);
                obj.setCreationDate(time);
                obj.setLastUpdateDate(time);
                obj.setMessageId(currentMessage.getMessageId());
                obj.setObjectVersionNumber(0L);
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{currentMessage.getSubject(), currentMessage.getContent()})) {
                    this.error(currentMessage, "subject or content is null");
                    continue;
                }
                MimeMessage mimeMessage = mailSender.createMimeMessage();
                MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true, "UTF-8");
                helper.setFrom(mailSender.getMessageAccount());
                helper.setSubject(this.setEmailSubject(mailSender, currentMessage.getSubject()));
                helper.setText(currentMessage.getContent(), true);
                if (attachments != null && attachments.size() > 0) {
                    ArrayList attachmentIds = new ArrayList();
                    for (MessageAttachment attachment : attachments) {
                        attachmentIds.add(attachment.getFileId().toString());
                    }
                    List<SysFile> fileNames = this.sysFileService.selectByIds(null, attachmentIds);
                    for (SysFile sysFile : fileNames) {
                        File file = new File(sysFile.getFilePath());
                        if (!file.isFile()) continue;
                        helper.addAttachment(FilenameUtils.getName((String)sysFile.getFileName()), file);
                    }
                }
                for (MessageReceiver receiver : receivers) {
                    if (receiver.getMessageAddress() == null) continue;
                    if (mailSender.getWhiteList() != null && !mailSender.getWhiteList().contains(receiver.getMessageAddress())) {
                        if (!mailSender.getWhiteList().isEmpty()) continue;
                        throw new EmailException("msg.warning.system.email_message_no_whitelist");
                    }
                    if (ReceiverTypeEnum.NORMAL.getCode().equals(receiver.getMessageType())) {
                        helper.addTo(receiver.getMessageAddress());
                        continue;
                    }
                    if (ReceiverTypeEnum.CC.getCode().equals(receiver.getMessageType())) {
                        helper.addCc(receiver.getMessageAddress());
                        continue;
                    }
                    if (!ReceiverTypeEnum.BCC.getCode().equals(receiver.getMessageType())) continue;
                    helper.addBcc(receiver.getMessageAddress());
                }
                if (ArrayUtils.isEmpty((Object[])mimeMessage.getAllRecipients())) {
                    this.error(currentMessage, "The recipient is empty!");
                    continue;
                }
                for (int i = 0; i < mailSender.getTryTimes(); ++i) {
                    try {
                        mailSender.send(mimeMessage);
                        ++success;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Send mail success, {}.", (Object)i);
                        }
                        obj.setTransactionStatus(EmailStatusEnum.SUCCESS.getCode());
                        currentMessage.setSendFlag("Y");
                        this.trySaveTransaction(currentMessage, obj);
                        continue block4;
                    }
                    catch (Exception e) {
                        if (i == mailSender.getTryTimes() - 1) {
                            obj.setTransactionMessage(this.getExceptionStack(e));
                            obj.setTransactionStatus(EmailStatusEnum.ERROR.getCode());
                            currentMessage.setSendFlag("F");
                            this.trySaveTransaction(currentMessage, obj);
                            if (!this.log.isErrorEnabled()) continue;
                            this.log.error("Send mail failed.", (Throwable)e);
                            continue;
                        }
                        Thread.sleep(50L);
                        continue;
                    }
                }
            }
        }
        catch (Exception e) {
            params.put("ERROR_MESSAGE", e.getMessage());
            for (Message message : userEmailToSend) {
                this.error(message, e.getMessage());
            }
            if (this.log.isErrorEnabled()) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        this.prepareSummary(userEmailToSend, params, success);
        return true;
    }

    public void error(Message currentMessage, String msg) {
        MessageTransaction obj = new MessageTransaction();
        Date time = new Date();
        obj.setCreatedBy(-1L);
        obj.setLastUpdatedBy(-1L);
        obj.setCreationDate(time);
        obj.setLastUpdateDate(time);
        obj.setMessageId(currentMessage.getMessageId());
        obj.setObjectVersionNumber(0L);
        obj.setTransactionStatus(EmailStatusEnum.ERROR.getCode());
        obj.setTransactionMessage(msg);
        currentMessage.setSendFlag("F");
        this.trySaveTransaction(currentMessage, obj);
    }

    private void prepareSummary(List<Message> messages, Map<String, Object> param, int success) {
        StringBuilder sb = new StringBuilder();
        if (messages.isEmpty()) {
            sb.append("No Email To Send.");
        } else {
            sb.append("Send ").append(messages.size()).append(" Emails. ");
            sb.append("  Success : " + success);
            Object object = param.get("ERROR_MESSAGE");
            if (object != null) {
                sb.append("  Error :  " + object);
            }
        }
        param.put("summary", sb.toString());
    }

    private void trySaveTransaction(Message message, MessageTransaction obj) {
        for (int i = 0; i < 3; ++i) {
            try {
                ((IEmailService)this.self()).saveTransaction(message, obj);
                return;
            }
            catch (Exception e) {
                if (i != 2 || !this.log.isErrorEnabled()) continue;
                this.log.error("save transaction failed.", (Throwable)e);
                continue;
            }
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, noRollbackFor={Exception.class})
    public void saveTransaction(Message message, MessageTransaction obj) {
        if (message != null) {
            this.messageMapper.updateByPrimaryKeySelective(message);
        }
        if (obj != null) {
            this.transactionMapper.insertSelective(obj);
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    private String setEmailSubject(MailSender mailSender, String subject) {
        if (EnvironmentEnum.SIT.getCode().equals(mailSender.getEnvironment()) || EnvironmentEnum.UAT.getCode().equals(mailSender.getEnvironment())) {
            return "[" + mailSender.getEnvironment() + "] " + subject;
        }
        return subject;
    }

    private String getExceptionStack(Throwable th) {
        return ExceptionUtils.getStackTrace((Throwable)th);
    }
}

