/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.mail.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.core.exception.BaseException;
import com.hand.hap.mail.dto.MessageTemplate;
import com.hand.hap.mail.service.IMessageTemplateService;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sys/messageTemplate", "/api/sys/messageTemplate"})
public class MessageTemplateController
extends BaseController {
    @Autowired
    private IMessageTemplateService service;

    @RequestMapping(value={"/query"})
    @ResponseBody
    public ResponseData getMessageTemplate(HttpServletRequest request, MessageTemplate example, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.selectMessageTemplates(requestContext, example, page, pagesize));
    }

    @ResponseBody
    @RequestMapping(value={"/add"})
    public ResponseData addMessageTemplate(HttpServletRequest request, @RequestBody MessageTemplate obj, BindingResult result) throws BaseException {
        this.getValidator().validate((Object)obj, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestContext = this.createRequestContext(request);
        this.service.createMessageTemplate(requestContext, obj);
        return new ResponseData();
    }

    @ResponseBody
    @RequestMapping(value={"/update"})
    public ResponseData updateMessageTemplate(HttpServletRequest request, @RequestBody MessageTemplate obj, BindingResult result) throws BaseException {
        this.getValidator().validate((Object)obj, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestContext = this.createRequestContext(request);
        this.service.updateMessageTemplate(requestContext, obj);
        return new ResponseData();
    }

    @RequestMapping(value={"/remove"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData deleteMessageTemplate(HttpServletRequest request, @RequestBody List<MessageTemplate> objs) throws BaseException {
        IRequest requestContext = this.createRequestContext(request);
        this.service.batchDelete(requestContext, objs);
        return new ResponseData();
    }
}

