/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.lock.util;

import com.hand.hap.lock.exception.LockException;
import com.hand.hap.mybatis.entity.EntityField;
import com.hand.hap.mybatis.util.StringUtil;
import com.hand.hap.system.dto.DTOClassInfo;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockKeyUtil {
    private static final Logger logger = LoggerFactory.getLogger(LockKeyUtil.class);
    public static final char UNDERLINE = '_';

    public static String camelToUnderline(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append('_');
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getLockKey(Object lockKey) {
        StringBuffer lockKeyStr = new StringBuffer();
        String tableName = DTOClassInfo.getTableName(lockKey.getClass());
        if (StringUtil.isEmpty(tableName)) {
            tableName = lockKey.getClass().getName();
        }
        lockKeyStr.append(tableName + ":");
        EntityField[] fields = DTOClassInfo.getIdFields(lockKey.getClass());
        if (fields.length == 0) {
            logger.error("getIdFields error, maybe not have @ID");
            throw new RuntimeException(new LockException("lock failure", null));
        }
        String ids = "";
        for (EntityField field : fields) {
            try {
                Object object = PropertyUtils.getProperty((Object)lockKey, (String)field.getName());
                if (object == null) {
                    logger.error("get id's value failure,confirm Object has id value");
                    throw new RuntimeException(new LockException("lock failure", null));
                }
                ids = ids + field.getName() + "=" + object.toString() + "&";
            }
            catch (Exception e) {
                logger.error("generate lockKey failure", (Throwable)e);
                throw new RuntimeException(new LockException("lock failure", null));
            }
        }
        ids = ids.substring(0, ids.length() - 1);
        lockKeyStr.append(ids);
        return lockKeyStr.toString();
    }
}

