/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.lock.components;

import com.hand.hap.lock.exception.LockException;
import com.hand.hap.lock.util.LockKeyUtil;
import com.hand.hap.mybatis.entity.EntityField;
import com.hand.hap.mybatis.util.StringUtil;
import com.hand.hap.system.dto.DTOClassInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.persistence.Column;
import javax.sql.DataSource;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Component;

@Component
public class DatabaseLockProvider {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseLockProvider.class);
    private static final String DATABASE_MYSQL = "mysql";
    private static final String DATABASE_ORACLE = "oracle";
    private static final String DATABASE_MSSQL = "mssql";
    private String dbType = "mysql";
    private DataSource dataSource;

    @Autowired
    public DatabaseLockProvider(@Qualifier(value="dataSource") DataSource dataSource) {
        this.dataSource = dataSource;
        try (Connection conn = DataSourceUtils.getConnection((DataSource)dataSource);){
            DatabaseMetaData meta = conn.getMetaData();
            this.dbType = meta.getDatabaseProductName().toLowerCase();
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void lock(Object dto) {
        String tabaleName = DTOClassInfo.getTableName(dto.getClass());
        if (StringUtil.isEmpty(tabaleName)) {
            logger.error("table name is null, dto must has @Table");
            throw new RuntimeException(new LockException("lock failure", null));
        }
        StringBuilder whereCondition = new StringBuilder();
        EntityField[] fields = DTOClassInfo.getIdFields(dto.getClass());
        if (fields.length == 0) {
            logger.error("can not get id field ,dto must has @ID");
            throw new RuntimeException(new LockException("lock failure", null));
        }
        Object[] parms = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            try {
                Object object;
                String idName = "";
                if (fields[i].isAnnotationPresent(Column.class)) {
                    Column column = fields[i].getAnnotation(Column.class);
                    idName = column.name();
                }
                if (StringUtils.isEmpty((String)idName)) {
                    idName = LockKeyUtil.camelToUnderline(fields[i].getName());
                }
                whereCondition.append(idName).append(" = ? ");
                if (i < fields.length - 1) {
                    whereCondition.append(" and ");
                }
                if ((object = PropertyUtils.getProperty((Object)dto, (String)fields[i].getName())) == null) {
                    logger.error("id's value is null");
                    throw new RuntimeException(new LockException("lock failure", null));
                }
                parms[i] = object;
                continue;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        this.lock(tabaleName, whereCondition.toString(), parms);
    }

    public void lock(Object dto, String whereCondition, Object ... whereParameter) {
        String tabaleName = DTOClassInfo.getTableName(dto.getClass());
        if (StringUtil.isEmpty(tabaleName)) {
            logger.error("table name is null, dto must has @Table");
            throw new RuntimeException(new LockException("lock failure", null));
        }
        this.lock(tabaleName, whereCondition, whereParameter);
    }

    public void lock(String tableName, String whereCondition, Object ... whereParameter) {
        Connection conn = DataSourceUtils.getConnection((DataSource)this.dataSource);
        try (PreparedStatement pstmt = conn.prepareStatement(this.getSqlStr(tableName, whereCondition));){
            for (int i = 0; i < whereParameter.length; ++i) {
                pstmt.setObject(i + 1, whereParameter[i]);
            }
            pstmt.execute();
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    String getSqlStr(String tableName, String whereCondition) {
        StringBuilder sb = new StringBuilder();
        sb.append("select * from ").append(tableName).append(" ");
        switch (this.dbType) {
            case "mysql": 
            case "oracle": {
                if (StringUtil.isNotEmpty(whereCondition)) {
                    sb.append(" where ").append(whereCondition);
                }
                sb.append(" for update");
                break;
            }
            case "mssql": {
                sb.append(" with (ROWLOCK) ");
                if (!StringUtil.isNotEmpty(whereCondition)) break;
                sb.append(whereCondition);
            }
        }
        return sb.toString();
    }
}

