/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.job.listener;

import com.hand.hap.job.AbstractJob;
import com.hand.hap.job.dto.JobRunningInfoDto;
import com.hand.hap.job.listener.DefaultJobListener;
import com.hand.hap.job.service.IJobRunningInfoService;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.springframework.context.ApplicationContext;

public class JobRunningListener
extends DefaultJobListener {
    private static final String VETOED = "Vetoed";
    private static final String FINISH = "Finish";
    private static final String FAILED = "Failed";
    private String name = "JobRunningListener";
    private String jobToBeFiredMessage = "Job {1}.{0} fired (by trigger {4}.{3}) at: {2, date, HH:mm:ss MM/dd/yyyy}";
    private String jobSuccessMessage = "Job {1}.{0} execution complete at {2, date, HH:mm:ss MM/dd/yyyy} and reports: {8}";
    private String jobFailedMessage = "Job {1}.{0} execution failed at {2, date, HH:mm:ss MM/dd/yyyy} and reports: {8}";
    private String jobWasVetoedMessage = "Job {1}.{0} was vetoed.  It was to be fired (by trigger {4}.{3}) at: {2, date, HH:mm:ss MM/dd/yyyy}";
    private IJobRunningInfoService jobRunningInfoService;
    private ApplicationContext applicationContext;

    public JobRunningListener(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public String getJobSuccessMessage() {
        return this.jobSuccessMessage;
    }

    public String getJobFailedMessage() {
        return this.jobFailedMessage;
    }

    public String getJobToBeFiredMessage() {
        return this.jobToBeFiredMessage;
    }

    public void setJobSuccessMessage(String jobSuccessMessage) {
        this.jobSuccessMessage = jobSuccessMessage;
    }

    public void setJobFailedMessage(String jobFailedMessage) {
        this.jobFailedMessage = jobFailedMessage;
    }

    public void setJobToBeFiredMessage(String jobToBeFiredMessage) {
        this.jobToBeFiredMessage = jobToBeFiredMessage;
    }

    public String getJobWasVetoedMessage() {
        return this.jobWasVetoedMessage;
    }

    public void setJobWasVetoedMessage(String jobWasVetoedMessage) {
        this.jobWasVetoedMessage = jobWasVetoedMessage;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void jobToBeExecuted(JobExecutionContext context) {
        Job job = context.getJobInstance();
        if (job instanceof JobListener) {
            ((JobListener)job).jobToBeExecuted(context);
        }
        if (!this.getLog().isInfoEnabled()) {
            return;
        }
        Trigger trigger = context.getTrigger();
        Object[] args = new Object[]{context.getJobDetail().getKey().getName(), context.getJobDetail().getKey().getGroup(), new Date(), trigger.getKey().getName(), trigger.getKey().getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), context.getRefireCount()};
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info(MessageFormat.format(this.getJobToBeFiredMessage(), args));
        }
    }

    @Override
    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        Trigger trigger = context.getTrigger();
        Object[] args = null;
        JobRunningInfoDto dto = this.dto(context);
        if (jobException != null) {
            String errMsg = jobException.getMessage();
            args = new Object[]{context.getJobDetail().getKey().getName(), context.getJobDetail().getKey().getGroup(), new Date(), trigger.getKey().getName(), trigger.getKey().getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), context.getRefireCount(), errMsg};
            String message = MessageFormat.format(this.getJobFailedMessage(), args);
            message = StringUtils.abbreviate((String)message, (int)225);
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn(message, (Throwable)jobException);
            }
            dto.setJobStatusMessage(message);
            dto.setJobStatus(FAILED);
        } else {
            String result = String.valueOf(context.getResult());
            args = new Object[]{context.getJobDetail().getKey().getName(), context.getJobDetail().getKey().getGroup(), new Date(), trigger.getKey().getName(), trigger.getKey().getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), context.getRefireCount(), result};
            String message = MessageFormat.format(this.getJobSuccessMessage(), args);
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info(message);
            }
            dto.setJobStatusMessage(message);
            dto.setJobStatus(FINISH);
        }
        this.saveDto(dto);
        Job job = context.getJobInstance();
        if (job instanceof JobListener) {
            context.put((Object)"JOB_RUNNING_INFO_ID", (Object)dto.getJobRunningInfoId());
            ((JobListener)job).jobWasExecuted(context, jobException);
        }
    }

    private JobRunningInfoDto dto(JobExecutionContext context) {
        String schedulerInstanceId;
        Date scheduledFireTime;
        Object result;
        Date previousFireTime;
        Date fireTime;
        String fireInstanceId;
        int refireCount;
        Date nextFireTime;
        String triggerGroup;
        String triggerName;
        String jobGroup;
        String jobName;
        JobRunningInfoDto record;
        block5: {
            record = new JobRunningInfoDto();
            JobDetail jobDetail = context.getJobDetail();
            jobName = jobDetail.getKey().getName();
            jobGroup = jobDetail.getKey().getGroup();
            Trigger trigger = context.getTrigger();
            triggerName = trigger.getKey().getName();
            triggerGroup = trigger.getKey().getGroup();
            nextFireTime = trigger.getNextFireTime();
            refireCount = context.getRefireCount();
            fireInstanceId = context.getFireInstanceId();
            fireTime = context.getFireTime();
            previousFireTime = context.getPreviousFireTime();
            result = context.getResult();
            scheduledFireTime = context.getScheduledFireTime();
            Job jobInstance = context.getJobInstance();
            if (jobInstance instanceof AbstractJob) {
                String executionSummary = ((AbstractJob)jobInstance).getExecutionSummary();
                record.setExecutionSummary(executionSummary);
            }
            schedulerInstanceId = "";
            try {
                schedulerInstanceId = context.getScheduler().getSchedulerInstanceId();
            }
            catch (SchedulerException e) {
                if (!this.getLog().isErrorEnabled()) break block5;
                this.getLog().error(e.getMessage(), (Throwable)e);
            }
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        record.setIpAddress(inetAddress.getHostAddress());
        record.setCreatedBy(1L);
        record.setFireInstanceId(fireInstanceId);
        record.setFireTime(fireTime);
        record.setJobGroup(jobGroup);
        record.setJobName(jobName);
        record.setJobResult(result == null ? "" : String.valueOf(context.getResult()));
        record.setLastUpdatedBy(1L);
        record.setNextFireTime(nextFireTime);
        record.setPreviousFireTime(previousFireTime);
        record.setRefireCount(Long.valueOf(refireCount));
        record.setScheduledFireTime(scheduledFireTime);
        record.setSchedulerInstanceId(schedulerInstanceId);
        record.setTriggerGroup(triggerGroup);
        record.setTriggerName(triggerName);
        return record;
    }

    @Override
    public void jobExecutionVetoed(JobExecutionContext context) {
        Trigger trigger = context.getTrigger();
        Object[] args = new Object[]{context.getJobDetail().getKey().getName(), context.getJobDetail().getKey().getGroup(), new Date(), trigger.getKey().getName(), trigger.getKey().getGroup(), trigger.getPreviousFireTime(), trigger.getNextFireTime(), context.getRefireCount()};
        String message = MessageFormat.format(this.getJobWasVetoedMessage(), args);
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info(message);
        }
        JobRunningInfoDto dto = this.dto(context);
        if (message.length() > 2000) {
            message = message.substring(0, 2000);
        }
        dto.setJobStatusMessage(message);
        dto.setJobStatus(VETOED);
        this.saveDto(dto);
    }

    private void saveDto(JobRunningInfoDto jobCreateDto) {
        this.jobRunningInfoService = (IJobRunningInfoService)this.applicationContext.getBean(IJobRunningInfoService.class);
        this.jobRunningInfoService.createJobRunningInfo(jobCreateDto);
    }
}

