/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.job.listener;

import com.hand.hap.job.listener.DefaultJobListener;
import com.hand.hap.mail.ReceiverTypeEnum;
import com.hand.hap.mail.dto.MessageReceiver;
import com.hand.hap.mail.service.IMessageService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

public class JobNoticeListener
extends DefaultJobListener {
    private static final String VETOED = "Vetoed";
    private static final String EXECUTE_FAILED = "Execute Failed";
    private static final String EXECUTE_FINISH = "Execute Finish";
    private static final String STATUS2 = "status";
    private static final String SCHEDULED_FIRE_TIME = "scheduledFireTime";
    private static final String JOB_NAME = "jobName";
    private static final String JOB_INTERNAL_NOTIFICATION = "job_internal_notification";
    private static final String JOB_INTERNAL_EMAIL_ADDRESS = "job_internal_emailAddress";
    private static final String JOB_INTERNAL_EMAIL_ACCOUNT = "job_internal_email_account";
    private static final String JOB_INTERNAL_EMAIL_TEMPLATE = "job_internal_email_template";
    private String name = "JobNoticeListener";
    private IMessageService messageService;
    private String mailTemplate;

    public JobNoticeListener(String mailTemplate) {
        this.mailTemplate = mailTemplate;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void jobToBeExecuted(JobExecutionContext context) {
    }

    @Override
    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        if (jobException != null) {
            this.sendMail(context, EXECUTE_FAILED);
        } else {
            this.sendMail(context, EXECUTE_FINISH);
        }
    }

    @Override
    public void jobExecutionVetoed(JobExecutionContext context) {
        this.sendMail(context, VETOED);
    }

    private void sendMail(JobExecutionContext context, String status) {
        block7: {
            JobDetail jobDetail = context.getJobDetail();
            String messageAddress = (String)jobDetail.getJobDataMap().get((Object)JOB_INTERNAL_EMAIL_ADDRESS);
            String isSend = (String)jobDetail.getJobDataMap().get((Object)JOB_INTERNAL_NOTIFICATION);
            String templateCode = (String)jobDetail.getJobDataMap().get((Object)JOB_INTERNAL_EMAIL_TEMPLATE);
            if (StringUtils.isNotEmpty((String)templateCode)) {
                this.mailTemplate = templateCode;
            }
            String accountCode = (String)jobDetail.getJobDataMap().get((Object)JOB_INTERNAL_EMAIL_ACCOUNT);
            if (Boolean.valueOf(isSend).booleanValue() && StringUtils.isNotBlank((String)messageAddress)) {
                HashMap<String, Object> templateData = new HashMap<String, Object>();
                String jobName = jobDetail.getKey().getName();
                Date scheduledFireTime = context.getScheduledFireTime();
                templateData.put(JOB_NAME, jobName);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String format = simpleDateFormat.format(scheduledFireTime);
                templateData.put(SCHEDULED_FIRE_TIME, format);
                templateData.put(STATUS2, status);
                String[] addresses = StringUtils.split((String)messageAddress, (String)";");
                ArrayList<MessageReceiver> receivers = new ArrayList<MessageReceiver>();
                for (String address : addresses) {
                    MessageReceiver messageReceiver = new MessageReceiver();
                    messageReceiver.setMessageAddress(address);
                    messageReceiver.setMessageType(ReceiverTypeEnum.NORMAL.getCode());
                    receivers.add(messageReceiver);
                }
                try {
                    WebApplicationContext wac = ContextLoader.getCurrentWebApplicationContext();
                    this.messageService = (IMessageService)wac.getBean("messageServiceImpl");
                    if (StringUtils.isNotEmpty((String)accountCode)) {
                        this.messageService.addEmailMessage(null, accountCode, this.mailTemplate, templateData, null, receivers);
                    } else {
                        this.messageService.sendMessage(null, this.mailTemplate, templateData, receivers, null);
                    }
                }
                catch (Exception e) {
                    if (!this.getLog().isErrorEnabled()) break block7;
                    this.getLog().error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

