/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.intergration.ws.interceptor;

import com.hand.hap.intergration.beans.HapInvokeInfo;
import com.hand.hap.intergration.beans.HapinterfaceBound;
import com.hand.hap.intergration.dto.HapInterfaceInbound;
import com.hand.hap.intergration.dto.HapInterfaceOutbound;
import com.hand.hap.intergration.util.HapInvokeLogUtils;
import com.hand.hap.message.IMessagePublisher;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.Address;
import org.springframework.beans.factory.annotation.Autowired;

@NoJSR250Annotations
public class HapInvokeOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    @Autowired
    private IMessagePublisher messagePublisher;
    public static long DEFAULT_THRESHOLD = 0xA00000L;

    public HapInvokeOutInterceptor() {
        super("pre-stream");
    }

    public void handleMessage(Message message) throws Fault {
        if (message.getContent(Exception.class) == null) {
            HapInterfaceInbound inbound = HapInvokeInfo.INBOUND.get();
            if (inbound != null) {
                this.inboundInvoke(inbound, message);
            } else {
                this.outboundInvoke(message);
            }
        }
    }

    public void handleFault(Message message) {
        HapInterfaceInbound inbound = HapInvokeInfo.INBOUND.get();
        HapInterfaceOutbound outbound = HapInvokeInfo.OUTBOUND.get();
        if (inbound != null) {
            Exception fault = (Exception)message.getContent(Exception.class);
            inbound.setRequestStatus("failure");
            inbound.setResponseTime(System.currentTimeMillis() - HapInvokeInfo.REQUEST_START_TIME.get());
            HapInvokeLogUtils.processExceptionInfo(inbound, (Throwable)fault);
            HapInvokeLogUtils.processRequestInfo(inbound, HapInvokeInfo.HTTP_REQUEST.get());
            this.messagePublisher.publish("invoke.inbound", new HapinterfaceBound(inbound));
            HapInvokeInfo.clearInboundInfo();
            HapInvokeInfo.INBOUND.remove();
        } else if (outbound != null) {
            Exception fault = (Exception)message.getContent(Exception.class);
            HapInvokeLogUtils.processExceptionInfo(outbound, (Throwable)fault);
            this.messagePublisher.publish("invoke.outbound", new HapinterfaceBound(outbound));
            HapInvokeInfo.OUTBOUND.remove();
            HapInvokeInfo.clearOutboundInfo();
        }
    }

    protected void outboundInvoke(Message message) {
        HapInterfaceOutbound outbound = new HapInterfaceOutbound();
        HapInvokeInfo.OUTBOUND.set(outbound);
        HapInvokeInfo.REQUEST_START_TIME.set(System.currentTimeMillis());
        outbound.setRequestTime(new Date());
        Object address = message.get((Object)"http.connection.address");
        String url = address instanceof Address ? ((Address)address).getString() : "";
        outbound.setInterfaceUrl(url);
        Endpoint ep = message.getExchange().getEndpoint();
        EndpointInfo endpoint = ep.getEndpointInfo();
        String serviceName = endpoint.getService().getName().getLocalPart();
        outbound.setInterfaceName(serviceName);
        this.getXmlContent(message);
    }

    protected void inboundInvoke(HapInterfaceInbound inbound, Message message) {
        inbound.setResponseContent(this.getXmlContent(message));
        inbound.setResponseTime(System.currentTimeMillis() - HapInvokeInfo.REQUEST_START_TIME.get());
        inbound.setRequestStatus("success");
        HapInvokeLogUtils.processRequestInfo(inbound, HapInvokeInfo.HTTP_REQUEST.get());
        this.messagePublisher.publish("invoke.inbound", new HapinterfaceBound(inbound));
        HapInvokeInfo.INBOUND.remove();
        HapInvokeInfo.clearInboundInfo();
    }

    protected String getXmlContent(Message message) {
        String content = "";
        try {
            String xml;
            OutputStream os = (OutputStream)message.getContent(OutputStream.class);
            CachedOutputStream cs = new CachedOutputStream(DEFAULT_THRESHOLD);
            message.setContent(OutputStream.class, (Object)cs);
            message.getInterceptorChain().doIntercept(message);
            CachedOutputStream csnew = (CachedOutputStream)message.getContent(OutputStream.class);
            InputStream in = csnew.getInputStream();
            content = xml = IOUtils.toString((InputStream)in);
            HapInterfaceOutbound invokeOut = HapInvokeInfo.OUTBOUND.get();
            if (invokeOut != null) {
                invokeOut.setRequestParameter(content);
            }
            IOUtils.copy((InputStream)new ByteArrayInputStream(xml.getBytes()), (OutputStream)os);
            cs.flush();
            cs.close();
            os.flush();
            message.setContent(OutputStream.class, (Object)os);
            os.close();
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
        return content;
    }
}

