/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.intergration.ws.interceptor;

import com.hand.hap.intergration.beans.HapInvokeInfo;
import com.hand.hap.intergration.beans.HapinterfaceBound;
import com.hand.hap.intergration.dto.HapInterfaceInbound;
import com.hand.hap.intergration.dto.HapInterfaceOutbound;
import com.hand.hap.intergration.util.HapInvokeLogUtils;
import com.hand.hap.message.IMessagePublisher;
import com.hand.hap.mybatis.util.StringUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedWriter;
import org.apache.cxf.io.DelegatingInputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.springframework.beans.factory.annotation.Autowired;

@NoJSR250Annotations
public class HapInvokeInInterceptor
extends AbstractPhaseInterceptor<Message> {
    @Autowired
    private IMessagePublisher messagePublisher;

    public HapInvokeInInterceptor() {
        super("receive");
    }

    public void handleMessage(Message message) throws Fault {
        HapInterfaceOutbound outbound = HapInvokeInfo.OUTBOUND.get();
        if (outbound == null) {
            this.inboundInvoke(message);
        } else {
            this.outboundInvoke(outbound, message);
        }
    }

    public void handleFault(Message message) {
        HapInterfaceOutbound outbound = HapInvokeInfo.OUTBOUND.get();
        HapInterfaceInbound inbound = HapInvokeInfo.INBOUND.get();
        if (inbound != null) {
            Exception fault = (Exception)message.getContent(Exception.class);
            inbound.setRequestStatus("failure");
            inbound.setResponseTime(System.currentTimeMillis() - HapInvokeInfo.REQUEST_START_TIME.get());
            HapInvokeLogUtils.processRequestInfo(inbound, HapInvokeInfo.HTTP_REQUEST.get());
            HapInvokeLogUtils.processExceptionInfo(inbound, (Throwable)fault);
            this.messagePublisher.publish("invoke.inbound", new HapinterfaceBound(inbound));
            HapInvokeInfo.clearInboundInfo();
            HapInvokeInfo.INBOUND.remove();
        } else if (outbound != null) {
            Exception fault = (Exception)message.getContent(Exception.class);
            HapInvokeLogUtils.processExceptionInfo(outbound, (Throwable)fault);
            this.messagePublisher.publish("invoke.outbound", new HapinterfaceBound(outbound));
            HapInvokeInfo.OUTBOUND.remove();
        }
    }

    protected void inboundInvoke(Message message) {
        Long startTime = System.currentTimeMillis();
        HapInterfaceInbound inbound = new HapInterfaceInbound();
        HapInvokeInfo.INBOUND.set(inbound);
        HapInvokeInfo.REQUEST_START_TIME.set(startTime);
        inbound.setRequestTime(new Date());
        this.logRequestInfo(message);
        this.logRequestBody(message);
    }

    protected void outboundInvoke(HapInterfaceOutbound outbound, Message message) {
        Object responseCode = message.get((Object)Message.RESPONSE_CODE);
        if (responseCode != null) {
            outbound.setResponseCode(responseCode.toString());
        }
        if ("200".equalsIgnoreCase(outbound.getResponseCode())) {
            this.logRequestBody(message);
            outbound.setRequestStatus("success");
        } else {
            outbound.setRequestStatus("failure");
        }
        this.messagePublisher.publish("invoke.outbound", new HapinterfaceBound(outbound));
        HapInvokeInfo.OUTBOUND.remove();
        HapInvokeInfo.clearOutboundInfo();
    }

    protected void logRequestBody(Message message) {
        try {
            InputStream is = (InputStream)message.getContent(InputStream.class);
            if (is != null) {
                this.logInputStream(message, is);
            } else {
                Reader reader = (Reader)message.getContent(Reader.class);
                if (reader != null) {
                    this.logReader(message, reader);
                }
            }
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
    }

    protected void logRequestInfo(Message message) {
        String httpMethod = (String)message.get((Object)"org.apache.cxf.request.method");
        HapInterfaceInbound inbound = HapInvokeInfo.INBOUND.get();
        if (httpMethod != null) {
            inbound.setRequestMethod(httpMethod);
        }
        String uri = (String)message.get((Object)"org.apache.cxf.request.uri");
        HttpServletRequest http = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        if (uri != null) {
            if (http.getContextPath() != null) {
                uri = uri.replaceAll(http.getContextPath(), "");
            }
            inbound.setInterfaceUrl(uri);
            String query = (String)message.get((Object)Message.QUERY_STRING);
            if (query != null) {
                inbound.setRequestHeaderParameter(query);
            }
        }
        HapInvokeInfo.HTTP_REQUEST.set(http);
        Endpoint ep = message.getExchange().getEndpoint();
        EndpointInfo endpoint = ep.getEndpointInfo();
        ServiceInfo serviceInfo = endpoint.getService();
        String serviceName = "webService";
        if (serviceInfo != null && StringUtil.isNotEmpty(serviceInfo.getName().getLocalPart())) {
            serviceName = serviceInfo.getName().getLocalPart();
        }
        inbound.setInterfaceName(serviceName);
    }

    protected void logInputStream(Message message, InputStream is) throws Exception {
        CachedOutputStream bos = new CachedOutputStream();
        InputStream bis = is instanceof DelegatingInputStream ? ((DelegatingInputStream)is).getInputStream() : is;
        IOUtils.copy((InputStream)bis, (OutputStream)bos);
        bos.flush();
        bis = bos.getInputStream();
        HapInterfaceOutbound outbound = HapInvokeInfo.OUTBOUND.get();
        HapInterfaceInbound inbound = HapInvokeInfo.INBOUND.get();
        if (inbound != null) {
            inbound.setRequestBodyParameter(IOUtils.toString((InputStream)bos.getInputStream()));
        } else if (outbound != null) {
            outbound.setResponseContent(IOUtils.toString((InputStream)bos.getInputStream()));
        }
        if (is instanceof DelegatingInputStream) {
            ((DelegatingInputStream)is).setInputStream(bis);
        } else {
            message.setContent(InputStream.class, (Object)bis);
        }
        bos.close();
    }

    protected void logReader(Message message, Reader reader) throws Exception {
        CachedWriter writer = new CachedWriter();
        IOUtils.copyAndCloseInput((Reader)reader, (Writer)writer);
        message.setContent(Reader.class, (Object)writer.getReader());
        HapInterfaceOutbound outbound = HapInvokeInfo.OUTBOUND.get();
        HapInterfaceInbound inbound = HapInvokeInfo.INBOUND.get();
        if (outbound == null) {
            inbound.setRequestBodyParameter(IOUtils.toString((Reader)writer.getReader()));
        } else {
            outbound.setResponseContent(IOUtils.toString((Reader)writer.getReader()));
        }
    }
}

