/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.intergration.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.hand.hap.intergration.exception.HapApiException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class JSONAndMap {
    private static ObjectMapper objectMapper = new ObjectMapper();

    private JSONAndMap() {
    }

    public static String jsonToXml(String json, String namespace) throws HapApiException {
        Map map = JSONAndMap.jsonToMap(json);
        String xml = JSONAndMap.map2Xml(map, namespace);
        return xml;
    }

    private static Map jsonToMap(String inbound) throws HapApiException {
        Map map = new HashMap();
        try {
            map = (Map)objectMapper.readValue(inbound, map.getClass());
        }
        catch (IOException e) {
            throw new HapApiException("error.format_MapToXml", "\u8f6c\u6362\u5931\u8d25");
        }
        return map;
    }

    public static String map2Xml(Map map, String namespace) throws HapApiException {
        StringBuilder xmlStr = new StringBuilder();
        try {
            for (Object rootName : map.keySet()) {
                String str;
                Object rootValue = map.get(rootName);
                if (rootValue instanceof Map) {
                    str = JSONAndMap.analysisMap((Map)rootValue, namespace);
                    if (namespace == null) {
                        xmlStr.append("<" + rootName.toString());
                    } else {
                        xmlStr.append("<" + namespace + rootName.toString());
                    }
                    if ("".equals(str)) {
                        xmlStr.append("/>\n");
                        continue;
                    }
                    xmlStr.append(">\n");
                    xmlStr.append(str);
                    if (namespace == null) {
                        xmlStr.append("</" + rootName.toString() + ">\n");
                        continue;
                    }
                    xmlStr.append("</" + namespace + rootName.toString() + ">\n");
                    continue;
                }
                str = JSONAndMap.JudgmentType(rootValue, rootName.toString(), namespace);
                xmlStr.append(str);
            }
        }
        catch (Exception e) {
            throw new HapApiException("error.format_MapToXml", "\u683c\u5f0f\u9519\u8bef");
        }
        return xmlStr.toString();
    }

    public static Map xml2map(String xmlString) throws HapApiException {
        Document doc = null;
        HashMap<String, Object> map = null;
        try {
            doc = DocumentHelper.parseText((String)xmlString);
            Element rootElement = doc.getRootElement();
            map = new HashMap<String, Object>();
            if (rootElement.elements().size() == 0) {
                if (rootElement.getNamespace().getText() != null && rootElement.getNamespace().getText() != "") {
                    HashMap<String, String> childMap = new HashMap<String, String>();
                    for (Object obj : rootElement.declaredNamespaces()) {
                        Namespace ns = (Namespace)obj;
                        childMap.put("@xmlns:" + ns.getPrefix(), ns.getURI());
                    }
                    if (!"".equals(rootElement.getText())) {
                        childMap.put("#text", rootElement.getText());
                    }
                    map.put(JSONAndMap.getName(rootElement), childMap);
                } else {
                    map.put(JSONAndMap.getName(rootElement), rootElement.getText() == "" ? "" : rootElement.getText());
                }
            } else {
                HashMap<String, String> tempMap = new HashMap<String, String>();
                JSONAndMap.ele2map(tempMap, rootElement);
                if (rootElement.getNamespace().getText() != null && rootElement.getNamespace().getText() != "") {
                    for (Object obj : rootElement.declaredNamespaces()) {
                        Namespace ns = (Namespace)obj;
                        tempMap.put("@xmlns:" + ns.getPrefix(), ns.getURI());
                    }
                }
                map.put(JSONAndMap.getName(rootElement), tempMap);
            }
        }
        catch (DocumentException e) {
            throw new HapApiException("error.format_xmlToMap", "\u683c\u5f0f\u9519\u8bef");
        }
        return map;
    }

    public static String analysisMap(Map map, String namespace) {
        StringBuilder xmlStr = new StringBuilder();
        Set objSet = map.keySet();
        for (Object key : objSet) {
            if (key == null || key.toString().trim() == "") continue;
            Object value = map.get(key);
            xmlStr.append(JSONAndMap.JudgmentType(value, key.toString(), namespace));
        }
        return xmlStr.toString();
    }

    public static String analysisCollection(Collection objects, String key, String namespace) {
        StringBuilder xmlStr = new StringBuilder();
        for (Object object : objects) {
            xmlStr.append(JSONAndMap.JudgmentType(object, key, namespace));
        }
        return xmlStr.toString();
    }

    public static String analysisObjectArr(Object[] objects, String key, String namespace) {
        StringBuilder xmlStr = new StringBuilder();
        for (Object object : objects) {
            xmlStr.append(JSONAndMap.JudgmentType(object, key, namespace));
        }
        return xmlStr.toString();
    }

    public static String JudgmentType(Object value, String key, String namespace) {
        StringBuilder xmlStr = new StringBuilder();
        if (JSONAndMap.isBasicTypes(value)) {
            if (value == null) {
                if (namespace == null) {
                    xmlStr.append("<" + key + "/>\n");
                } else {
                    xmlStr.append("<" + namespace + key + "/>\n");
                }
            } else if (namespace == null) {
                xmlStr.append("<" + key + ">");
                xmlStr.append(value);
                xmlStr.append("</" + key + ">\n");
            } else {
                xmlStr.append("<" + namespace + key + ">");
                xmlStr.append(value);
                xmlStr.append("</" + namespace + key + ">\n");
            }
            return xmlStr.toString();
        }
        if (value instanceof Map) {
            if (namespace == null) {
                xmlStr.append("<" + key + ">\n");
                xmlStr.append(JSONAndMap.analysisMap((Map)value, namespace));
                xmlStr.append("\n</" + key + ">");
            } else {
                xmlStr.append("<" + namespace + key + ">\n");
                xmlStr.append(JSONAndMap.analysisMap((Map)value, namespace));
                xmlStr.append("\n</" + namespace + key + ">");
            }
            return xmlStr.toString();
        }
        if (value instanceof Collection) {
            return JSONAndMap.analysisCollection((Collection)value, key, namespace);
        }
        if (value instanceof Object[]) {
            return JSONAndMap.analysisObjectArr((Object[])value, key, namespace);
        }
        if (namespace == null) {
            xmlStr.append("<" + key.toString() + "/>\n");
        } else {
            xmlStr.append("<" + namespace + key.toString() + "/>\n");
        }
        return xmlStr.toString();
    }

    private static boolean isBasicTypes(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return true;
        }
        if (obj instanceof Integer) {
            return true;
        }
        if (obj instanceof Double) {
            return true;
        }
        if (obj instanceof Float) {
            return true;
        }
        if (obj instanceof Byte) {
            return true;
        }
        if (obj instanceof Long) {
            return true;
        }
        if (obj instanceof Character) {
            return true;
        }
        if (obj instanceof Short) {
            return true;
        }
        return obj instanceof Boolean;
    }

    private static void ele2map(Map map, Element ele) {
        List elements = ele.elements();
        if (elements.size() == 1) {
            if (((Element)elements.get(0)).elements().size() == 0) {
                map.put(JSONAndMap.getName((Element)elements.get(0)), ((Element)elements.get(0)).getText() == "" ? "" : ((Element)elements.get(0)).getText());
            } else {
                HashMap tempMap = new HashMap();
                JSONAndMap.ele2map(tempMap, (Element)elements.get(0));
                map.put(JSONAndMap.getName((Element)elements.get(0)), tempMap);
            }
        } else {
            HashMap<String, Boolean> tempMap = new HashMap<String, Boolean>();
            for (Element childElement : elements) {
                String string = JSONAndMap.getName(childElement);
                if (tempMap.get(string) == null) {
                    List elements2 = null;
                    elements2 = string.contains(":") ? ele.elements(childElement.getQName()) : ele.elements(string);
                    if (elements2.size() > 1) {
                        ArrayList<Object> list = new ArrayList<Object>();
                        for (Element element : elements2) {
                            if (element.elements().size() == 0) {
                                list.add(element.getText() == "" ? "" : element.getText());
                                continue;
                            }
                            HashMap tempMap1 = new HashMap();
                            JSONAndMap.ele2map(tempMap1, element);
                            list.add(tempMap1);
                        }
                        map.put(string, list);
                    } else if (elements2.size() > 0) {
                        HashMap tempMap1 = new HashMap();
                        if (((Element)elements2.get(0)).elements().size() == 0) {
                            map.put(string, ((Element)elements2.get(0)).getText() == "" ? "" : ((Element)elements2.get(0)).getText());
                        } else {
                            JSONAndMap.ele2map(tempMap1, (Element)elements2.get(0));
                            map.put(string, tempMap1);
                        }
                    }
                }
                tempMap.put(string, true);
            }
        }
    }

    private static String getName(Element ele) {
        StringBuffer sb = new StringBuffer();
        if (ele.getNamespacePrefix() != null && ele.getNamespacePrefix() != "") {
            sb.append(ele.getNamespacePrefix() + ":");
        }
        sb.append(ele.getName());
        return sb.toString();
    }
}

