/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.intergration.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.cache.impl.ApiConfigCache;
import com.hand.hap.core.IRequest;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.dto.HapInterfaceLine;
import com.hand.hap.intergration.mapper.HapInterfaceHeaderMapper;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import com.hand.hap.intergration.service.IHapInterfaceLineService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class HapInterfaceHeaderServiceImpl
extends BaseServiceImpl<HapInterfaceHeader>
implements IHapInterfaceHeaderService {
    private final Logger logger = LoggerFactory.getLogger(HapInterfaceHeaderServiceImpl.class);
    @Autowired
    private HapInterfaceHeaderMapper hapInterfaceHeaderMapper;
    @Autowired
    private ApiConfigCache apiCache;
    @Autowired
    private IHapInterfaceLineService lineService;

    @Override
    public List<HapInterfaceHeader> getAllHeader(IRequest requestContext, HapInterfaceHeader interfaceHeader, int page, int pagesize) {
        PageHelper.startPage(page, pagesize);
        List<HapInterfaceHeader> list = this.hapInterfaceHeaderMapper.getAllHeader(interfaceHeader);
        return list;
    }

    @Override
    public List<HapInterfaceHeader> getHeaderAndLineList(IRequest requestContext, HapInterfaceHeader interfaceHeader) {
        List<HapInterfaceHeader> list = this.hapInterfaceHeaderMapper.getHeaderAndLineList(interfaceHeader);
        if (list.isEmpty() || list.size() < 0) {
            list = this.hapInterfaceHeaderMapper.getHeaderByHeaderId(interfaceHeader);
        }
        return list;
    }

    @Override
    public HapInterfaceHeader getHeaderAndLine(String sysName, String apiName) {
        this.logger.info("sysName apiName:{}", (Object)(sysName + apiName));
        HapInterfaceHeader headerAndLineDTO = this.apiCache.getValue(sysName + ":" + apiName);
        if (headerAndLineDTO == null) {
            HapInterfaceHeader headerAndLineDTO1 = this.hapInterfaceHeaderMapper.getHeaderAndLineBySysNameAndApiName(sysName, apiName);
            if (headerAndLineDTO1 != null) {
                this.apiCache.setValue(sysName + ":" + apiName, headerAndLineDTO1);
            }
            return headerAndLineDTO1;
        }
        return headerAndLineDTO;
    }

    @Override
    public List<HapInterfaceHeader> getAllHeaderAndLine() {
        return this.hapInterfaceHeaderMapper.getAllHeaderAndLine();
    }

    @Override
    public List<HapInterfaceHeader> getAllHeaderAndLine(int page, int pagesize) {
        PageHelper.startPage(page, pagesize);
        List<HapInterfaceHeader> list = this.hapInterfaceHeaderMapper.getAllHeaderAndLine();
        return list;
    }

    @Override
    public List<HapInterfaceHeader> getHeaderByHeaderId(IRequest requestContext, HapInterfaceHeader HapInterfaceHeader2) {
        return this.hapInterfaceHeaderMapper.getHeaderByHeaderId(HapInterfaceHeader2);
    }

    @Override
    public HapInterfaceHeader getHeaderAndLineByLineId(HapInterfaceHeader headerAndLineDTO) {
        return this.hapInterfaceHeaderMapper.getHeaderAndLineBylineId(headerAndLineDTO);
    }

    @Override
    public int updateHeader(IRequest request, HapInterfaceHeader hmsInterfaceHeader) {
        int result = this.hapInterfaceHeaderMapper.updateByPrimaryKeySelective(hmsInterfaceHeader);
        this.checkOvn(result, hmsInterfaceHeader);
        if (result > 0) {
            this.apiCache.reload();
        }
        return result;
    }

    @Override
    public void createInterface(IRequest iRequest, HapInterfaceHeader interfaceHeader) {
        interfaceHeader.setHeaderId(UUID.randomUUID().toString());
        interfaceHeader.setDescription(interfaceHeader.getName());
        HapInterfaceHeader hapInterfaceHeaderNew = ((IHapInterfaceHeaderService)this.self()).insertSelective(iRequest, interfaceHeader);
        if (interfaceHeader.getLineList() != null) {
            this.processInterfaceLines(iRequest, interfaceHeader);
        }
    }

    @Override
    public void updateInterface(IRequest iRequest, HapInterfaceHeader interfaceHeader) {
        interfaceHeader.setDescription(interfaceHeader.getName());
        ((IHapInterfaceHeaderService)this.self()).updateHeader(iRequest, interfaceHeader);
        if (interfaceHeader.getLineList() != null) {
            this.processInterfaceLines(iRequest, interfaceHeader);
        }
    }

    private void processInterfaceLines(IRequest iRequest, HapInterfaceHeader interfaceHeader) {
        for (HapInterfaceLine line : interfaceHeader.getLineList()) {
            line.setLineDescription(line.getLineName());
            if (line.getLineId() == null) {
                line.setHeaderId(interfaceHeader.getHeaderId());
                line.setLineId(UUID.randomUUID().toString());
                this.lineService.insertLine(iRequest, line);
                continue;
            }
            this.lineService.updateLine(iRequest, line);
        }
    }

    @Override
    public List<HapInterfaceHeader> batchUpdate(IRequest request, List<HapInterfaceHeader> interfaces) {
        for (HapInterfaceHeader interfaceHeader : interfaces) {
            if (interfaceHeader.getHeaderId() == null) {
                ((IHapInterfaceHeaderService)this.self()).createInterface(request, interfaceHeader);
                continue;
            }
            ((IHapInterfaceHeaderService)this.self()).updateInterface(request, interfaceHeader);
        }
        return interfaces;
    }
}

