/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.intergration.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.intergration.dto.HapInterfaceLine;
import com.hand.hap.intergration.service.IHapInterfaceLineService;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sys/api", "/sys/interface", "/api/sys/interface"})
public class HapInterfaceLineController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(HapInterfaceLineController.class);
    @Autowired
    private IHapInterfaceLineService lineService;

    @RequestMapping(value={"/queryLine"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData getLineList(HttpServletRequest request, @ModelAttribute HapInterfaceLine lineAndLineTlDTO) {
        this.logger.info("query line by LineAndLineTlDTO  lineId:{}", (Object)lineAndLineTlDTO.getLineId());
        IRequest iRequest = this.createRequestContext(request);
        return new ResponseData(this.lineService.getLineAndLineTl(iRequest, lineAndLineTlDTO));
    }

    @RequestMapping(value={"/insertLine"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData insertLine(HttpServletRequest request, @RequestBody List<HapInterfaceLine> hmsInterfaceLines, BindingResult result) {
        this.getValidator().validate(hmsInterfaceLines, (Errors)result);
        if (result.hasErrors()) {
            ResponseData rd = new ResponseData(false);
            rd.setMessage(this.getErrorMessage((Errors)result, request));
            return rd;
        }
        IRequest iRequest = this.createRequestContext(request);
        for (HapInterfaceLine hmsInterfaceLine : hmsInterfaceLines) {
            hmsInterfaceLine.setLineId(UUID.randomUUID().toString());
            hmsInterfaceLine.setLineDescription(hmsInterfaceLine.getLineName());
            int updateRow = this.lineService.insertLine(iRequest, hmsInterfaceLine);
            if (updateRow > 0) continue;
            return new ResponseData(false);
        }
        return new ResponseData(hmsInterfaceLines);
    }

    @RequestMapping(value={"/updateLine"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData updateLine(HttpServletRequest request, @RequestBody List<HapInterfaceLine> hmsInterfaceLines, BindingResult result) {
        this.getValidator().validate(hmsInterfaceLines, (Errors)result);
        if (result.hasErrors()) {
            ResponseData rd = new ResponseData(false);
            rd.setMessage(this.getErrorMessage((Errors)result, request));
            return rd;
        }
        IRequest iRequest = this.createRequestContext(request);
        for (HapInterfaceLine hmsInterfaceLine : hmsInterfaceLines) {
            hmsInterfaceLine.setLineDescription(hmsInterfaceLine.getLineName());
            int updateRow = this.lineService.updateLine(iRequest, hmsInterfaceLine);
            if (updateRow > 0) continue;
            return new ResponseData(false);
        }
        return new ResponseData(hmsInterfaceLines);
    }

    @RequestMapping(value={"/deleteLine"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData deleteLine(HttpServletRequest request, @RequestBody List<HapInterfaceLine> interfaceLines) {
        this.logger.info("delete line by hmsInterfaceLine  size:", (Object)interfaceLines.size());
        this.lineService.batchDelete(interfaceLines);
        return new ResponseData();
    }

    @RequestMapping(value={"/getLinesByHeaderId"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData getLinesByHeaderId(HttpServletRequest request, HapInterfaceLine lineAndLineTlDTO, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        IRequest iRequest = this.createRequestContext(request);
        return new ResponseData(this.lineService.getLinesByHeaderId(iRequest, lineAndLineTlDTO, page, pagesize));
    }
}

