/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.intergration.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.intergration.dto.HapInterfaceInbound;
import com.hand.hap.intergration.dto.HapInterfaceOutbound;
import com.hand.hap.message.components.InvokeLogManager;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sys/invoke", "/api/sys/invoke"})
public class HapInterfaceInvokeController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(HapInterfaceInvokeController.class);
    @Autowired
    private InvokeLogManager logManager;

    @RequestMapping(value={"/querryInbound"}, produces={"application/json"})
    @ResponseBody
    public ResponseData queryInbound(@RequestBody HapInterfaceInbound inbound, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.logManager.getInvokeLogStrategy().queryInbound(requestContext, inbound, inbound.getPage(), inbound.getPagesize()));
    }

    @RequestMapping(value={"/querryOutbound"})
    @ResponseBody
    public ResponseData queryOutbound(@RequestBody HapInterfaceOutbound outbound, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.logManager.getInvokeLogStrategy().queryOutbound(requestContext, outbound, outbound.getPage(), outbound.getPagesize()));
    }
}

