/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.hr.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.hr.dto.Employee;
import com.hand.hap.hr.dto.UserAndRoles;
import com.hand.hap.hr.service.IEmployeeService;
import com.hand.hap.mybatis.common.Criteria;
import com.hand.hap.mybatis.common.query.Comparison;
import com.hand.hap.mybatis.common.query.WhereField;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/hr/employee", "/api/hr/employee"})
public class EmployeeController
extends BaseController {
    @Autowired
    private IEmployeeService employeeService;

    @RequestMapping(value={"/query"})
    @ResponseBody
    public ResponseData query(Employee employee, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        Criteria criteria = new Criteria(employee);
        criteria.where(new WhereField("employeeCode", Comparison.LIKE), "employeeId", "name");
        return new ResponseData(this.employeeService.selectOptions(requestContext, employee, criteria, page, pagesize));
    }

    @RequestMapping(value={"/queryAll"})
    @ResponseBody
    public ResponseData queryAll(Employee employee, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.employeeService.queryAll(requestContext, employee, page, pagesize));
    }

    @RequestMapping(value={"/submit"})
    @ResponseBody
    public ResponseData submit(@RequestBody List<Employee> employees, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(employees, (Errors)result);
        if (result.hasErrors()) {
            ResponseData rd = new ResponseData(false);
            rd.setMessage(this.getErrorMessage((Errors)result, request));
            return rd;
        }
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.employeeService.submit(requestContext, employees));
    }

    @RequestMapping(value={"/create_user"})
    @ResponseBody
    public ResponseData createUserByEmployee(@RequestBody UserAndRoles userAndRoles, HttpServletRequest request) {
        IRequest request1 = this.createRequestContext(request);
        this.employeeService.createUserByEmployee(request1, userAndRoles);
        return new ResponseData();
    }

    @RequestMapping(value={"/update_user"})
    @ResponseBody
    public ResponseData updateUser(@RequestBody UserAndRoles userAndRoles, HttpServletRequest request) {
        IRequest irequest = this.createRequestContext(request);
        this.employeeService.updateUser(irequest, userAndRoles);
        return new ResponseData();
    }
}

