/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.function.service.impl;

import com.hand.hap.cache.Cache;
import com.hand.hap.cache.CacheManager;
import com.hand.hap.cache.impl.ResourceCustomizationCache;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.annotation.StdWho;
import com.hand.hap.function.dto.Resource;
import com.hand.hap.function.mapper.FunctionResourceMapper;
import com.hand.hap.function.mapper.ResourceMapper;
import com.hand.hap.function.service.IResourceService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Transactional
@Service
public class ResourceServiceImpl
extends BaseServiceImpl<Resource>
implements IResourceService {
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private ResourceMapper resourceMapper;
    @Autowired
    private FunctionResourceMapper functionResourceMapper;
    @Autowired
    private ResourceCustomizationCache resourceCustomizationCache;

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public Resource selectResourceByUrl(String url) {
        if (StringUtils.isEmpty((Object)url)) {
            return null;
        }
        Cache<Resource> cache = this.getResourceByURL();
        Resource resource = cache.getValue(url);
        if (resource == null && (resource = this.resourceMapper.selectResourceByUrl(url)) != null) {
            this.flushCache(resource);
        }
        return resource;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public Resource selectResourceById(Long id) {
        if (id == null) {
            return null;
        }
        Cache<Resource> cache = this.getResourceById();
        Resource resource = cache.getValue(id.toString());
        if (resource == null) {
            resource = (Resource)this.resourceMapper.selectByPrimaryKey(id);
            this.flushCache(resource);
        }
        return resource;
    }

    @Override
    public Resource insertSelective(IRequest request, Resource resource) {
        if (StringUtils.isEmpty((Object)resource.getUrl())) {
            return null;
        }
        this.resourceMapper.insertSelective(resource);
        this.flushCache(resource);
        return resource;
    }

    private Cache<Resource> getResourceByURL() {
        return this.cacheManager.getCache("resource_url");
    }

    private Cache<Resource> getResourceById() {
        return this.cacheManager.getCache("resource_id");
    }

    private void flushCache(Resource resource) {
        if (resource == null) {
            return;
        }
        Cache<Resource> resourceCache = this.getResourceByURL();
        resourceCache.setValue(resource.getUrl(), resource);
        Cache<Resource> resourceCache2 = this.getResourceById();
        resourceCache2.setValue(resource.getResourceId().toString(), resource);
    }

    private void removeCache(Resource resource) {
        if (resource == null) {
            return;
        }
        Cache<Resource> resourceCache = this.getResourceByURL();
        resourceCache.remove(resource.getUrl());
        Cache<Resource> resourceCache2 = this.getResourceById();
        resourceCache2.remove(resource.getResourceId().toString());
        this.resourceCustomizationCache.remove(resource.getResourceId().toString());
    }

    @Override
    public List<Resource> batchUpdate(IRequest requestContext, List<Resource> resources) {
        for (Resource resource : resources) {
            if (resource.getResourceId() != null) {
                ((IResourceService)this.self()).updateByPrimaryKeySelective(requestContext, resource);
                continue;
            }
            ((IResourceService)this.self()).insertSelective(requestContext, resource);
        }
        return resources;
    }

    @Override
    public Resource updateByPrimaryKeySelective(IRequest request, @StdWho Resource record) {
        record = super.updateByPrimaryKeySelective(request, record);
        this.flushCache(record);
        return record;
    }

    @Override
    public int deleteByPrimaryKey(Resource resource) {
        if (resource == null || resource.getResourceId() == null || StringUtils.isEmpty((Object)resource.getUrl())) {
            return 0;
        }
        this.functionResourceMapper.deleteByResource(resource);
        int updateCount = this.resourceMapper.deleteByPrimaryKey(resource);
        this.checkOvn(updateCount, resource);
        this.removeCache(resource);
        return 1;
    }

    @Override
    public void batchDelete(IRequest requestContext, List<Resource> resources) {
        if (resources == null || resources.isEmpty()) {
            return;
        }
        for (Resource resource : resources) {
            ((IResourceService)this.self()).deleteByPrimaryKey(resource);
        }
    }
}

