/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.function.service.impl;

import com.hand.hap.cache.impl.ResourceItemAssignCache;
import com.hand.hap.cache.impl.ResourceItemCache;
import com.hand.hap.cache.impl.ResourceItemElementCache;
import com.hand.hap.cache.impl.RoleResourceItemCache;
import com.hand.hap.core.IRequest;
import com.hand.hap.function.dto.Resource;
import com.hand.hap.function.dto.ResourceItem;
import com.hand.hap.function.mapper.ResourceItemAssignMapper;
import com.hand.hap.function.mapper.ResourceItemElementMapper;
import com.hand.hap.function.mapper.ResourceItemMapper;
import com.hand.hap.function.mapper.RoleResourceItemMapper;
import com.hand.hap.function.service.IResourceItemService;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service
public class ResourceItemServiceImpl
extends BaseServiceImpl<ResourceItem>
implements IResourceItemService {
    @Autowired
    private ResourceItemMapper resourceItemMapper;
    @Autowired
    private RoleResourceItemMapper roleResourceItemMapper;
    @Autowired
    private ResourceItemCache resourceItemCache;
    @Autowired
    private RoleResourceItemCache roleResourceItemCache;
    @Autowired
    private ResourceItemElementMapper resourceItemElementMapper;
    @Autowired
    private ResourceItemAssignMapper resourceItemAssignMapper;
    @Autowired
    private ResourceItemElementCache resourceItemElementCache;
    @Autowired
    private ResourceItemAssignCache resourceItemAssignCache;

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ResourceItem insertSelective(IRequest request, ResourceItem resourceItem) {
        if (resourceItem == null) {
            return null;
        }
        super.insertSelective(request, resourceItem);
        this.resourceItemCache.load(resourceItem.getOwnerResourceId().toString());
        return resourceItem;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public ResourceItem updateByPrimaryKey(IRequest request, ResourceItem resourceItem) {
        if (resourceItem == null) {
            return null;
        }
        super.updateByPrimaryKey(request, resourceItem);
        this.resourceItemCache.load(resourceItem.getOwnerResourceId().toString());
        return resourceItem;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<ResourceItem> selectResourceItems(IRequest request, Resource resource) {
        return this.resourceItemMapper.selectResourceItemsByResourceId(resource);
    }

    @Override
    public List<ResourceItem> batchUpdate(IRequest request, List<ResourceItem> resourceItems) {
        if (resourceItems == null || resourceItems.isEmpty()) {
            return resourceItems;
        }
        for (ResourceItem resourceItem : resourceItems) {
            if (resourceItem.getResourceItemId() == null) {
                ((IResourceItemService)this.self()).insertSelective(request, resourceItem);
                continue;
            }
            ((IResourceItemService)this.self()).updateByPrimaryKey(request, resourceItem);
        }
        return resourceItems;
    }

    @Override
    public void batchDelete(IRequest requestContext, List<ResourceItem> resourceItems) {
        Long roleId = requestContext.getRoleId();
        if (resourceItems == null || resourceItems.isEmpty()) {
            return;
        }
        for (ResourceItem resourceItem : resourceItems) {
            int updateCount = this.resourceItemMapper.deleteByPrimaryKey(resourceItem);
            this.checkOvn(updateCount, resourceItem);
            this.roleResourceItemMapper.deleteByResourceItemId(resourceItem.getResourceItemId());
            this.resourceItemAssignMapper.deleteByResourceItemId(resourceItem.getResourceItemId());
            this.resourceItemElementMapper.deleteByResourceItemId(resourceItem.getResourceItemId());
            this.resourceItemCache.load(resourceItem.getOwnerResourceId().toString());
            this.resourceItemElementCache.load(resourceItem.getResourceItemId());
        }
    }

    @Override
    public ResourceItem selectResourceItemByResourceIdAndItemId(ResourceItem resourceItem) {
        return this.resourceItemMapper.selectResourceItemByResourceIdAndItemId(resourceItem);
    }
}

