/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.function.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.core.exception.BaseException;
import com.hand.hap.function.dto.MenuItem;
import com.hand.hap.function.dto.ResourceItemAssign;
import com.hand.hap.function.dto.RoleFunction;
import com.hand.hap.function.service.IFunctionService;
import com.hand.hap.function.service.IRoleFunctionService;
import com.hand.hap.function.service.IRoleResourceItemService;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sys/rolefunction", "/api/sys/rolefunction"})
public class RoleFunctionController
extends BaseController {
    @Autowired
    private IRoleFunctionService roleFunctionService;
    @Autowired
    private IFunctionService functionService;
    @Autowired
    private IRoleResourceItemService roleResourceItemService;

    @RequestMapping(value={"/query"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData selectRoleFuntion(HttpServletRequest request, @RequestParam(required=false) Long roleId) throws BaseException {
        IRequest requestContext = this.createRequestContext(request);
        List<MenuItem> menus = this.functionService.selectAllMenus(requestContext);
        if (roleId != null) {
            Long[] ids = this.roleFunctionService.getRoleFunctionById(roleId);
            this.updateMenuCheck(menus, ids);
        }
        return new ResponseData(menus);
    }

    private void updateMenuCheck(List<MenuItem> menus, Long[] ids) {
        if (menus == null || ids == null) {
            return;
        }
        for (MenuItem menuItem : menus) {
            if (menuItem.getChildren() != null && !menuItem.getChildren().isEmpty()) {
                this.updateMenuCheck(menuItem.getChildren(), ids);
            }
            for (Long id : ids) {
                if (!menuItem.getId().equals(id)) continue;
                menuItem.setIschecked(Boolean.TRUE);
            }
        }
    }

    @RequestMapping(value={"/submit"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData submit(HttpServletRequest request, @RequestBody List<RoleFunction> records) throws BaseException {
        return new ResponseData(this.roleFunctionService.batchUpdate(this.createRequestContext(request), records));
    }

    @RequestMapping(value={"/queryResourceItems"})
    @ResponseBody
    public ResponseData queryResourceItems(HttpServletRequest request, @RequestParam(required=false) Long roleId, @RequestParam(required=false) Long functionId) {
        return new ResponseData(this.roleResourceItemService.queryResourceItems(this.createRequestContext(request), roleId, functionId));
    }

    @RequestMapping(value={"/submitResourceItems"})
    @ResponseBody
    public ResponseData submitResourceItems(HttpServletRequest request, @RequestBody List<ResourceItemAssign> resourceItemAssignList, @RequestParam(required=false) Long roleId, @RequestParam(required=false) Long functionId) {
        return new ResponseData(this.roleResourceItemService.updateResourceItemAssign(this.createRequestContext(request), resourceItemAssignList, roleId, functionId));
    }
}

