/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.function.controllers;

import com.hand.hap.core.exception.BaseException;
import com.hand.hap.function.dto.ResourceCustomization;
import com.hand.hap.function.service.IResourceCustomizationService;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sys/resourceCustomization", "/api/sys/resourceCustomization"})
public class ResourceCustomizationController
extends BaseController {
    @Autowired
    private IResourceCustomizationService resourceCustomizationService;

    @RequestMapping(value={"/query"})
    @ResponseBody
    public ResponseData selectResourcePathByResourceId(Long resourceId, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize, HttpServletRequest request) {
        return new ResponseData(this.resourceCustomizationService.selectResourceCustomizationsByResourceId(resourceId));
    }

    @RequestMapping(value={"/submit"})
    @ResponseBody
    public ResponseData submitResourcePath(HttpServletRequest request, @RequestBody List<ResourceCustomization> resourceCustomizations, BindingResult result) throws BaseException {
        this.getValidator().validate(resourceCustomizations, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        return new ResponseData(this.resourceCustomizationService.batchUpdate(this.createRequestContext(request), resourceCustomizations));
    }

    @RequestMapping(value={"/remove"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData deleteResourcePath(HttpServletRequest request, @RequestBody List<ResourceCustomization> resourcePaths) throws BaseException {
        this.resourceCustomizationService.batchDelete(resourcePaths);
        return new ResponseData();
    }
}

