/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.fnd.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.fnd.dto.Company;
import com.hand.hap.fnd.service.ICompanyService;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/fnd/company", "/api/fnd/company"})
public class CompanyController
extends BaseController {
    @Autowired
    ICompanyService companyService;

    @RequestMapping(value={"/query"})
    @ResponseBody
    public ResponseData select(Company company, HttpServletRequest request, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.companyService.selectOptions(requestCtx, company, null, page, pagesize));
    }

    @RequestMapping(value={"/submit", "/update"})
    @ResponseBody
    public ResponseData update(@RequestBody List<Company> companies, BindingResult result, HttpServletRequest request) {
        IRequest requestCtx = this.createRequestContext(request);
        this.getValidator().validate(companies, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        return new ResponseData(this.companyService.batchUpdate(requestCtx, companies));
    }

    @RequestMapping(value={"/remove"})
    @ResponseBody
    public ResponseData delete(@RequestBody List<Company> companies, HttpServletRequest request) {
        this.companyService.batchDelete(companies);
        return new ResponseData();
    }
}

