/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.flexfield.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.flexfield.dto.FlexRule;
import com.hand.hap.flexfield.service.IFlexRuleService;
import com.hand.hap.flexfield.service.impl.FlexRuleServiceImpl;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.support.RequestContextUtils;

@Controller
@RequestMapping(value={"/fnd/flex/rule", "/api/fnd/flex/rule"})
public class FlexRuleController
extends BaseController {
    @Autowired
    private IFlexRuleService service;
    @Autowired
    private MessageSource messageSource;

    @RequestMapping(value={"/query"})
    @ResponseBody
    public ResponseData query(FlexRule dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value={"/matching"})
    @ResponseBody
    public ResponseData matchingRule(String ruleSetCode, @RequestBody JSONObject viewModel, HttpServletRequest request) {
        Set entrySet = viewModel.entrySet();
        ResponseData responseData = this.service.matchingRule(ruleSetCode, entrySet);
        if (null == responseData.getRows()) {
            return responseData;
        }
        List<?> warpFlexRuleFields = responseData.getRows();
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        warpFlexRuleFields.forEach(v -> FlexRuleServiceImpl.setPrompt(v, locale, this.messageSource));
        return responseData;
    }

    @RequestMapping(value={"/submit"})
    @ResponseBody
    public ResponseData update(@RequestBody List<FlexRule> dto, HttpServletRequest request, BindingResult result) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.service.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value={"/remove"})
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<FlexRule> dto) {
        this.service.deleteRule(dto);
        return new ResponseData();
    }
}

