/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.excel.service.impl;

import com.hand.hap.excel.ExcelException;
import com.hand.hap.excel.service.IHapExcelImportService;
import com.hand.hap.excel.service.impl.DefaultRowStrategy;
import com.hand.hap.excel.service.impl.ExcelUtil;
import com.hand.hap.mybatis.entity.EntityColumn;
import com.hand.hap.mybatis.entity.EntityTable;
import com.hand.hap.mybatis.mapperhelper.EntityHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class HapExcelImportService
implements IHapExcelImportService {
    @Autowired
    @Qualifier(value="dataSource")
    DataSource dataSource;
    ThreadLocal<DefaultRowStrategy> defaultRowStrategy = ThreadLocal.withInitial(() -> new DefaultRowStrategy(this.dataSource));

    @Override
    public void loadExcel(InputStream inputStream, String tableName) throws ExcelException {
        DefaultRowStrategy rowStrategy = this.defaultRowStrategy.get();
        rowStrategy.setTableName(tableName);
        ExcelUtil excelUtil = new ExcelUtil(rowStrategy);
        excelUtil.process(inputStream);
    }

    private void createExcelTemplate(String tableName, OutputStream outputStream) throws IOException {
        EntityTable entityTable = EntityHelper.getEntityTable(tableName);
        SXSSFWorkbook wb = new SXSSFWorkbook(50);
        SXSSFSheet sheet = wb.createSheet();
        sheet.createRow(0).createCell(0).setCellValue("*");
        SXSSFRow firstRow = sheet.createRow(1);
        Set<EntityColumn> entityColumn = entityTable.getAllColumns();
        int columnSize = entityColumn.size();
        EntityColumn[] columns = entityColumn.toArray(new EntityColumn[columnSize]);
        ArrayList pkColumns = new ArrayList();
        entityTable.getEntityClassPKColumns().forEach(v -> {
            if (null != v.getGenerator()) {
                pkColumns.add(v.getColumn());
            }
        });
        int index = 0;
        for (int i = 0; i < columns.length; ++i) {
            String name = columns[i].getColumn();
            if ("OBJECT_VERSION_NUMBER".equalsIgnoreCase(name) || "REQUEST_ID".equalsIgnoreCase(name) || "PROGRAM_ID".equalsIgnoreCase(name) || "CREATED_BY".equalsIgnoreCase(name) || "CREATION_DATE".equalsIgnoreCase(name) || "LAST_UPDATED_BY".equalsIgnoreCase(name) || "LAST_UPDATE_DATE".equalsIgnoreCase(name) || "LAST_UPDATE_LOGIN".equalsIgnoreCase(name) || pkColumns.contains(name)) continue;
            SXSSFCell firstCell = firstRow.createCell(index++);
            firstCell.setCellValue(name);
        }
        try {
            wb.write(outputStream);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            wb.close();
        }
    }

    @Override
    public void exportExcelTemplate(String tableName, HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest) throws IOException {
        this.setExcelHeader(httpServletResponse, httpServletRequest, "template");
        this.createExcelTemplate(tableName, (OutputStream)httpServletResponse.getOutputStream());
    }

    private void setExcelHeader(HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest, String fileName) throws UnsupportedEncodingException {
        String name = fileName + ".xlsx";
        String userAgent = httpServletRequest.getHeader("User-Agent");
        name = userAgent.contains("Firefox") ? new String(name.getBytes("UTF-8"), "ISO8859-1") : URLEncoder.encode(name, "UTF-8");
        httpServletResponse.addHeader("Content-Disposition", "attachment; filename=\"" + name + "\"");
        httpServletResponse.setContentType("application/vnd.ms-excel;charset=UTF-8");
        httpServletResponse.setHeader("Accept-Ranges", "bytes");
    }
}

