/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.excel.service.impl;

import com.hand.hap.excel.ExcelException;
import com.hand.hap.excel.dto.ColumnInfo;
import com.hand.hap.excel.service.ExcelRowStrategy;
import com.hand.hap.generator.service.impl.DBUtil;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRowStrategy
implements ExcelRowStrategy {
    DataSource dataSource;
    List<ColumnInfo> columnInfos = new ArrayList<ColumnInfo>();
    private StringBuffer sql;
    private String tableName;
    private List<String> columnName;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private int batchCount = 0;
    private int MaxBach = 1000;
    private Connection connection;
    private PreparedStatement stmt;

    public DefaultRowStrategy(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public void optRow(int sheetIndex, int curRow, List<String> rowList) throws ExcelException {
        if (!(this.rowIsBlank(rowList) || sheetIndex == 0 && curRow == 0)) {
            if (sheetIndex == 0 && curRow == 1) {
                this.columnName = new ArrayList<String>(rowList);
                try {
                    this.readColumnType(this.tableName);
                }
                catch (SQLException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    throw new ExcelException(null, "\u5217\u4fe1\u606f\u8bfb\u53d6\u5931\u8d25", null);
                }
                if (!this.isContains(this.columnInfos, rowList)) {
                    throw new ExcelException(null, "excel\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff1a\u975e\u6cd5\u7684\u5217\u5b58\u5728", null);
                }
                this.sql = new StringBuffer("insert into ");
                this.sql.append(this.tableName).append(" (");
                this.createSql(rowList);
                try {
                    this.connection = this.dataSource.getConnection();
                    this.connection.setAutoCommit(false);
                    this.stmt = this.connection.prepareStatement(this.sql.toString());
                }
                catch (SQLException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    throw new ExcelException(null, "\u6570\u636e\u5e93\u94fe\u63a5\u5931\u8d25", null);
                }
            }
            this.logger.info("\u6b63\u5728\u5904\u7406\u7b2c" + sheetIndex + "\u9875\uff0c\u7b2c" + curRow + "\u884c\u6570\u636e");
            this.createPreparedStatement(this.stmt, rowList);
            ++this.batchCount;
        }
    }

    @Override
    public void doService() throws ExcelException {
        this.insertData(this.stmt);
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.rollback();
            throw new ExcelException(null, "\u6570\u636e\u63d2\u5165\u5931\u8d25", null);
        }
        finally {
            this.closeConnection();
            this.cleanData();
        }
        this.logger.info("\u6570\u636e\u63d2\u5165\u6210\u529f");
    }

    private void readColumnType(String tableName) throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            ResultSet resultSet = DBUtil.getTableColumnInfo(tableName, connection.getMetaData());
            while (resultSet.next()) {
                ColumnInfo columnInfo = new ColumnInfo();
                String typeName = resultSet.getString("TYPE_NAME");
                String columnName = resultSet.getString("COLUMN_NAME");
                columnInfo.setName(columnName);
                columnInfo.setType(typeName);
                this.columnInfos.add(columnInfo);
            }
            resultSet.close();
        }
        catch (SQLException e) {
            this.logger.error("\u8bfb\u53d6\u5217\u4fe1\u606f\u5931\u8d25");
            throw new SQLException(e);
        }
    }

    private boolean isContains(List<ColumnInfo> columnInfos, List<String> row) {
        boolean result = true;
        for (String cell : row) {
            boolean key = false;
            for (ColumnInfo columnInfo : columnInfos) {
                if (!"".equals(cell) && ("".equals(cell) || !cell.equalsIgnoreCase(columnInfo.getName()))) continue;
                key = true;
                break;
            }
            if (key) continue;
            result = false;
            break;
        }
        return result;
    }

    private void createSql(List<String> cells) {
        for (String cell : cells) {
            if ("".equals(cell)) continue;
            this.sql.append(cell).append(",");
        }
        this.sql.deleteCharAt(this.sql.length() - 1);
        this.sql.append(") values(");
        for (String cell : cells) {
            if ("".equals(cell)) continue;
            this.sql.append("?,");
        }
        this.sql.deleteCharAt(this.sql.length() - 1);
        this.sql.append(")");
    }

    private void createPreparedStatement(PreparedStatement stmt, List<String> row) throws ExcelException {
        int index = 1;
        for (int i = 0; i < row.size(); ++i) {
            String column = this.columnName.get(i);
            if ("".equals(column)) continue;
            String type = "STRING";
            for (ColumnInfo columnInfo : this.columnInfos) {
                if (!columnInfo.getName().equalsIgnoreCase(column)) continue;
                type = columnInfo.getType();
                break;
            }
            this.addBatch(stmt, row.get(i), index++, type);
        }
        try {
            stmt.addBatch();
        }
        catch (SQLException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ExcelException(null, "addBatch\u5931\u8d25", null);
        }
        if (this.batchCount > this.MaxBach) {
            this.insertData(stmt);
            this.batchCount = 0;
        }
    }

    private void insertData(PreparedStatement statement) throws ExcelException {
        try {
            statement.executeBatch();
        }
        catch (SQLException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.rollback();
            this.closeConnection();
            this.cleanData();
            throw new ExcelException(null, "sql\u6267\u884c\u5931\u8d25", null);
        }
    }

    private void cleanData() {
        this.columnInfos = new ArrayList<ColumnInfo>();
        this.sql = null;
        this.tableName = null;
        this.columnName = null;
        this.batchCount = 0;
    }

    private void closeConnection() throws ExcelException {
        try {
            this.stmt.close();
            this.connection.close();
        }
        catch (SQLException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ExcelException(null, "\u6570\u636e\u5e93\u4f1a\u8bdd\u5173\u95ed\u5931\u8d25", null);
        }
    }

    private void rollback() throws ExcelException {
        try {
            this.logger.info("\u6570\u636e\u5e93\u63d2\u5165\u5931\u8d25\uff0c\u6570\u636e\u56de\u6eda\u3002\u3002\u3002");
            this.connection.rollback();
        }
        catch (SQLException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ExcelException(null, "\u6570\u636e\u56de\u6eda\u5931\u8d25", null);
        }
    }

    private void addBatch(PreparedStatement stmt, String cell, int index, String type) throws ExcelException {
        try {
            if (!"".equals(cell)) {
                switch (type) {
                    case "DATE": 
                    case "TIMESTAMP": 
                    case "DATETIME": 
                    case "TIME": {
                        stmt.setDate(index, Date.valueOf(cell));
                        break;
                    }
                    case "DOUBLE": {
                        stmt.setDouble(index, Double.valueOf(cell));
                        break;
                    }
                    case "FLOAT": {
                        stmt.setFloat(index, Float.valueOf(cell).floatValue());
                        break;
                    }
                    case "DECIMAL": {
                        stmt.setBigDecimal(index, BigDecimal.valueOf(Double.valueOf(cell)));
                        break;
                    }
                    case "BIGINT": 
                    case "INT": 
                    case "NUMBER": 
                    case "INTEGER": 
                    case "TINYINT": {
                        stmt.setInt(index, Integer.valueOf(cell));
                        break;
                    }
                    default: {
                        stmt.setString(index, cell);
                        break;
                    }
                }
            } else {
                switch (type.toUpperCase()) {
                    case "CHAR": {
                        stmt.setNull(index, 1);
                        break;
                    }
                    case "INTEGER": {
                        stmt.setNull(index, 4);
                        break;
                    }
                    case "BIGINT": {
                        stmt.setNull(index, -5);
                        break;
                    }
                    case "DOUBLE": {
                        stmt.setNull(index, 8);
                        break;
                    }
                    case "DECIMAL": {
                        stmt.setNull(index, 3);
                        break;
                    }
                    case "DATE": 
                    case "DATETIME": 
                    case "TIME": 
                    case "TIMESTAMP": {
                        stmt.setNull(index, 91);
                        break;
                    }
                    default: {
                        stmt.setNull(index, 12);
                    }
                }
            }
        }
        catch (IllegalStateException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ExcelException(null, cell + " \u6570\u636e\u7c7b\u578b\u9519\u8bef: " + (index + 1) + "\u5217,\u671f\u5f85\u7684\u7c7b\u578b: " + type, null);
        }
        catch (SQLException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new ExcelException(null, "PreparedStatement\u63d2\u5165\u6570\u636e\u5931\u8d25", null);
        }
        this.logger.info("\u6b63\u5728\u5c06\u6570\u636e\u88c5\u5165batch... \u7b2c" + (index + 1) + "\u5217....\u5f53\u524d\u503c\uff1a" + cell);
    }

    private boolean rowIsBlank(List<String> row) {
        boolean key = true;
        for (String cell : row) {
            if ("".equals(cell)) continue;
            key = false;
            break;
        }
        return key;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

