/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.excel.controllers;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.hand.hap.core.IRequest;
import com.hand.hap.excel.ExcelException;
import com.hand.hap.excel.dto.ColumnInfo;
import com.hand.hap.excel.dto.ExportConfig;
import com.hand.hap.excel.service.IExportService;
import com.hand.hap.excel.service.IHapExcelImportService;
import com.hand.hap.function.dto.Function;
import com.hand.hap.system.controllers.BaseController;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/sys", "/api/sys"})
public class HapExcelController
extends BaseController {
    @Autowired
    IExportService excelService;
    @Autowired
    IHapExcelImportService iImportService;
    @Autowired
    ObjectMapper objectMapper;

    @RequestMapping(value={"/function/export"})
    public void createXLS(HttpServletRequest request, @RequestParam String config, HttpServletResponse httpServletResponse) throws IOException {
        IRequest requestContext = this.createRequestContext(request);
        JavaType type = this.objectMapper.getTypeFactory().constructParametrizedType(ExportConfig.class, ExportConfig.class, new Class[]{Function.class, ColumnInfo.class});
        ExportConfig exportConfig = (ExportConfig)this.objectMapper.readValue(config, type);
        this.excelService.exportAndDownloadExcel("com.hand.hap.function.mapper.FunctionMapper.selectAll", exportConfig, request, httpServletResponse, requestContext);
    }

    @RequestMapping(value={"/export/template/{tableName}"})
    public void exportImportTemplate(@PathVariable String tableName, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.iImportService.exportExcelTemplate(tableName, response, request);
    }

    @RequestMapping(value={"/import/{tableName}"})
    public void importXLS(HttpServletRequest request, HttpServletResponse response, @PathVariable String tableName) throws IOException, ExcelException, SQLException, FileUploadException {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        List items = upload.parseRequest(request);
        if (!items.isEmpty()) {
            for (FileItem item : items) {
                if (item.isFormField()) continue;
                InputStream fs = item.getInputStream();
                this.iImportService.loadExcel(fs, tableName);
            }
        }
    }
}

