/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.web.view.ui;

import com.hand.hap.core.web.view.ScreenBuilder;
import com.hand.hap.core.web.view.UITag;
import com.hand.hap.core.web.view.ViewContext;
import com.hand.hap.core.web.view.XMap;
import com.hand.hap.core.web.view.ui.Component;
import java.util.ArrayList;
import java.util.List;

@UITag
public class HlsNavigationBar
extends Component {
    public static final String PROPERTITY_NAVIGATIONBARTITLE = "navigationBarTitle";
    public static final String PROPERTITY_NAVIGATIONBAR = "navigationBar";
    public static final String PROPERTITY_NAVIGATIONBARCONTENT = "navigationBarContent";
    public static final String PROPERTITY_TREETITLE = "treeTitle";
    public static final String PROPERTITY_NAVIGATIONBARID = "navigationbarId";
    public static final String PROPERTITY_NAVIGATIONBARCLASS = "navigationbarClass";

    public static HlsNavigationBar createInstance() {
        XMap view = new XMap("h", "http://www.hand-china.com/hap", PROPERTITY_NAVIGATIONBAR);
        HlsNavigationBar HlsNavigationBar2 = new HlsNavigationBar();
        HlsNavigationBar2.initPrototype(view);
        return HlsNavigationBar2;
    }

    public String getNavigationBarContent(ViewContext context) throws Exception {
        StringBuffer sb = new StringBuffer();
        List<XMap> list = this.getPrototype().getChildren();
        for (XMap map : list) {
            sb.append(ScreenBuilder.build(map, context));
        }
        return sb.toString();
    }

    public List<String> getNavigationBarTitle(ViewContext context) throws Exception {
        ArrayList<String> titleList = new ArrayList<String>();
        List<XMap> list = this.getPrototype().getChildren();
        for (XMap map : list) {
            if (map.get(PROPERTITY_NAVIGATIONBAR) == null || this.getPrototype().getString("barType") == null || !this.getPrototype().getString("barType").equals("normal")) continue;
            titleList.add("normal");
            break;
        }
        int currentIndex = 0;
        for (XMap map : list) {
            if (map.get(PROPERTITY_NAVIGATIONBAR) == null) continue;
            if (this.getPrototype().getString("barType").equals("tree")) {
                ++currentIndex;
                if (map.get("nodeLevel") != null && map.get("nodeLevel").toString().equals("parent")) {
                    titleList.add("tree");
                    if (map.get(PROPERTITY_TREETITLE).toString() != null) {
                        titleList.add(map.get(PROPERTITY_TREETITLE).toString());
                    } else {
                        titleList.add(currentIndex + ". \u7b2c" + currentIndex + "\u6a21\u5757");
                    }
                    this.getbarId(map, titleList, currentIndex);
                }
                this.getBarData(map, titleList, currentIndex);
                continue;
            }
            if (!this.getPrototype().getString("barType").equals("normal")) continue;
            this.getBarData(map, titleList, ++currentIndex);
        }
        return titleList;
    }

    public void getBarData(XMap map, List<String> titleList, int currentIndex) {
        if (map.get(PROPERTITY_NAVIGATIONBARTITLE) != null) {
            titleList.add(map.get(PROPERTITY_NAVIGATIONBARTITLE).toString());
            this.getbarId(map, titleList, currentIndex);
        } else if (map.get("title") != null && map.get(PROPERTITY_NAVIGATIONBARTITLE) == null) {
            titleList.add(map.get("title").toString());
            this.getbarId(map, titleList, currentIndex);
        } else if (map.get("title") == null && map.get(PROPERTITY_NAVIGATIONBARTITLE) == null) {
            titleList.add(currentIndex + ". \u7b2c" + currentIndex + "\u6a21\u5757");
            this.getbarId(map, titleList, currentIndex);
        }
    }

    public void getbarId(XMap map, List<String> titleList, int currentIndex) {
        if (map.get("id") != null) {
            titleList.add(map.get("id").toString());
        } else {
            titleList.add("section-bar-" + currentIndex);
        }
    }

    public String getNavigationbarId(ViewContext context) throws Exception {
        String str = "";
        if (this.getPrototype().getString("id") != null) {
            str = this.getPrototype().getString("id");
        }
        return str.toString();
    }

    public String getNavigationbarClass(ViewContext context) throws Exception {
        String str = "";
        if (this.getPrototype().getString("class") != null) {
            str = this.getPrototype().getString("class");
        }
        return str.toString();
    }

    @Override
    public void init(XMap view, ViewContext context) throws Exception {
        super.init(view, context);
        context.put(PROPERTITY_NAVIGATIONBARCONTENT, this.getNavigationBarContent(context));
        context.addJsonConfig(PROPERTITY_NAVIGATIONBARTITLE, this.getNavigationBarTitle(context));
        context.put(PROPERTITY_NAVIGATIONBARCLASS, this.getNavigationbarClass(context));
        context.put(PROPERTITY_NAVIGATIONBARID, this.getNavigationbarId(context));
    }
}

