/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.web.view.ui;

import com.hand.hap.core.web.view.IDGenerator;
import com.hand.hap.core.web.view.ReferenceType;
import com.hand.hap.core.web.view.ViewContext;
import com.hand.hap.core.web.view.XMap;
import com.hand.hap.core.web.view.ui.ViewTag;
import java.util.ArrayList;
import java.util.List;

public class Component
extends ViewTag {
    private static final String CONFIG = "config";
    public static final String PROPERTITY_ID = "id";
    public static final String PROPERTITY_EVENTS = "events";
    public static final String PROPERTITY_EVENT = "event";
    public static final String PROPERTITY_EVENT_NAME = "name";
    public static final String PROPERTITY_EVENT_HANDLER = "handler";
    private static final String PROPERTITY_STYLE = "style";
    private static final String PROPERTITY_CLASSNAME = "class";
    private XMap prototype;

    protected String getDefaultClass(XMap view, ViewContext context) {
        return "";
    }

    public XMap getPrototype() {
        return this.prototype;
    }

    protected void initPrototype(XMap obj) {
        this.prototype = obj;
    }

    protected Object getPropertity(String key) {
        return this.getPrototype().getPropertity(key);
    }

    protected void setPropertity(Object key, Object value) {
        XMap prototype = this.getPrototype();
        if (prototype != null) {
            prototype.putPropertity(key, value);
        }
    }

    public String getId() {
        String id = this.getPrototype().getString(PROPERTITY_ID);
        if (id == null) {
            id = "H" + IDGenerator.getInstance().generate();
        }
        return id;
    }

    public void setId(String id) {
        this.setPropertity(PROPERTITY_ID, id);
    }

    public List<Event> getEvents() {
        ArrayList<Event> events = new ArrayList<Event>();
        XMap evts = this.getPrototype().getChild(PROPERTITY_EVENTS);
        if (evts != null && evts.getChildren() != null) {
            evts.getChildren().forEach(event -> {
                Event evt = new Event();
                evt.setName(event.getString(PROPERTITY_EVENT_NAME));
                evt.setHandler(event.getString(PROPERTITY_EVENT_HANDLER));
                events.add(evt);
            });
        }
        return events;
    }

    public void addEvents(String ... events) {
        for (String event : events) {
            this.addEvent(event);
        }
    }

    public void addEvent(String name) {
        String handler = this.getPrototype().getString(name);
        if (handler != null) {
            this.addEvent(name, handler);
        }
    }

    public void addEvent(String name, String handler) {
        XMap prototype = this.getPrototype();
        if (prototype != null) {
            XMap events = prototype.getChild(PROPERTITY_EVENTS);
            if (events == null) {
                events = new XMap("h", "http://www.hand-china.com/hap", PROPERTITY_EVENTS);
                prototype.addChild(events);
            }
            boolean hasSameEvent = false;
            List<XMap> list = events.getChildren();
            if (list != null) {
                for (XMap evt : list) {
                    String eventName = evt.getString(PROPERTITY_EVENT_NAME, "");
                    if (!eventName.equals(name)) continue;
                    hasSameEvent = true;
                    break;
                }
            }
            if (!hasSameEvent) {
                XMap xevt = new XMap("h", "http://www.hand-china.com/hap", PROPERTITY_EVENT);
                xevt.put(PROPERTITY_EVENT_NAME, name);
                xevt.put(PROPERTITY_EVENT_HANDLER, handler);
                events.addChild(xevt);
            }
        }
    }

    public String getStyle() {
        return this.getPrototype().getString(PROPERTITY_STYLE);
    }

    public void setStyle(String style) {
        this.setPropertity(PROPERTITY_STYLE, style);
    }

    public String getClassName() {
        return this.getPrototype().getString(PROPERTITY_CLASSNAME);
    }

    public void setClassName(String className) {
        this.setPropertity(PROPERTITY_CLASSNAME, className);
    }

    @Override
    public void init(XMap view, ViewContext context) throws Exception {
        this.initPrototype(view);
        String id = this.getId();
        context.put(PROPERTITY_ID, id);
        context.put(PROPERTITY_STYLE, this.getStyle());
        context.put(PROPERTITY_CLASSNAME, this.getClassName());
        this.getEvents().forEach(event -> context.addJsonConfig(event.getName(), event.getHandler()));
    }

    @Override
    public String execute(XMap view, ViewContext context) throws Exception {
        context.put(CONFIG, context.getJsonConfig());
        String template = this.getViewTemplate();
        return super.build(context, template == null ? this.getClass().getSimpleName() + ".ftl" : template);
    }

    public String getViewTemplate() {
        return null;
    }

    public static class Event {
        private String name;
        private ReferenceType handler;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public ReferenceType getHandler() {
            return this.handler;
        }

        public void setHandler(String handler) {
            this.handler = new ReferenceType(handler);
        }
    }
}

