/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.web.view;

import com.hand.hap.core.web.view.IterationHandle;
import com.hand.hap.core.web.view.ReferenceType;
import com.hand.hap.core.web.view.XMLOutputter;
import com.hand.hap.core.web.view.XMapUtil;
import com.hand.hap.core.web.view.xpath.XPathRequest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class XMap
extends HashMap<Object, Object>
implements Cloneable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_INITIAL_CAPACITY = 50;
    protected String name;
    protected String prefix = "h";
    protected String namespaceURI = "http://www.hand-china.com/hap";
    protected String text;
    protected XMap parent;
    protected List<XMap> children;
    protected Map<String, String> namespaceMapping;

    public XMap() {
        super(50);
    }

    public XMap(String name) {
        super(50);
        this.setName(name);
    }

    public XMap(String name, String namespaceURI) {
        super(50);
        this.setName(name);
        this.setNameSpaceURI(namespaceURI);
    }

    public XMap(String prefix, String namespaceURI, String name) {
        super(50);
        this.setName(name);
        this.setPrefix(prefix);
        this.setNameSpaceURI(namespaceURI);
    }

    public XMap(XMap another) {
        this(another.prefix, another.namespaceURI, another.name);
        this.copy(another);
    }

    public XMap(String name, Map<Object, Object> map) {
        this.setName(name);
        this.putAll(map);
    }

    public void addChild(Collection<XMap> children) {
        if (children != null) {
            children.forEach(this::addChild);
        }
    }

    public XMap replaceChild(XMap child, XMap newChild) {
        if (child == null) {
            return null;
        }
        ListIterator it = (ListIterator)this.getChildIterator();
        if (it == null) {
            return null;
        }
        while (it.hasNext()) {
            XMap m = (XMap)it.next();
            if (m != child) continue;
            if (newChild == null) {
                it.remove();
                return null;
            }
            newChild.setParent(this);
            it.set(newChild);
            return newChild;
        }
        return null;
    }

    public XMap replaceChild(String childName, XMap newChild) {
        return this.replaceChild(this.getChild(childName), newChild);
    }

    public XMap copy(XMap another) {
        this.putAll(another);
        this.addChild(another.children);
        this.text = another.text;
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNameSpaceURI(String uri) {
        this.namespaceURI = uri;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setNameSpace(String prefix, String uri) {
        this.setPrefix(prefix);
        this.setNameSpaceURI(uri);
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getRawName() {
        if (this.prefix == null) {
            return this.name;
        }
        return this.prefix + ':' + this.name;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String t) {
        this.text = t;
    }

    public void setParent(XMap p) {
        this.parent = p;
    }

    public XMap getParent() {
        return this.parent;
    }

    public XMap getRoot() {
        for (XMap map = this.parent; map != null; map = map.getParent()) {
            if (map.getParent() != null) continue;
            return map;
        }
        return this;
    }

    @Override
    public Object put(Object key, Object value) {
        if (value != null && value instanceof XMap) {
            ((XMap)value).setParent(this);
        }
        return super.put(key, value);
    }

    public Object putObject(String key, Object value, char attribute_char) {
        if (key == null) {
            return null;
        }
        if (key.charAt(0) == attribute_char) {
            return this.put(key.substring(1), value);
        }
        if (value instanceof XMap && value != null) {
            XMap cmap = (XMap)value;
            cmap.setName(key);
            this.addChild(cmap);
            return value;
        }
        return null;
    }

    Object getObject(String key, char attribute_char) {
        if (key == null) {
            return null;
        }
        if (key.charAt(0) == attribute_char) {
            return this.get(key.substring(1));
        }
        return this.getChild(key);
    }

    public void addChild(int index, XMap child) {
        child.parent = this;
        this.getChildren(true).add(index, child);
    }

    public void addChild(XMap child) {
        child.parent = this;
        this.getChildren(true).add(child);
    }

    public boolean removeChild(XMap child) {
        boolean removed = false;
        if (this.children != null) {
            ListIterator<XMap> it = this.children.listIterator();
            while (it.hasNext()) {
                XMap obj = it.next();
                if (obj != child) continue;
                it.remove();
                removed = true;
                break;
            }
            if (removed) {
                child.setParent(null);
            }
        }
        return removed;
    }

    public XMap createChild(String prefix, String uri, String name) {
        XMap child = new XMap(prefix, uri, name);
        this.addChild(child);
        return child;
    }

    public XMap createChild(String name) {
        return this.createChild(null, null, name);
    }

    public XMap getChild(XMap child) {
        if (this.children == null) {
            return null;
        }
        for (XMap node : this.children) {
            if (!node.equals(child)) continue;
            return node;
        }
        return null;
    }

    public XMap getChild(String name) {
        if (this.children == null) {
            return null;
        }
        for (XMap node : this.children) {
            String nm = node.getName();
            if (nm == null || !nm.equals(name)) continue;
            return node;
        }
        return null;
    }

    public List<XMap> getChildren() {
        return this.children;
    }

    public List<XMap> getChildren(boolean create) {
        if (create && this.children == null) {
            this.children = new LinkedList<XMap>();
        }
        return this.children;
    }

    public Iterator<XMap> getChildIterator() {
        if (this.children == null) {
            return null;
        }
        return this.children.iterator();
    }

    public String toXML() {
        return XMLOutputter.defaultInstance().toXML(this);
    }

    @Override
    public void clear() {
        super.clear();
        if (this.children != null) {
            this.children.clear();
        }
        this.name = null;
        this.text = null;
        this.namespaceURI = null;
        this.prefix = null;
        this.children = null;
        this.parent = null;
    }

    @Override
    public Object clone() {
        XMap m = (XMap)super.clone();
        if (this.children != null) {
            m.children = new LinkedList<XMap>();
            for (XMap child : this.children) {
                XMap new_child = (XMap)child.clone();
                new_child.setParent(m);
                m.children.add(new_child);
            }
        }
        return m;
    }

    public Object getPropertity(String key) {
        String value = this.getString(key);
        if (StringUtils.startsWith((String)value, (String)"fn:")) {
            return new ReferenceType(StringUtils.substringAfter((String)value, (String)"fn:"));
        }
        if (StringUtils.startsWith((String)value, (String)"boolean:")) {
            return new Boolean(StringUtils.substringAfter((String)value, (String)"boolean:"));
        }
        if (StringUtils.startsWith((String)value, (String)"integer:")) {
            return new Integer(StringUtils.substringAfter((String)value, (String)"integer:"));
        }
        if (StringUtils.startsWith((String)value, (String)"long:")) {
            return new Long(StringUtils.substringAfter((String)value, (String)"long:"));
        }
        if (StringUtils.startsWith((String)value, (String)"float:")) {
            return new Float(StringUtils.substringAfter((String)value, (String)"float:"));
        }
        if (StringUtils.startsWith((String)value, (String)"double:")) {
            return new Double(StringUtils.substringAfter((String)value, (String)"double:"));
        }
        if (StringUtils.startsWith((String)value, (String)"date:")) {
            SimpleDateFormat sb = new SimpleDateFormat("yyyy-MM-dd");
            try {
                return sb.parse(StringUtils.substringAfter((String)value, (String)"date:"));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return value;
    }

    public void putPropertity(Object key, Object value) {
        if (value instanceof ReferenceType) {
            value = "fn:" + ((ReferenceType)value).getReference();
        } else if (value instanceof Integer) {
            value = "integer:" + value.toString();
        } else if (value instanceof Double) {
            value = "double:" + value.toString();
        } else if (value instanceof Float) {
            value = "float:" + value.toString();
        } else if (value instanceof Long) {
            value = "long:" + value.toString();
        } else if (value instanceof Boolean) {
            Boolean v = (Boolean)value;
            value = "boolean:" + (v != false ? "true" : "false");
        } else if (value instanceof Date) {
            value = "date:" + DateFormatUtils.format((Date)((Date)value), (String)"yyyy-MM-dd");
        }
        this.put(key, value);
    }

    public String getString(Object key) {
        return MapUtils.getString((Map)this, (Object)key);
    }

    public String getString(Object key, String defaultValue) {
        return MapUtils.getString((Map)this, (Object)key, (String)defaultValue);
    }

    public Boolean getBoolean(Object key) {
        return MapUtils.getBoolean((Map)this, (Object)key);
    }

    public Boolean getBoolean(Object key, Boolean defaultValue) {
        return MapUtils.getBoolean((Map)this, (Object)key, (Boolean)defaultValue);
    }

    public Integer getInteger(Object key) {
        return MapUtils.getInteger((Map)this, (Object)key);
    }

    public Integer getInteger(Object key, int defaultValue) {
        return MapUtils.getInteger((Map)this, (Object)key, (Integer)defaultValue);
    }

    public Long getLong(Object key) {
        return MapUtils.getLong((Map)this, (Object)key);
    }

    public Long getLong(Object key, Long defaultValue) {
        return MapUtils.getLong((Map)this, (Object)key, (Long)defaultValue);
    }

    public Short getShort(Object key) {
        return MapUtils.getShort((Map)this, (Object)key);
    }

    public Short getShort(Object key, Short defaultValue) {
        return MapUtils.getShort((Map)this, (Object)key, (Short)defaultValue);
    }

    public Double getDouble(Object key) {
        return MapUtils.getDouble((Map)this, (Object)key);
    }

    public Double getDouble(Object key, Double defaultValue) {
        return MapUtils.getDouble((Map)this, (Object)key, (Double)defaultValue);
    }

    public Float getFloat(Object key) {
        return MapUtils.getFloat((Map)this, (Object)key);
    }

    public Float getFloat(Object key, Float defaultValue) {
        return MapUtils.getFloat((Map)this, (Object)key, (Float)defaultValue);
    }

    public Byte getByte(Object key) {
        return MapUtils.getByte((Map)this, (Object)key);
    }

    public byte getByte(Object key, byte defaultValue) {
        return MapUtils.getByte((Map)this, (Object)key, (Byte)defaultValue);
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    public Map<String, String> getNamespaceMapping() {
        return this.namespaceMapping;
    }

    public void setNamespaceMapping(Map<String, String> mapping) {
        this.namespaceMapping = mapping;
    }

    public String getAbsolutePath() {
        StringBuilder path = new StringBuilder();
        this.processPath(path);
        return path.toString();
    }

    protected void processPath(StringBuilder sb) {
        if (this.getParent() != null) {
            this.getParent().processPath(sb);
        }
        sb.append("/").append(this.getPrefix()).append(":").append(this.getName());
    }

    private int iterateChild(IterationHandle handle, boolean root_first) {
        int result = 0;
        if (this.children == null) {
            return result;
        }
        ListIterator<XMap> it = this.children.listIterator();
        while (it.hasNext()) {
            XMap child = it.next();
            result = child.iterate(handle, root_first);
            if (result == 2) {
                return result;
            }
            if (result != -1) continue;
            it.remove();
            result = 0;
        }
        return result;
    }

    public int iterate(IterationHandle handle, boolean root_first) {
        if (root_first) {
            int result = handle.process(this);
            if (result == 0) {
                result = this.iterateChild(handle, root_first);
            }
            return result;
        }
        int result = this.iterateChild(handle, root_first);
        if (result != 2) {
            handle.process(this);
        }
        return result;
    }

    public static void addBook(XMap books, String categoryName, String bookName, String bookPrice) {
        List<XMap> categories = books.getChildren();
        if (categories == null) {
            categories = new ArrayList<XMap>();
            books.addChild(categories);
        }
        XMap category = null;
        for (XMap cat : categories) {
            if (!categoryName.equals(cat.getString("type"))) continue;
            category = cat;
            break;
        }
        if (category == null) {
            category = new XMap("category");
            category.put("type", categoryName);
            books.addChild(category);
        }
        if (category != null) {
            XMap book = new XMap("book");
            book.put("name", bookName);
            XMap price1 = new XMap("price");
            price1.setText(bookPrice);
            book.addChild(price1);
            category.addChild(book);
        }
    }

    public static void main(String[] args) {
        XMap library = new XMap("library");
        XMap booksa = new XMap("books");
        booksa.put("group", "a");
        XMap.addBook(booksa, "java", "java0", "11");
        XMap.addBook(booksa, "java", "java1", "12");
        XMap.addBook(booksa, "java", "java2", "13");
        XMap.addBook(booksa, "javascript", "javascript0", "14");
        XMap.addBook(booksa, "javascript", "javascript1", "15");
        XMap.addBook(booksa, "javascript", "javascript2", "16");
        XMap booksb = new XMap("books");
        booksb.put("group", "b");
        XMap.addBook(booksb, "java", "java0", "21");
        XMap.addBook(booksb, "java", "java1", "22");
        XMap.addBook(booksb, "java", "java2", "23");
        XMap.addBook(booksb, "javascript", "javascript0", "24");
        XMap.addBook(booksb, "javascript", "javascript1", "25");
        XMap.addBook(booksb, "javascript", "javascript22", "26");
        library.addChild(booksa);
        library.addChild(booksb);
        System.out.println(library.toXML());
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.put("h", "http://www.hand-china.com/hap");
        XPathRequest xpath = new XPathRequest("/h:library/h:books[@group='b']/h:category[@type='javascript']/h:book[last()-1]/h:price", mapping);
        XMapUtil.XPathFinder cf = new XMapUtil.XPathFinder(xpath);
        XMap result = cf.find(library);
        if (result != null) {
            System.out.println(result.toXML());
        }
    }
}

