/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.web;

import com.hand.hap.attachment.service.IAttachmentProvider;
import com.hand.hap.core.web.FreeMarkerBeanProvider;
import com.hand.hap.system.service.IAccessService;
import com.hand.hap.system.service.IKendoLovService;
import com.hand.hap.system.service.ILovService;
import freemarker.ext.servlet.HttpRequestParametersHashModel;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateModel;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.springframework.beans.BeansException;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfig;
import org.springframework.web.servlet.view.freemarker.FreeMarkerView;

public class DefaultFreeMarkerView
extends FreeMarkerView {
    private IKendoLovService kendoLovService;
    private ILovService lovService;
    private IAccessService accessService;
    private IAttachmentProvider attachmentProvider;
    private FreeMarkerBeanProvider beanProvider;

    protected FreeMarkerConfig autodetectConfiguration() throws BeansException {
        this.kendoLovService = (IKendoLovService)this.getApplicationContext().getBean(IKendoLovService.class);
        this.lovService = (ILovService)this.getApplicationContext().getBean(ILovService.class);
        this.accessService = (IAccessService)this.getApplicationContext().getBean(IAccessService.class);
        this.attachmentProvider = (IAttachmentProvider)this.getApplicationContext().getBean(IAttachmentProvider.class);
        this.beanProvider = (FreeMarkerBeanProvider)this.getApplicationContext().getBean(FreeMarkerBeanProvider.class);
        return super.autodetectConfiguration();
    }

    protected SimpleHash buildTemplateModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) {
        SimpleHash fmModel = super.buildTemplateModel(model, request, response);
        fmModel.put("RequestParameters", (Object)new XSSDefendHttpRequestParametersHashModel(request));
        this.accessService.setRequest(request);
        fmModel.put("lovProvider", (Object)this.kendoLovService);
        fmModel.put("lovService", (Object)this.lovService);
        fmModel.put("accessService", (Object)this.accessService);
        this.attachmentProvider.setConfiguration(this.getConfiguration());
        fmModel.put("attachmentProvider", (Object)this.attachmentProvider);
        Map<String, Object> beans = this.beanProvider.getAvailableBean();
        if (beans != null) {
            fmModel.putAll(beans);
        }
        return fmModel;
    }

    static class XSSDefendHttpRequestParametersHashModel
    extends HttpRequestParametersHashModel {
        private HttpServletRequest requestReference;

        public XSSDefendHttpRequestParametersHashModel(HttpServletRequest request) {
            super(request);
            this.requestReference = request;
        }

        public TemplateModel get(String key) {
            String value = this.requestReference.getParameter(key);
            return value == null ? null : new SimpleScalar(StringEscapeUtils.escapeJavaScript((String)StringEscapeUtils.escapeHtml((String)value)));
        }
    }
}

