/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.components;

import com.hand.hap.core.BaseConstants;
import com.hand.hap.message.profile.SystemConfigListener;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.stereotype.Component;

@Component
public class SysConfigManager
implements SystemConfigListener,
BaseConstants {
    public static final String SYS_LOGO_VERSION = "sysLogoVersion";
    public static final String SYS_FAVICON_VERSION = "sysFaviconVersion";
    public static final String KEY_SYS_LOGO_VERSION = "SYS_LOGO_VERSION";
    public static final String KEY_SYS_FAVICON_VERSION = "SYS_FAVICON_VERSION";
    private static final String KEY_SYS_TITLE = "SYS_TITLE";
    private static final String KEY_PROHIBIT_REPEAT_LOGIN = "PROHIBIT_REPEAT_LOGIN";
    private static final String KEY_USER_ROLE_MERGE = "USER_ROLE_MERGE";
    private static final String KEY_FIRST_LOGIN_RESET_PASSWORD = "FIRST_LOGIN_RESET_PASSWORD";
    private static final String KEY_OAUTH2_AUTHENTICATION_NUM = "OAUTH2_AUTHENTICATION_NUM";
    private static final String KEY_OAUTH2_AUTHENTICATION_LOCK_TIME = "OAUTH2_AUTHENTICATION_LOCK_TIME";
    private static final String DEFAULT_SYS_TITLE = "Hand Application Platform";
    private String sysTitle = "Hand Application Platform";
    private boolean prohibitRepeatLogin = true;
    private boolean roleMergeFlag = true;
    private boolean resetPwFlag = false;
    private String systemLogoVersion = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
    private String systemFaviconVersion = DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
    private int oauth2AuthenticationNum = 3;
    private long oauth2AuthenticationLockTime = 600L;

    public String getSysTitle() {
        return this.sysTitle;
    }

    public boolean isProhibitRepeatLogin() {
        return this.prohibitRepeatLogin;
    }

    public boolean getRoleMergeFlag() {
        return this.roleMergeFlag;
    }

    public boolean getResetPwFlag() {
        return this.resetPwFlag;
    }

    public String getSystemLogoVersion() {
        return this.systemLogoVersion;
    }

    public String getSystemFaviconVersion() {
        return this.systemFaviconVersion;
    }

    public int getOauth2AuthenticationNum() {
        return this.oauth2AuthenticationNum;
    }

    public long getOauth2AuthenticationLockTime() {
        return this.oauth2AuthenticationLockTime;
    }

    @Override
    public List<String> getAcceptedProfiles() {
        return Arrays.asList(KEY_SYS_TITLE, KEY_PROHIBIT_REPEAT_LOGIN, KEY_USER_ROLE_MERGE, KEY_FIRST_LOGIN_RESET_PASSWORD, KEY_SYS_LOGO_VERSION, KEY_SYS_FAVICON_VERSION, KEY_OAUTH2_AUTHENTICATION_NUM, KEY_OAUTH2_AUTHENTICATION_LOCK_TIME);
    }

    @Override
    public void updateProfile(String profileName, String profileValue) {
        if (KEY_SYS_TITLE.equalsIgnoreCase(profileName)) {
            this.sysTitle = profileValue;
        } else if (KEY_USER_ROLE_MERGE.equalsIgnoreCase(profileName)) {
            this.roleMergeFlag = "Y".equalsIgnoreCase(profileValue);
        } else if (KEY_FIRST_LOGIN_RESET_PASSWORD.equalsIgnoreCase(profileName)) {
            this.resetPwFlag = "Y".equalsIgnoreCase(profileValue);
        } else if (KEY_PROHIBIT_REPEAT_LOGIN.equalsIgnoreCase(profileName)) {
            this.prohibitRepeatLogin = "Y".equalsIgnoreCase(profileValue);
        } else if (KEY_SYS_LOGO_VERSION.equalsIgnoreCase(profileName)) {
            this.systemLogoVersion = profileValue;
        } else if (KEY_SYS_FAVICON_VERSION.equalsIgnoreCase(profileName)) {
            this.systemFaviconVersion = profileValue;
        } else if (KEY_OAUTH2_AUTHENTICATION_NUM.equalsIgnoreCase(profileName)) {
            this.oauth2AuthenticationNum = Integer.parseInt(profileValue);
        } else if (KEY_OAUTH2_AUTHENTICATION_LOCK_TIME.equalsIgnoreCase(profileName)) {
            this.oauth2AuthenticationLockTime = Long.parseLong(profileValue);
        }
    }
}

