/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.core.components;

import com.hand.hap.cache.CacheManager;
import com.hand.hap.cache.impl.HashStringRedisCache;
import com.hand.hap.core.ILanguageProvider;
import com.hand.hap.message.IMessageConsumer;
import com.hand.hap.system.dto.Language;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;

public class CacheBasedLanguageProvider
implements ILanguageProvider,
IMessageConsumer<String>,
BeanFactoryAware {
    private BeanFactory beanFactory;
    private HashStringRedisCache<Language> languageCache;
    private String cacheName = "language";
    private boolean enableSecondaryCache = false;
    private List<Language> tempList;
    private Logger logger = LoggerFactory.getLogger(CacheBasedLanguageProvider.class);

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public boolean isEnableSecondaryCache() {
        return this.enableSecondaryCache;
    }

    public void setEnableSecondaryCache(boolean enableSecondaryCache) {
        this.enableSecondaryCache = enableSecondaryCache;
    }

    @Override
    public List<Language> getSupportedLanguages() {
        if (this.tempList == null) {
            this.tempList = this.getFromCache();
        }
        if (this.tempList == null) {
            return Collections.EMPTY_LIST;
        }
        return this.tempList;
    }

    private List<Language> getFromCache() {
        if (this.languageCache == null) {
            CacheManager cacheManager = (CacheManager)this.beanFactory.getBean(CacheManager.class);
            this.languageCache = (HashStringRedisCache)cacheManager.getCache(this.getCacheName());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("load languages from cache.");
        }
        return this.languageCache.getAll();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Override
    public void onMessage(String message, String pattern) {
        if ("cache.language".equals(pattern)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("language cache changed, now reload secondary cache.", (Object)message);
            }
            this.tempList = this.getFromCache();
        } else if ("topic:cache:reloaded".equals(pattern) && this.cacheName.equals(message)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("language cache reloaded, now reload secondary cache.");
            }
            this.tempList = this.getFromCache();
        }
    }
}

