/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.cache.impl;

import com.hand.hap.cache.impl.HashStringRedisCache;
import com.hand.hap.function.dto.ResourceItemElement;
import com.hand.hap.function.mapper.ResourceItemElementMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceItemElementCache
extends HashStringRedisCache<ResourceItemElement[]> {
    private String queryAllSqlId = ResourceItemElementMapper.class.getName() + ".selectAll";
    private String querySqlId = ResourceItemElementMapper.class.getName() + ".selectByResourceItemId";
    private final Logger logger = LoggerFactory.getLogger(ResourceItemElementCache.class);

    public ResourceItemElementCache() {
        this.setType(ResourceItemElement[].class);
    }

    @Override
    public void init() {
        this.strSerializer = this.getRedisTemplate().getStringSerializer();
        this.initLoad();
    }

    @Override
    public ResourceItemElement[] getValue(String key) {
        return (ResourceItemElement[])super.getValue(key);
    }

    @Override
    public void setValue(String key, ResourceItemElement[] values) {
        super.setValue(key, values);
    }

    @Override
    protected void initLoad() {
        block15: {
            HashMap<String, List> resourceItemElementList = new HashMap<String, List>();
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                sqlSession.select(this.queryAllSqlId, resultContext -> {
                    ResourceItemElement value = (ResourceItemElement)resultContext.getResultObject();
                    String ownerResourceItemId = value.getResourceItemId().toString();
                    ArrayList<ResourceItemElement> elementList = (ArrayList<ResourceItemElement>)resourceItemElementList.get(ownerResourceItemId);
                    if (elementList == null) {
                        elementList = new ArrayList<ResourceItemElement>();
                        resourceItemElementList.put(ownerResourceItemId, elementList);
                    }
                    elementList.add(value);
                });
                resourceItemElementList.forEach((k, v) -> this.setValue((String)k, v.toArray(new ResourceItemElement[v.size()])));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("successfully loaded all resource item element cache");
                }
            }
            catch (Throwable e) {
                if (!this.logger.isErrorEnabled()) break block15;
                this.logger.error("init resource item element cache exception: ", e);
            }
        }
    }

    public void load(Long resourceItemId) {
        block14: {
            HashMap<String, List> resourceItemElementList = new HashMap<String, List>();
            super.remove(resourceItemId.toString());
            try (SqlSession sqlSession = this.getSqlSessionFactory().openSession();){
                sqlSession.select(this.querySqlId, (Object)resourceItemId, resultContext -> {
                    ResourceItemElement value = (ResourceItemElement)resultContext.getResultObject();
                    ArrayList<ResourceItemElement> sets = (ArrayList<ResourceItemElement>)resourceItemElementList.get(resourceItemId.toString());
                    if (sets == null) {
                        sets = new ArrayList<ResourceItemElement>();
                        resourceItemElementList.put(resourceItemId.toString(), sets);
                    }
                    sets.add(value);
                });
                resourceItemElementList.forEach((k, v) -> this.setValue((String)k, v.toArray(new ResourceItemElement[v.size()])));
            }
            catch (Throwable e) {
                if (!this.logger.isErrorEnabled()) break block14;
                this.logger.error("load resource item element cache exception: ", e);
            }
        }
    }
}

