/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.cache.impl;

import com.hand.hap.cache.Cache;
import com.hand.hap.cache.CacheManager;
import com.hand.hap.cache.impl.RedisCache;
import com.hand.hap.message.IMessagePublisher;
import com.hand.hap.message.IQueueMessageListener;
import com.hand.hap.message.ITopicMessageListener;
import com.hand.hap.message.QueueMonitor;
import com.hand.hap.message.TopicMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@QueueMonitor(queue="queue:cache:reload")
@TopicMonitor(channel={"topic:cache:reloaded"})
public class CacheReloadProcessor
implements IQueueMessageListener<String>,
ITopicMessageListener<String> {
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private IMessagePublisher messagePublisher;
    private StringRedisSerializer redisSerializer = new StringRedisSerializer();
    private Logger logger = LoggerFactory.getLogger(CacheReloadProcessor.class);
    private String name;
    private String[] publishMessageTo = new String[]{"topic:cache:reloaded"};

    @Override
    public String getQueue() {
        return this.name;
    }

    public void setQueue(String name) {
        this.name = name;
    }

    @Override
    public String[] getTopic() {
        return this.publishMessageTo;
    }

    @Override
    public RedisSerializer<String> getRedisSerializer() {
        return this.redisSerializer;
    }

    @Override
    public void onTopicMessage(String message, String pattern) {
        Cache cache = this.cacheManager.getCache(message);
        if (cache instanceof RedisCache) {
            ((RedisCache)cache).onCacheReload();
        }
    }

    @Override
    public void onQueueMessage(String cacheName, String queue) {
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("begin reload cache:" + cacheName);
            }
            cache.reload();
            for (String top : this.publishMessageTo) {
                this.messagePublisher.publish(top, cacheName);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("reload cache:{} success.", (Object)cacheName);
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} is not a valid cache.", (Object)cacheName);
        }
    }

    public String[] getPublishMessageTo() {
        return this.publishMessageTo;
    }

    public void setPublishMessageTo(String[] publishMessageTo) {
        this.publishMessageTo = publishMessageTo;
    }
}

