/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.cache.impl;

import com.hand.hap.cache.Cache;
import com.hand.hap.cache.CacheManager;
import com.hand.hap.core.AppContextInitListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;

public class CacheManagerImpl
implements CacheManager,
AppContextInitListener {
    private HashMap<String, Cache> cacheMap = new HashMap();
    private List<Cache> caches;

    public void setCaches(List<Cache> caches) {
        this.caches = caches;
        if (caches != null) {
            for (Cache c : caches) {
                this.cacheMap.put(c.getName(), c);
                c.init();
            }
        }
    }

    public List<Cache> getCaches() {
        return this.caches;
    }

    @Override
    public <T> Cache<T> getCache(String name) {
        return this.cacheMap.get(name);
    }

    @Override
    public void addCache(Cache<?> cache) {
        if (this.caches == null) {
            this.caches = new ArrayList<Cache>();
        }
        if (!this.caches.contains(cache)) {
            this.caches.add(cache);
        }
        this.cacheMap.put(cache.getName(), cache);
    }

    @Override
    public void contextInitialized(ApplicationContext applicationContext) {
        Map cacheBeans = applicationContext.getBeansOfType(Cache.class);
        if (cacheBeans != null) {
            cacheBeans.forEach((k, v) -> {
                if (!this.caches.contains(v)) {
                    if (StringUtils.isEmpty((CharSequence)v.getName())) {
                        throw new RuntimeException(v + " cacheName is empty");
                    }
                    this.addCache((Cache<?>)v);
                    v.init();
                }
            });
        }
    }
}

