/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.audit.service.impl;

import com.github.pagehelper.PageHelper;
import com.hand.hap.audit.mapper.AuditMapper;
import com.hand.hap.audit.service.IAuditHistoryService;
import com.hand.hap.audit.service.IAuditTableNameProvider;
import com.hand.hap.audit.service.impl.DefaultAuditTableNameProvider;
import com.hand.hap.audit.util.AuditUtils;
import com.hand.hap.core.annotation.AuditEnabled;
import com.hand.hap.mybatis.entity.EntityField;
import com.hand.hap.system.dto.BaseDTO;
import com.hand.hap.system.dto.DTOClassInfo;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Table;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ReflectionUtils;

@Service
public class AuditHistoryServiceImpl
implements IAuditHistoryService {
    private Logger logger = LoggerFactory.getLogger(AuditHistoryServiceImpl.class);
    @Autowired
    private AuditMapper auditMapper;
    @Autowired(required=false)
    private IAuditTableNameProvider auditTableNameProvider = DefaultAuditTableNameProvider.instance;

    @Override
    public List<Map<String, Object>> selectAuditHistory(BaseDTO dto, int page, int pagesize) throws InvocationTargetException, NoSuchMethodException {
        PageHelper.startPage(page, pagesize);
        HashMap<String, Object> auditParam = new HashMap<String, Object>();
        Class<?> clazz = dto.getClass();
        Table tbl = clazz.getAnnotation(Table.class);
        AuditEnabled auditEnabled = clazz.getAnnotation(AuditEnabled.class);
        String baseTableName = tbl.name();
        String auditTableName = StringUtils.defaultIfEmpty((String)auditEnabled.auditTable(), (String)this.auditTableNameProvider.getAuditTableName(baseTableName));
        auditParam.put("_auditTableName", auditTableName);
        EntityField[] ids = DTOClassInfo.getIdFields(clazz);
        HashMap<String, Object> pks = new HashMap<String, Object>();
        for (EntityField f2 : ids) {
            try {
                pks.put(DTOClassInfo.getColumnName(f2), PropertyUtils.getProperty((Object)dto, (String)f2.getName()));
            }
            catch (IllegalAccessException e) {
                if (!this.logger.isErrorEnabled()) continue;
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        HashMap fieldsMap = new HashMap();
        ReflectionUtils.doWithFields(clazz, f -> fieldsMap.put(f.getName(), f));
        auditParam.put("_pks", pks);
        List<Map<String, Object>> res = this.auditMapper.selectAuditHistory(auditParam);
        ArrayList<Map<String, Object>> resTrans = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> e : res) {
            HashMap n = new HashMap();
            e.forEach((k, v) -> {
                String camelName = AuditUtils.camel(k);
                if (v instanceof Date) {
                    Field f = (Field)fieldsMap.get(camelName);
                    v = AuditUtils.convertDateToString((Date)v, f);
                }
                n.put(camelName, v);
            });
            resTrans.add(n);
        }
        return resTrans;
    }
}

