/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.attachment.impl;

import com.hand.hap.attachment.ContentTypeFilter;
import com.hand.hap.attachment.Controller;
import com.hand.hap.attachment.FileInfo;
import com.hand.hap.attachment.FileProcessor;
import com.hand.hap.attachment.Uploader;
import com.hand.hap.attachment.dto.AttachCategory;
import com.hand.hap.attachment.exception.AttachmentException;
import com.hand.hap.attachment.impl.DefaultContentTypeFilter;
import com.hand.hap.attachment.impl.DefaultFileInfo;
import com.hand.hap.attachment.impl.StandardController;
import com.hand.hap.attachment.impl.StandardFileChain;
import com.hand.hap.core.util.FormatUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class StandardUploader
implements Uploader {
    private static Logger logger = LoggerFactory.getLogger(StandardUploader.class);
    private AttachCategory category;
    private HttpServletRequest request = null;
    private Map<String, String> params = new HashMap<String, String>();
    private StandardFileChain chain = null;
    private Controller controller = null;
    private ContentTypeFilter filter;
    private List<FileInfo> fileInfos;
    private List<FileItem> fileItems = new ArrayList<FileItem>();
    private long singleFileSize = 0xA00000L;
    private long allFileSize = 0x6400000L;
    private int maxFileNum = 9999;
    private String status = "UPLOAD_SUCCESS";
    private boolean isMultiPartFiled;

    public AttachCategory getCategory() {
        return this.category;
    }

    @Override
    public void setCategory(AttachCategory category) {
        this.category = category;
    }

    @Override
    public void init(HttpServletRequest request) {
        block11: {
            long allSize = 0L;
            int fileNum = 0;
            this.request = request;
            this.fileInfos = new ArrayList<FileInfo>();
            this.isMultiPartFiled = request instanceof MultipartHttpServletRequest;
            if (this.filter == null) {
                this.filter = new DefaultContentTypeFilter();
            }
            try {
                boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
                if (!isMultipart) {
                    this.status = "NOT_FILE_ERROR";
                    return;
                }
                this.chain = new StandardFileChain(this.fileInfos, this);
                if (this.isMultiPartFiled) {
                    MultipartFile multipartFile = ((MultipartHttpServletRequest)request).getFile("files");
                    this.processFormField("sourceType", request.getParameter("sourceType"));
                    this.processFormField("sourceKey", request.getParameter("sourceKey"));
                    this.fileItems.add(new MultipartFiledByFileItem(multipartFile));
                } else {
                    ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
                    List items = upload.parseRequest(request);
                    for (FileItem item : items) {
                        if (item.isFormField()) continue;
                        allSize += item.getSize();
                        ++fileNum;
                    }
                    if (allSize > this.allFileSize) {
                        this.status = "LIMIT_SIZE_MAX_ERROR";
                        return;
                    }
                    if (fileNum > this.maxFileNum) {
                        this.status = "LIMIT_UPLOADNUM_ERROR";
                        return;
                    }
                    for (FileItem item : items) {
                        if (item.isFormField()) {
                            this.processFormField(item);
                            continue;
                        }
                        if (item.isFormField()) continue;
                        this.fileItems.add(item);
                    }
                }
            }
            catch (Exception e) {
                this.status = "UPLOAD_ERROR";
                if (!logger.isErrorEnabled()) break block11;
                logger.error("\u6587\u4ef6\u4e0a\u4f20\u9519\u8bef", (Throwable)e);
            }
        }
    }

    @Override
    public List<FileInfo> upload() throws AttachmentException {
        if (this.controller == null) {
            this.controller = new StandardController();
        }
        if (this.fileItems != null && !this.fileItems.isEmpty()) {
            for (FileItem f : this.fileItems) {
                this.processUploadedFile(f);
            }
        }
        try {
            if (this.chain != null) {
                this.chain.doProcess();
            }
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("\u6587\u4ef6\u5904\u7406\u53d1\u751f\u9519\u8bef", (Throwable)e);
            }
            this.status = "FILE_PROCESS_ERROR";
        }
        return this.fileInfos;
    }

    private void validate(FileItem fileItem) throws AttachmentException {
        String fileName = this.getFileName(fileItem);
        if (fileItem.getSize() <= 0L || StringUtils.isEmpty((String)fileName)) {
            throw new AttachmentException("msg.warning.upload.file.empty", "msg.warning.upload.file.empty", new Object[0]);
        }
        if (fileItem.getSize() > this.singleFileSize) {
            throw new AttachmentException("hap.upload.file.size.limit.exceeded", "hap.upload.file.size.limit.exceeded", new String[]{FormatUtil.formatFileSize(this.singleFileSize)});
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\u4e0a\u4f20\u6587\u4ef6\u540d\u4e3a\uff1a{}  =====> \u5176 contentType: {} ", (Object)fileName, (Object)fileItem.getContentType());
        }
        if (!this.filter.isAccept(fileItem.getName(), fileItem.getContentType())) {
            throw new AttachmentException("hap.upload.file.type.mismatch", "hap.upload.file.type.mismatch", new Object[0]);
        }
    }

    private String getFileName(FileItem item) {
        int index;
        String fileName = item.getName();
        if (fileName != null && (index = fileName.lastIndexOf(92)) != -1) {
            fileName = fileName.substring(index + 1);
        }
        return fileName;
    }

    private void processUploadedFile(FileItem item) throws AttachmentException {
        if (!item.isFormField()) {
            DefaultFileInfo fileInfo = new DefaultFileInfo();
            String fileName = this.getFileName(item);
            fileInfo.setOriginalName(fileName);
            fileInfo.setContentType(item.getContentType());
            this.validate(item);
            try {
                File f = new File(this.controller.getFileDir(this.request, fileName) + this.controller.newName(fileName));
                item.write(f);
                fileInfo.setFile(f);
                fileInfo.setStatus("UPLOAD_SUCCESS");
                fileInfo.setUrl(this.controller.urlFix(this.request, f));
                if (logger.isDebugEnabled()) {
                    logger.debug(f.getAbsolutePath());
                }
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error("\u6587\u4ef6\u4e0a\u4f20\u9519\u8bef\uff01", (Throwable)e);
                }
                fileInfo.setStatus("UPLOAD_ERROR");
                this.status = "UPLOAD_ERROR";
            }
            this.fileInfos.add(fileInfo);
        }
    }

    private void processFormField(FileItem item) throws IOException {
        if (item.isFormField()) {
            String name = item.getFieldName();
            String value = new String(item.getString().getBytes("ISO-8859-1"), "UTF-8");
            this.params.put(name, value);
        }
    }

    private void processFormField(String name, String value) throws IOException {
        value = new String(value.getBytes("ISO-8859-1"), "UTF-8");
        this.params.put(name, value);
    }

    @Override
    public void setController(Controller controller) {
        this.controller = controller;
    }

    @Override
    public void addFileProcessor(FileProcessor processor) {
        this.chain.addProcessor(processor);
    }

    public void doProcess() throws Exception {
    }

    @Override
    public String getParams(String key) {
        return this.params.get(key);
    }

    @Override
    public void setParams(String key, String value) {
        this.request.setAttribute(key, (Object)value);
    }

    @Override
    public void setSingleFileSize(long singleFileSize) {
        this.singleFileSize = singleFileSize;
    }

    @Override
    public void setAllFileSize(long allFileSize) {
        this.allFileSize = allFileSize;
    }

    @Override
    public void setMaxFileNum(int maxFileNum) {
        this.maxFileNum = maxFileNum;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public void setFilter(ContentTypeFilter filter) {
        this.filter = filter;
    }

    public static class MultipartFiledByFileItem
    implements FileItem {
        MultipartFile multipartFile = null;

        MultipartFiledByFileItem(MultipartFile multipartFile) {
            this.multipartFile = multipartFile;
        }

        public InputStream getInputStream() throws IOException {
            return this.multipartFile.getInputStream();
        }

        public String getContentType() {
            return this.multipartFile.getContentType();
        }

        public String getName() {
            return this.multipartFile.getOriginalFilename();
        }

        public boolean isInMemory() {
            return false;
        }

        public long getSize() {
            return this.multipartFile.getSize();
        }

        public byte[] get() {
            return new byte[0];
        }

        public String getString(String s) throws UnsupportedEncodingException {
            return null;
        }

        public String getString() {
            return null;
        }

        public void write(File file) throws Exception {
            this.multipartFile.transferTo(file);
        }

        public void delete() {
        }

        public String getFieldName() {
            return this.multipartFile.getName();
        }

        public void setFieldName(String s) {
        }

        public boolean isFormField() {
            return false;
        }

        public void setFormField(boolean b) {
        }

        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        public FileItemHeaders getHeaders() {
            return null;
        }

        public void setHeaders(FileItemHeaders fileItemHeaders) {
        }
    }
}

