/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.api.gateway.service.impl;

import com.hand.hap.api.application.dto.ApiAccessLimit;
import com.hand.hap.api.gateway.dto.ApiInterface;
import com.hand.hap.api.gateway.mapper.ApiInterfaceMapper;
import com.hand.hap.api.gateway.service.IApiInterfaceService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class ApiInterfaceServiceImpl
extends BaseServiceImpl<ApiInterface>
implements IApiInterfaceService {
    @Autowired
    private ApiInterfaceMapper mapper;

    @Override
    public List<ApiInterface> selectByServerId(IRequest request, ApiInterface srInterface) {
        return this.mapper.selectByServerId(srInterface);
    }

    @Override
    public List<ApiInterface> selectByServerIdWithLimit(IRequest request, String clientId, Long serverId) {
        List<ApiInterface> apiInterfaces = this.mapper.selectByServerIdWithLimit(clientId, serverId);
        apiInterfaces.stream().forEach(apiInterface -> {
            if (null == apiInterface.getApiAccessLimit()) {
                apiInterface.setApiAccessLimit(new ApiAccessLimit());
            }
            if (null == apiInterface.getApiAccessLimit().getAccessFlag()) {
                apiInterface.getApiAccessLimit().setAccessFlag("Y");
            }
        });
        return apiInterfaces;
    }

    @Override
    public List<ApiInterface> getInterfacesByServerCode(IRequest requestContext, String clientId, String serverCode) {
        List<ApiInterface> apiInterfaces = this.mapper.getInterfacesByServerCode(serverCode);
        apiInterfaces.stream().forEach(apiInterface -> {
            ApiAccessLimit apiAccessLimit = new ApiAccessLimit();
            apiAccessLimit.setAccessFlag("Y");
            apiAccessLimit.setClientId(clientId);
            apiAccessLimit.setServerCode(serverCode);
            apiAccessLimit.setInterfaceCode(apiInterface.getCode());
            apiInterface.setApiAccessLimit(apiAccessLimit);
        });
        return apiInterfaces;
    }
}

