/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.api.gateway.controllers;

import com.hand.hap.api.gateway.dto.ApiServer;
import com.hand.hap.api.gateway.service.IApiServerService;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sys/gateway/server", "/api/sys/gateway/server"})
public class ApiServerController
extends BaseController {
    @Autowired
    private IApiServerService service;

    @RequestMapping(value={"/query"})
    @ResponseBody
    public ResponseData query(ApiServer dto, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pageSize, HttpServletRequest request) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.service.select(requestContext, dto, page, pageSize));
    }

    @RequestMapping(value={"/remove"})
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<ApiServer> dto) {
        this.service.batchDelete(dto);
        return new ResponseData();
    }

    @RequestMapping(value={"/import"})
    @ResponseBody
    public ResponseData importServer(HttpServletRequest request, @RequestBody ApiServer dto) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(Arrays.asList(this.service.importServer(requestContext, dto)));
    }

    @RequestMapping(value={"/getById"})
    @ResponseBody
    public ResponseData getById(HttpServletRequest request, @RequestBody ApiServer dto) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(Arrays.asList(this.service.selectByPrimaryKey(requestContext, dto)));
    }

    @RequestMapping(value={"/submit"})
    @ResponseBody
    public ResponseData submit(@RequestBody List<ApiServer> dto, BindingResult result, HttpServletRequest request) {
        this.getValidator().validate(dto, (Errors)result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(this.getErrorMessage((Errors)result, request));
            return responseData;
        }
        IRequest requestCtx = this.createRequestContext(request);
        return new ResponseData(this.service.batchUpdate(requestCtx, dto));
    }
}

