/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.manager;

import com.hand.hap.activiti.util.ActivitiUtils;
import com.hand.hap.hr.dto.Employee;
import com.hand.hap.hr.dto.Position;
import com.hand.hap.hr.mapper.EmployeeMapper;
import com.hand.hap.hr.mapper.PositionMapper;
import com.hand.hap.message.IMessageConsumer;
import com.hand.hap.message.TopicMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.identity.Group;
import org.activiti.engine.impl.persistence.entity.UserEntity;
import org.activiti.engine.impl.persistence.entity.data.impl.MybatisUserDataManager;
import org.activiti.spring.SpringProcessEngineConfiguration;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

@TopicMonitor(channel={"employee.change"})
public class CustomUserDataManager
extends MybatisUserDataManager
implements IMessageConsumer<Employee>,
InitializingBean {
    @Autowired
    private PositionMapper positionMapper;
    @Autowired
    private EmployeeMapper employeeMapper;
    public Map<String, UserEntity> userCache = new HashMap<String, UserEntity>();
    @Autowired
    private SpringProcessEngineConfiguration pec;

    public CustomUserDataManager() {
        super(null);
    }

    public List<Group> findGroupsByUser(String userId) {
        List<Position> positions = this.positionMapper.getPositionByEmployeeCode(userId);
        ArrayList<Group> gs = new ArrayList<Group>();
        for (Position position : positions) {
            gs.add((Group)ActivitiUtils.toActivitiGroup(position));
        }
        return gs;
    }

    public UserEntity findById(String entityId) {
        UserEntity userEntity = this.userCache.get(entityId);
        if (userEntity == null) {
            Employee employee = this.employeeMapper.queryByCode(entityId);
            userEntity = ActivitiUtils.toActivitiUser(employee);
            this.userCache.put(entityId, userEntity);
        }
        return userEntity;
    }

    @Override
    public void onMessage(Employee message, String pattern) {
        this.userCache.remove(message.getEmployeeCode());
    }

    public void afterPropertiesSet() throws Exception {
        this.processEngineConfiguration = this.pec;
    }
}

