/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.listeners;

import com.hand.hap.account.dto.User;
import com.hand.hap.account.service.IUserService;
import com.hand.hap.activiti.custom.process.CustomHistoricProcessInstanceQuery;
import com.hand.hap.activiti.service.IActivitiEntityService;
import com.hand.hap.core.AppContextInitListener;
import com.hand.hap.system.service.IBadgeService;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.delegate.TransactionDependentTaskListener;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class TaskCreateNotificationListener
implements TransactionDependentTaskListener,
TaskListener,
AppContextInitListener {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private TaskService taskService;
    private HistoryService historyService;
    @Autowired
    private IBadgeService badgeService;
    @Autowired
    private IUserService userService;
    @Autowired
    private IActivitiEntityService entityService;

    public void notify(String processInstanceId, String executionId, org.activiti.bpmn.model.Task task, Map<String, Object> executionVariables, Map<String, Object> customPropertiesMap) {
        ExecutionEntity execution = (ExecutionEntity)Context.getCommandContext().getExecutionEntityManager().findById(executionId);
        this.sendMessage((DelegateExecution)execution, task, processInstanceId, executionId);
    }

    @Override
    public void contextInitialized(ApplicationContext applicationContext) {
        this.taskService = (TaskService)applicationContext.getBean(TaskService.class);
        this.historyService = (HistoryService)applicationContext.getBean(HistoryService.class);
    }

    public void notify(DelegateTask delegateTask) {
    }

    public void sendMessage(DelegateExecution execution, org.activiti.bpmn.model.Task task, String processInstanceId, String executionId) {
        List<String> emps;
        UserTask userTask = (UserTask)task;
        ExpressionManager manager = Context.getProcessEngineConfiguration().getExpressionManager();
        if (StringUtils.isNotEmpty((String)userTask.getAssignee())) {
            Object assigneeObj = manager.createExpression(userTask.getAssignee()).getValue((VariableScope)execution);
            if (assigneeObj != null) {
                this.sendMessage(assigneeObj.toString());
            }
        } else {
            List candidateGroups;
            List candidateUsers = userTask.getCandidateUsers();
            if (candidateUsers != null) {
                for (Object user : candidateUsers) {
                    Object assigneeObj = manager.createExpression((String)user).getValue((VariableScope)execution);
                    if (assigneeObj == null) continue;
                    this.sendMessage(assigneeObj.toString());
                }
            }
            if ((candidateGroups = userTask.getCandidateGroups()) != null) {
                for (String group : candidateGroups) {
                    Object groupObj = manager.createExpression(group).getValue((VariableScope)execution);
                    if (groupObj == null) continue;
                    emps = this.entityService.getPositionEmp(groupObj.toString());
                    for (String emp : emps) {
                        this.sendMessage(emp);
                    }
                }
            }
        }
        if (StringUtils.isEmpty((String)userTask.getAssignee()) && userTask.getCandidateUsers().isEmpty() && userTask.getCandidateGroups().isEmpty()) {
            Task taskEntity = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).executionId(executionId)).singleResult();
            if (taskEntity == null) {
                return;
            }
            String assignee = taskEntity.getAssignee();
            if (StringUtils.isNotEmpty((String)assignee)) {
                this.sendMessage(assignee);
            } else {
                List idList = this.taskService.getIdentityLinksForTask(taskEntity.getId());
                for (IdentityLink il : idList) {
                    if (il.getGroupId() != null) {
                        emps = this.entityService.getPositionEmp(il.getGroupId());
                        for (String emp : emps) {
                            this.sendMessage(emp);
                        }
                        continue;
                    }
                    if (il.getUserId() == null) continue;
                    this.sendMessage(il.getUserId());
                }
            }
        }
    }

    public void sendMessage(String assignee) {
        List<User> users = this.userService.selectUserNameByEmployeeCode(assignee);
        if (users == null) {
            this.log.error("user not found !!!");
            return;
        }
        for (User user : users) {
            user.setEmployeeCode(assignee);
            this.sendMessage(user);
        }
    }

    public void sendMessage(User user) {
        String userName = user.getUserName();
        long count = this.taskService.createTaskQuery().taskCandidateOrAssigned(user.getEmployeeCode()).count();
        this.badgeService.sendBadgeMessageToUser(userName, "WFL_MY_TASK", count);
    }

    public void sendMessageByGroup(String groupId) {
        List<String> emps = this.entityService.getPositionEmp(groupId);
        for (String emp : emps) {
            this.sendMessage(emp);
        }
    }

    public void sendMessageForCC(String assignee) {
        List<User> users = this.userService.selectUserNameByEmployeeCode(assignee);
        if (users == null) {
            this.log.error("user not found !!!");
            return;
        }
        for (User user : users) {
            user.setEmployeeCode(assignee);
            this.sendMessageForCC(user);
        }
    }

    public void sendMessageForCC(User user) {
        String userName = user.getUserName();
        CustomHistoricProcessInstanceQuery query = (CustomHistoricProcessInstanceQuery)this.historyService.createHistoricProcessInstanceQuery();
        query.setCarbonCopyUser(user.getEmployeeCode());
        query.setReadFlag("N");
        long count = query.list().size();
        this.badgeService.sendBadgeMessageToUser(userName, "WFL_CARBON", count);
    }
}

