/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.demo.components;

import com.hand.hap.activiti.listeners.IUserTaskNotifier;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.hr.dto.Employee;
import com.hand.hap.hr.dto.EmployeeAssign;
import com.hand.hap.hr.dto.Position;
import com.hand.hap.hr.mapper.EmployeeAssignMapper;
import com.hand.hap.hr.mapper.EmployeeMapper;
import com.hand.hap.hr.mapper.PositionMapper;
import com.hand.hap.mail.ReceiverTypeEnum;
import com.hand.hap.mail.dto.MessageReceiver;
import com.hand.hap.mail.mapper.MessageTemplateMapper;
import com.hand.hap.mail.service.IMessageService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.activiti.engine.impl.persistence.entity.GroupEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.UserEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DemoNotifier
implements IUserTaskNotifier {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String activityEmailNotifierTemplateCode = "ACT_EMAIL_NOTIFIER";
    @Autowired
    MessageTemplateMapper templateMapper;
    @Autowired
    IMessageService messageService;
    @Autowired
    EmployeeAssignMapper employeeAssignMapper;
    @Autowired
    EmployeeMapper employeeMapper;
    @Autowired
    PositionMapper positionMapper;

    @Override
    public void onTaskCreate(TaskEntity task, UserEntity userEntity) {
        HashMap<String, Object> contentInfo = new HashMap<String, Object>();
        contentInfo.put("dom", task.getName());
        contentInfo.put("receiver", userEntity.getFirstName());
        contentInfo.put("content", task.getDescription());
        IRequest iRequest = RequestHelper.getCurrentRequest();
        ArrayList<MessageReceiver> receivers = new ArrayList<MessageReceiver>();
        MessageReceiver receiver = new MessageReceiver();
        receiver.setMessageAddress(userEntity.getEmail());
        receiver.setMessageType(ReceiverTypeEnum.NORMAL.getCode());
        receivers.add(receiver);
        try {
            this.messageService.addEmailMessage(iRequest.getUserId(), "TEST", "ACT_EMAIL_NOTIFIER", contentInfo, null, receivers);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void onTaskCreate(TaskEntity task, GroupEntity groupEntity) {
        Position position = this.positionMapper.getPositionByCode(groupEntity.getId());
        Long positionId = position.getPositionId();
        EmployeeAssign ass = new EmployeeAssign();
        ass.setPositionId(positionId);
        List<EmployeeAssign> employeeAssign = this.employeeAssignMapper.select(ass);
        if (employeeAssign.isEmpty()) {
            this.logger.error("NO EMPLOYEE");
        } else {
            for (EmployeeAssign employee : employeeAssign) {
                Employee employee1 = (Employee)this.employeeMapper.selectByPrimaryKey(employee.getEmployeeId());
                HashMap<String, Object> contentInfo = new HashMap<String, Object>();
                contentInfo.put("dom", task.getName());
                contentInfo.put("receiver", employee1.getName());
                contentInfo.put("content", task.getDescription());
                IRequest iRequest = RequestHelper.getCurrentRequest();
                ArrayList<MessageReceiver> receivers = new ArrayList<MessageReceiver>();
                MessageReceiver receiver = new MessageReceiver();
                receiver.setMessageAddress(employee1.getEmail());
                receiver.setMessageType(ReceiverTypeEnum.NORMAL.getCode());
                receivers.add(receiver);
                try {
                    this.messageService.addEmailMessage(iRequest.getUserId(), "TEST", "ACT_EMAIL_NOTIFIER", contentInfo, null, receivers);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

