/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.custom;

import com.hand.hap.activiti.dto.WflRules;
import com.hand.hap.activiti.mapper.RulesMapper;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.bpmn.behavior.BusinessRuleTaskActivityBehavior;
import org.activiti.engine.impl.rules.RulesAgendaFilter;
import org.activiti.engine.impl.rules.RulesHelper;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.commons.lang.StringUtils;
import org.drools.KnowledgeBase;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.Resource;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.AgendaFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomBusinessRuleTaskActivityBehavior
extends BusinessRuleTaskActivityBehavior {
    @Autowired
    private RulesMapper rulesMapper;
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void execute(DelegateExecution execution) {
        ProcessDefinition processDefinition = ProcessDefinitionUtil.getProcessDefinition((String)execution.getProcessDefinitionId());
        String deploymentId = processDefinition.getDeploymentId();
        KnowledgeBase knowledgeBase = null;
        try {
            knowledgeBase = RulesHelper.findKnowledgeBaseByDeploymentId((String)deploymentId);
        }
        catch (ActivitiException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            knowledgeBase = this.knowledgeBuilderFromDatabase(execution, processDefinition).newKnowledgeBase();
        }
        StatefulKnowledgeSession ksession = knowledgeBase.newStatefulKnowledgeSession();
        if (this.variablesInputExpressions != null) {
            for (Object variable : this.variablesInputExpressions) {
                ksession.insert(variable.getValue((VariableScope)execution));
            }
        }
        if (!this.rulesExpressions.isEmpty()) {
            RulesAgendaFilter filter = new RulesAgendaFilter();
            for (Expression ruleName : this.rulesExpressions) {
                filter.addSuffic(ruleName.getValue((VariableScope)execution).toString());
            }
            filter.setAccept(!this.exclude);
            ksession.fireAllRules((AgendaFilter)filter);
        } else {
            ksession.fireAllRules();
        }
        Collection ruleOutputObjects = ksession.getObjects();
        if (ruleOutputObjects != null && !ruleOutputObjects.isEmpty()) {
            ArrayList outputVariables = new ArrayList();
            outputVariables.addAll(ruleOutputObjects);
            execution.setVariable(this.resultVariable, outputVariables);
        }
        ksession.dispose();
        this.leave(execution);
    }

    protected KnowledgeBuilder knowledgeBuilderFromDatabase(DelegateExecution execution, ProcessDefinition processDefinition) {
        String nodeId;
        String processKey = processDefinition.getKey();
        WflRules rules = this.rulesMapper.selectByExecution(processKey, nodeId = execution.getCurrentFlowElement().getId());
        if (rules == null && (rules = this.rulesMapper.selectByExecution(processKey, null)) == null) {
            throw new RuntimeException("There is no rule associate with Process:" + processDefinition.getName() + ",Node:" + execution.getCurrentFlowElement().getName());
        }
        Resource resource = null;
        try {
            resource = ResourceFactory.newByteArrayResource((byte[])StringUtils.defaultIfEmpty((String)rules.getRuleContent(), (String)"").getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(resource, ResourceType.DRL);
        if (kbuilder.hasErrors()) {
            throw new RuntimeException("Error in drools: " + kbuilder.getErrors().toString());
        }
        return kbuilder;
    }
}

