/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.custom;

import com.hand.hap.activiti.custom.CustomBusinessRuleTaskActivityBehavior;
import com.hand.hap.activiti.custom.CustomParallelMultiInstanceBehavior;
import com.hand.hap.activiti.custom.CustomSequentialMultiInstanceBehavior;
import com.hand.hap.activiti.custom.CustomUserTaskActivityBehavior;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BusinessRuleTask;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.BusinessRuleTaskDelegate;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import org.activiti.engine.impl.bpmn.parser.factory.DefaultActivityBehaviorFactory;
import org.activiti.engine.impl.delegate.ActivityBehavior;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class CustomBehaviorFactory
extends DefaultActivityBehaviorFactory {
    @Autowired
    private ApplicationContext applicationContext;

    public ActivityBehavior createBusinessRuleTaskActivityBehavior(BusinessRuleTask businessRuleTask) {
        CustomBusinessRuleTaskActivityBehavior ruleActivity;
        if (StringUtils.isNotEmpty((CharSequence)businessRuleTask.getClassName())) {
            try {
                Class<?> clazz = Class.forName(businessRuleTask.getClassName());
                ruleActivity = (BusinessRuleTaskDelegate)clazz.newInstance();
            }
            catch (Exception e) {
                throw new ActivitiException("Could not instantiate businessRuleTask (id:" + businessRuleTask.getId() + ") class: " + businessRuleTask.getClassName(), (Throwable)e);
            }
        } else {
            ruleActivity = new CustomBusinessRuleTaskActivityBehavior();
            this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)ruleActivity);
        }
        for (String ruleVariableInputObject : businessRuleTask.getInputVariables()) {
            ruleActivity.addRuleVariableInputIdExpression(this.expressionManager.createExpression(ruleVariableInputObject.trim()));
        }
        for (String rule : businessRuleTask.getRuleNames()) {
            ruleActivity.addRuleIdExpression(this.expressionManager.createExpression(rule.trim()));
        }
        ruleActivity.setExclude(businessRuleTask.isExclude());
        if (businessRuleTask.getResultVariableName() != null && businessRuleTask.getResultVariableName().length() > 0) {
            ruleActivity.setResultVariable(businessRuleTask.getResultVariableName());
        } else {
            ruleActivity.setResultVariable("org.activiti.engine.rules.OUTPUT");
        }
        return ruleActivity;
    }

    public ParallelMultiInstanceBehavior createParallelMultiInstanceBehavior(Activity activity, AbstractBpmnActivityBehavior innerActivityBehavior) {
        CustomParallelMultiInstanceBehavior parallelBehavior = new CustomParallelMultiInstanceBehavior(activity, innerActivityBehavior);
        this.applicationContext.getAutowireCapableBeanFactory().autowireBean((Object)parallelBehavior);
        return parallelBehavior;
    }

    public SequentialMultiInstanceBehavior createSequentialMultiInstanceBehavior(Activity activity, AbstractBpmnActivityBehavior innerActivityBehavior) {
        return new CustomSequentialMultiInstanceBehavior(activity, innerActivityBehavior);
    }

    public UserTaskActivityBehavior createUserTaskActivityBehavior(UserTask userTask) {
        return new CustomUserTaskActivityBehavior(userTask);
    }
}

