/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.activiti.components;

import com.hand.hap.activiti.custom.ICustomTaskProcessor;
import com.hand.hap.activiti.util.ActivitiUtils;
import java.util.Date;
import org.activiti.engine.task.Task;
import org.springframework.stereotype.Component;

@Component
public class DefaultCustomTaskProcessor
implements ICustomTaskProcessor {
    @Override
    public Task processPriority(Task task) {
        Long dueTime = ActivitiUtils.secondsBetweenDate(task.getCreateTime(), task.getDueDate());
        Long interval = this.getDueTime(task.getCreateTime(), dueTime);
        int priority = task.getPriority();
        if (interval <= 0L) {
            task.setPriority(100);
        } else if (interval <= dueTime / 3L) {
            task.setPriority(90);
        } else if (interval <= dueTime / 3L * 2L) {
            if (priority < 33) {
                task.setPriority(50);
            } else {
                task.setPriority(80);
            }
        }
        return task;
    }

    @Override
    public Long getDueTime(Date startDate, Long dueTime) {
        Long elapsedTime = ActivitiUtils.secondsBetweenDate(startDate, new Date());
        Long processDueTime = dueTime - elapsedTime;
        return processDueTime;
    }

    @Override
    public boolean processorContinue() {
        return true;
    }

    @Override
    public int getOrder() {
        return 999;
    }
}

