/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.account.service.impl;

import com.hand.hap.account.constants.UserConstants;
import com.hand.hap.account.dto.User;
import com.hand.hap.account.dto.UserRole;
import com.hand.hap.account.exception.UserException;
import com.hand.hap.account.mapper.UserMapper;
import com.hand.hap.account.mapper.UserRoleMapper;
import com.hand.hap.account.service.IRole;
import com.hand.hap.account.service.IRoleService;
import com.hand.hap.account.service.IUserService;
import com.hand.hap.cache.impl.ResourceItemAssignCache;
import com.hand.hap.cache.impl.RoleFunctionCache;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.annotation.StdWho;
import com.hand.hap.function.dto.Function;
import com.hand.hap.function.dto.MenuItem;
import com.hand.hap.function.dto.Resource;
import com.hand.hap.function.dto.ResourceItemAssign;
import com.hand.hap.function.mapper.ResourceItemAssignMapper;
import com.hand.hap.function.service.IFunctionService;
import com.hand.hap.function.service.IRoleFunctionService;
import com.hand.hap.function.service.IRoleResourceItemService;
import com.hand.hap.mybatis.common.Criteria;
import com.hand.hap.mybatis.common.query.Comparison;
import com.hand.hap.mybatis.common.query.WhereField;
import com.hand.hap.security.IUserSecurityStrategy;
import com.hand.hap.security.PasswordManager;
import com.hand.hap.security.service.impl.UserSecurityStrategyManager;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class UserServiceImpl
extends BaseServiceImpl<User>
implements IUserService {
    @Autowired
    private PasswordManager passwordManager;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    UserSecurityStrategyManager userSecurityStrategyManager;
    @Autowired
    @Qualifier(value="roleServiceImpl")
    private IRoleService roleService;
    @Autowired
    private UserRoleMapper userRoleMapper;
    @Autowired
    private IFunctionService functionService;
    @Autowired
    private IRoleFunctionService roleFunctionService;
    @Autowired
    private IRoleResourceItemService roleResourceItemService;
    @Autowired
    private ResourceItemAssignCache resourceItemAssignCache;
    @Autowired
    private ResourceItemAssignMapper resourceItemAssignMapper;
    @Autowired
    private RoleFunctionCache roleFunctionCache;

    @Override
    public User insertSelective(IRequest request, User record) {
        if (StringUtils.isEmpty((String)record.getPassword())) {
            record.setPassword(this.passwordManager.getDefaultPassword());
        }
        record.setPasswordEncrypted(this.passwordManager.encode(record.getPassword()));
        List<IUserSecurityStrategy> userSecurityStrategies = this.userSecurityStrategyManager.getUserSecurityStrategyList();
        for (IUserSecurityStrategy userSecurityStrategy : userSecurityStrategies) {
            record = userSecurityStrategy.beforeCreateUser(request, record);
        }
        record = super.insertSelective(request, record);
        this.userMapper.updatePassword(record.getUserId(), record.getPasswordEncrypted());
        return record;
    }

    @Override
    public void validateEmail(String email) throws UserException {
        if (!UserConstants.PATTERN_EMAIL_REGEX.matcher(email).matches()) {
            throw new UserException("error.user.email", new Object[0]);
        }
    }

    @Override
    public void validatePhone(String phone) throws UserException {
        if (!UserConstants.PATTERN_PHONE_REGEX.matcher(phone).matches()) {
            throw new UserException("error.user.phone", new Object[0]);
        }
    }

    @Override
    public User login(User user) throws UserException {
        if (user == null || org.apache.commons.lang3.StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{user.getUserName(), user.getPassword()})) {
            throw new UserException("error.login.name_password_not_match", "error.login.name_password_not_match", null);
        }
        User user1 = this.userMapper.selectByUserName(user.getUserName());
        if (user1 == null) {
            throw new UserException("error.login.name_password_not_match", "error.login.name_password_not_match", null);
        }
        if ("LOCK".equals(user1.getStatus())) {
            throw new UserException("error.user.account_expired", "error.user.account_expired", null);
        }
        if (user1.getStartActiveDate() != null && user1.getStartActiveDate().getTime() > System.currentTimeMillis()) {
            throw new UserException("error.user.account_expired", "error.user.account_expired", null);
        }
        if (user1.getEndActiveDate() != null && user1.getEndActiveDate().getTime() < System.currentTimeMillis()) {
            throw new UserException("error.user.account_expired", "error.user.account_expired", null);
        }
        if (!this.passwordManager.matches(user.getPassword(), user1.getPasswordEncrypted())) {
            throw new UserException("error.login.name_password_not_match", "error.login.name_password_not_match", null);
        }
        return user1;
    }

    @Override
    public User selectByUserName(String userName) {
        return this.userMapper.selectByUserName(userName);
    }

    @Override
    public List<User> selectUserNameByEmployeeCode(String employeeCode) {
        return this.userMapper.selectUserNameByEmployeeCode(employeeCode);
    }

    @Override
    public User updateByPrimaryKeySelective(IRequest request, @StdWho User record) {
        int count = this.userMapper.updateBasic(record);
        this.checkOvn(count, record);
        return record;
    }

    @Override
    @Transactional
    public void updatePassword(Long userId, String password) {
        String passwordEncrypted = this.passwordManager.encode(password);
        this.userMapper.updatePassword(userId, passwordEncrypted);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public void validatePassword(IRequest request, String newPwd, String newPwdAgain) throws UserException {
        List<IUserSecurityStrategy> userSecurityStrategies = this.userSecurityStrategyManager.getUserSecurityStrategyList();
        for (IUserSecurityStrategy userSecurityStrategy : userSecurityStrategies) {
            userSecurityStrategy.validatePassword(newPwd, newPwdAgain);
        }
    }

    @Override
    public void updateNotFirstLogin(Long userId, String status) {
        this.userMapper.updateFirstLogin(userId, status);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS)
    public List<User> selectUsers(IRequest request, User user, int pageNum, int pageSize) {
        Criteria criteria = new Criteria(user);
        criteria.where(new WhereField("userName", Comparison.LIKE), "userId", "userType", new WhereField("employeeCode", Comparison.LIKE), "employeeName", "status");
        criteria.select("userId", "userName", "employeeId", "employeeName", "employeeCode", "email", "phone", "status", "startActiveDate", "endActiveDate", "description");
        return super.selectOptions(request, user, criteria, pageNum, pageSize);
    }

    @Override
    public List<IRole> selectUserAndRoles(IRequest request, User user, int pageNum, int pageSize) {
        List<IRole> roles = this.roleService.selectRolesByUser(request, user);
        return roles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MenuItem> updateMenu(List<MenuItem> menus, Set<Long> userFunctions) {
        if (CollectionUtils.isEmpty(menus) || CollectionUtils.isEmpty(userFunctions)) {
            return new ArrayList<MenuItem>();
        }
        List<MenuItem> list = menus;
        synchronized (list) {
            Iterator<MenuItem> iterator = menus.iterator();
            while (iterator.hasNext()) {
                List<MenuItem> items;
                MenuItem menu = iterator.next();
                boolean hasChild = false;
                if (CollectionUtils.isNotEmpty(menu.getChildren()) && CollectionUtils.isNotEmpty(items = this.updateMenu(menu.getChildren(), userFunctions))) {
                    hasChild = true;
                }
                boolean hasFunction = false;
                for (Long userFunction : userFunctions) {
                    if (!menu.getId().equals(userFunction)) continue;
                    hasFunction = true;
                    break;
                }
                if (hasFunction || hasChild) continue;
                iterator.remove();
            }
        }
        return menus;
    }

    private Set<Long> getUserFunctions(List<UserRole> allRoleIds) {
        if (CollectionUtils.isEmpty(allRoleIds)) {
            return null;
        }
        HashSet<Long> userFunctions = new HashSet<Long>();
        for (UserRole userRole : allRoleIds) {
            Object[] ids = this.roleFunctionService.getRoleFunctionById(userRole.getRoleId());
            if (!ArrayUtils.isNotEmpty((Object[])ids)) continue;
            userFunctions.addAll(Arrays.asList(ids));
        }
        return userFunctions;
    }

    private List<UserRole> getAllRoleIds(Long userId) {
        UserRole userRole = new UserRole();
        userRole.setUserId(userId);
        List<UserRole> userRoles = this.userRoleMapper.select(userRole);
        return userRoles;
    }

    @Override
    public List<MenuItem> queryFunction(IRequest requestContext, Long userId) {
        List<MenuItem> menus = this.functionService.selectAllMenus(requestContext);
        Set<Long> userFunctions = null;
        if (userId != null) {
            List<UserRole> allRoleIds = this.getAllRoleIds(userId);
            userFunctions = this.getUserFunctions(allRoleIds);
        }
        return this.updateMenu(menus, userFunctions);
    }

    @Override
    public List<MenuItem> queryResourceItems(IRequest requestContext, Long userId, Long functionId) {
        Function function = new Function();
        function.setFunctionId(functionId);
        List<Resource> resources = this.roleResourceItemService.queryHtmlResources(requestContext, function);
        List<MenuItem> menus = this.updateResourceMenu(this.roleResourceItemService.createResources(resources));
        return this.updateMenuCheck(menus, this.getAllAssignElementIds(userId));
    }

    private List<MenuItem> updateMenuCheck(List<MenuItem> menus, List<Long> allAssignElementIds) {
        if (CollectionUtils.isEmpty(menus) || CollectionUtils.isEmpty(allAssignElementIds)) {
            return menus;
        }
        block0: for (MenuItem menuItem : menus) {
            if (CollectionUtils.isNotEmpty(menuItem.getChildren())) {
                this.updateMenuCheck(menuItem.getChildren(), allAssignElementIds);
            }
            for (Long assignElementId : allAssignElementIds) {
                if (!menuItem.getId().equals(assignElementId)) continue;
                menuItem.setIschecked(Boolean.FALSE);
                continue block0;
            }
        }
        return menus;
    }

    private List<Long> getAllAssignElementIds(Long userId) {
        ArrayList<Long> allAssignElementIds = new ArrayList<Long>();
        if (userId != null) {
            List<UserRole> userRoles = this.getAllRoleIds(userId);
            if (CollectionUtils.isEmpty(userRoles)) {
                return null;
            }
            List<Long> roleAssignElementIds = this.getAllRoleAssignElementIds(userRoles);
            Object[] userAssigns = this.resourceItemAssignCache.getValue("user_" + userId);
            if (ArrayUtils.isEmpty((Object[])userAssigns)) {
                if (CollectionUtils.isNotEmpty(roleAssignElementIds)) {
                    allAssignElementIds.addAll(roleAssignElementIds);
                }
                return allAssignElementIds;
            }
            for (Object userAssign : userAssigns) {
                if (!"N".equalsIgnoreCase(((ResourceItemAssign)userAssign).getEnable())) continue;
                allAssignElementIds.add(((ResourceItemAssign)userAssign).getElementId());
            }
            if (CollectionUtils.isNotEmpty(roleAssignElementIds)) {
                for (Long roleAssignElementId : roleAssignElementIds) {
                    boolean check = true;
                    for (Object userAssign : userAssigns) {
                        if (!roleAssignElementId.equals(((ResourceItemAssign)userAssign).getElementId())) continue;
                        check = false;
                        break;
                    }
                    if (!check) continue;
                    allAssignElementIds.add(roleAssignElementId);
                }
            }
        }
        return allAssignElementIds;
    }

    private List<Long> getSameFunctions(Set<Long> allRoleFunctions, Set<Long> roleFunctions) {
        ArrayList<Long> sameFunctions = new ArrayList<Long>();
        for (Long allRoleFunction : allRoleFunctions) {
            for (Long roleFunction : roleFunctions) {
                if (!allRoleFunction.equals(roleFunction)) continue;
                sameFunctions.add(allRoleFunction);
            }
        }
        return sameFunctions;
    }

    private List<Long> compareFunctionElements(List<Long> allFunctionElements, List<Long> functionElements) {
        if (CollectionUtils.isEmpty(allFunctionElements) || CollectionUtils.isEmpty(functionElements)) {
            return new ArrayList<Long>();
        }
        allFunctionElements.retainAll(functionElements);
        return allFunctionElements;
    }

    private Map<Long, List<Long>> getFunctionElements(ResourceItemAssign[] assigns) {
        HashMap<Long, List<Long>> function = new HashMap<Long, List<Long>>();
        if (ArrayUtils.isNotEmpty((Object[])assigns)) {
            for (ResourceItemAssign assign : assigns) {
                ArrayList<Long> functionElements = (ArrayList<Long>)function.get(assign.getFunctionId());
                if (CollectionUtils.isEmpty((Collection)functionElements)) {
                    functionElements = new ArrayList<Long>();
                    function.put(assign.getFunctionId(), functionElements);
                }
                functionElements.add(assign.getElementId());
            }
        }
        return function;
    }

    private List<Long> getAllRoleAssignElementIds(List<UserRole> userRoles) {
        ArrayList<Long> allRoleAssignElementIds = new ArrayList<Long>();
        Map<Object, Object> allFunctionElements = new HashMap<Long, List>();
        boolean firstRole = true;
        HashSet<Long> allRoleFunctions = new HashSet<Long>();
        for (UserRole userRole : userRoles) {
            Long roleId = userRole.getRoleId();
            Object[] roleFunctionList = this.roleFunctionCache.getValue(roleId.toString());
            if (ArrayUtils.isEmpty((Object[])roleFunctionList)) continue;
            HashSet<Long> roleFunctions = new HashSet<Long>();
            for (Object function : roleFunctionList) {
                roleFunctions.add((Long)function);
            }
            Map<Long, List<Long>> functionElements = this.getFunctionElements(this.resourceItemAssignCache.getValue("role_" + roleId));
            if (firstRole) {
                firstRole = false;
                allRoleFunctions = roleFunctions;
                allFunctionElements = functionElements;
                continue;
            }
            List<Long> sameFunctions = this.getSameFunctions(allRoleFunctions, roleFunctions);
            for (Long roleFunction : roleFunctions) {
                boolean same = false;
                for (Long sameFunction : sameFunctions) {
                    if (!roleFunction.equals(sameFunction)) continue;
                    same = true;
                    break;
                }
                if (same) continue;
                allFunctionElements.put(roleFunction, functionElements.get(roleFunction));
            }
            for (Long sameFunction : sameFunctions) {
                List<Long> elements = this.compareFunctionElements((List)allFunctionElements.get(sameFunction), functionElements.get(sameFunction));
                allFunctionElements.put(sameFunction, elements);
            }
            allRoleFunctions.addAll(roleFunctions);
        }
        allFunctionElements.forEach((k, v) -> {
            if (CollectionUtils.isNotEmpty((Collection)v)) {
                for (Long assignElementId : v) {
                    allRoleAssignElementIds.add(assignElementId);
                }
            }
        });
        return allRoleAssignElementIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MenuItem> updateResourceMenu(List<MenuItem> menus) {
        if (CollectionUtils.isEmpty(menus)) {
            return menus;
        }
        this.removeVariableMenu(menus);
        List<MenuItem> list = menus;
        synchronized (list) {
            Iterator<MenuItem> iterator = menus.iterator();
            while (iterator.hasNext()) {
                MenuItem menu = iterator.next();
                if (!CollectionUtils.isEmpty(menu.getChildren())) continue;
                iterator.remove();
            }
        }
        return menus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeVariableMenu(List<MenuItem> menus) {
        List<MenuItem> list = menus;
        synchronized (list) {
            Iterator<MenuItem> iterator = menus.iterator();
            while (iterator.hasNext()) {
                MenuItem menu = iterator.next();
                if ("\u670d\u52a1\u7aef\u53d8\u91cf".equalsIgnoreCase(menu.getText())) {
                    iterator.remove();
                    break;
                }
                if (!CollectionUtils.isNotEmpty(menu.getChildren())) continue;
                this.removeVariableMenu(menu.getChildren());
            }
        }
    }

    @Override
    public List<ResourceItemAssign> updateResourceItemAssign(IRequest requestContext, List<ResourceItemAssign> resourceItemAssignList, Long userId, Long functionId) {
        this.resourceItemAssignMapper.deleteByUserIdAndFunctionId(userId, functionId);
        if (CollectionUtils.isNotEmpty(resourceItemAssignList)) {
            for (ResourceItemAssign resourceItemAssign : resourceItemAssignList) {
                resourceItemAssign.setAssignType("user");
                resourceItemAssign.setFunctionId(functionId);
                this.resourceItemAssignMapper.insertSelective(resourceItemAssign);
            }
        }
        this.resourceItemAssignCache.load("user_" + userId);
        return resourceItemAssignList;
    }

    @Override
    public void deleteResourceItems(Long userId, Long functionId) {
        this.resourceItemAssignMapper.deleteByUserIdAndFunctionId(userId, functionId);
        this.resourceItemAssignCache.load("user_" + userId);
    }

    @Override
    public List<User> batchUpdate(IRequest request, List<User> list) {
        Criteria criteria = new Criteria();
        criteria.update("employeeId", "email", "phone", "status", "endActiveDate", "startActiveDate", "description");
        for (User user : list) {
            switch (user.get__status()) {
                case "add": {
                    this.insertSelective(request, user);
                    break;
                }
                case "update": {
                    ((IUserService)this.self()).updateByPrimaryKeyOptions(request, user, criteria);
                }
            }
        }
        return list;
    }

    @Override
    public int deleteByPrimaryKey(User user) {
        int ret = super.deleteByPrimaryKey(user);
        this.userRoleMapper.deleteByUserId(user.getUserId());
        return ret;
    }
}

