/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.account.dto;

import com.hand.hap.account.service.IRole;
import com.hand.hap.core.annotation.MultiLanguage;
import com.hand.hap.core.annotation.MultiLanguageField;
import com.hand.hap.mybatis.annotation.Condition;
import com.hand.hap.mybatis.common.query.Where;
import com.hand.hap.system.dto.BaseDTO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@MultiLanguage
@Table(name="sys_role_b")
public class Role
extends BaseDTO
implements IRole {
    public static final String FIELD_ROLE_ID = "roleId";
    public static final String FIELD_ROLE_CODE = "roleCode";
    public static final String FIELD_ROLE_NAME = "roleName";
    public static final String FIELD_ROLE_DESCRIPTION = "roleDescription";
    public static final String FIELD_START_ACTIVE_DATE = "startActiveDate";
    public static final String FIELD_END_ACTIVE_DATE = "endActiveDate";
    public static final String FIELD_ENABLE_FLAG = "enableFlag";
    @Id
    @Column
    @GeneratedValue(generator="IDENTITY")
    private Long roleId;
    @Column
    @NotEmpty
    @Length(max=40)
    @OrderBy(value="ASC")
    @Where
    private String roleCode;
    @Column
    @MultiLanguageField
    @NotEmpty
    @Length(max=150)
    @Where
    private String roleName;
    @Column
    @MultiLanguageField
    @Length(max=240)
    @Where
    private String roleDescription;
    @Column
    @Condition(operator=">=")
    private Date startActiveDate;
    @Column
    @Condition(operator="<=")
    private Date endActiveDate;
    @Column
    private String enableFlag;

    @Override
    public Long getRoleId() {
        return this.roleId;
    }

    public void setRoleId(Long roleId) {
        this.roleId = roleId;
    }

    @Override
    public String getRoleCode() {
        return this.roleCode;
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = StringUtils.trim((String)roleCode);
    }

    @Override
    public String getRoleName() {
        return this.roleName;
    }

    @Override
    public boolean isEnabled() {
        return "Y".equals(this.enableFlag);
    }

    @Override
    public boolean isActive() {
        return !(this.startActiveDate != null && this.startActiveDate.getTime() > System.currentTimeMillis() || this.endActiveDate != null && this.endActiveDate.getTime() < System.currentTimeMillis());
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getRoleDescription() {
        return this.roleDescription;
    }

    public void setRoleDescription(String roleDescription) {
        this.roleDescription = roleDescription;
    }

    public static String getFIELD_ROLE_ID() {
        return FIELD_ROLE_ID;
    }

    public Date getStartActiveDate() {
        return this.startActiveDate;
    }

    public void setStartActiveDate(Date startActiveDate) {
        this.startActiveDate = startActiveDate;
    }

    public Date getEndActiveDate() {
        return this.endActiveDate;
    }

    public void setEndActiveDate(Date endActiveDate) {
        this.endActiveDate = endActiveDate;
    }

    public String getEnableFlag() {
        return this.enableFlag;
    }

    public void setEnableFlag(String enableFlag) {
        this.enableFlag = enableFlag;
    }
}

