/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.account.controllers;

import com.hand.hap.account.dto.User;
import com.hand.hap.account.exception.UserException;
import com.hand.hap.account.service.ISendRetrieveService;
import com.hand.hap.account.service.IUserInfoService;
import com.hand.hap.core.IRequest;
import com.hand.hap.mail.service.IMessageService;
import com.hand.hap.security.PasswordManager;
import com.hand.hap.security.captcha.ICaptchaManager;
import com.hand.hap.system.controllers.BaseController;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class UserInfoController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(UserInfoController.class);
    @Autowired
    private IUserInfoService userInfoService;
    @Autowired
    private ICaptchaManager captchaManager;
    @Autowired
    private ISendRetrieveService sendRetrieveService;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private IMessageService messageService;
    @Autowired
    private PasswordManager passwordManager;

    @RequestMapping(value={"/sys/um/sys_user_info.html"})
    @ResponseBody
    public ModelAndView userInfo(HttpServletRequest request) throws UserException {
        ModelAndView mv = new ModelAndView(this.getViewPath() + "/sys/um/sys_user_info");
        IRequest requestContext = this.createRequestContext(request);
        User user = this.userInfoService.selectUserByPrimaryKey(requestContext, requestContext.getUserId());
        Integer length = this.passwordManager.getPasswordMinLength();
        String complexity = this.passwordManager.getPasswordComplexity();
        mv.addObject("user", (Object)user);
        mv.addObject("length", (Object)length);
        mv.addObject("complexity", (Object)complexity);
        return mv;
    }
}

