/*
 * Decompiled with CFR 0.152.
 */
package com.hand.hap.account.controllers;

import com.hand.hap.account.dto.User;
import com.hand.hap.account.exception.UserException;
import com.hand.hap.account.service.IRoleService;
import com.hand.hap.account.service.IUserInfoService;
import com.hand.hap.account.service.IUserService;
import com.hand.hap.core.IRequest;
import com.hand.hap.core.exception.BaseException;
import com.hand.hap.function.dto.ResourceItemAssign;
import com.hand.hap.security.PasswordManager;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sys/user", "/api/sys/user"})
public class UserController
extends BaseController {
    @Autowired
    private IUserService userService;
    @Autowired
    private IRoleService roleService;
    @Autowired
    private IUserInfoService userInfoService;
    @Autowired
    private PasswordManager passwordManager;

    @RequestMapping(value={"/submitResourceItems"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData submitResourceItems(HttpServletRequest request, @RequestBody List<ResourceItemAssign> resourceItemAssignList, @RequestParam(required=false) Long userId, @RequestParam(required=false) Long functionId) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.userService.updateResourceItemAssign(requestContext, resourceItemAssignList, userId, functionId));
    }

    @RequestMapping(value={"/deleteResourceItems"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData deleteResourceItems(HttpServletRequest request, @RequestParam(required=false) Long userId, @RequestParam(required=false) Long functionId) {
        this.userService.deleteResourceItems(userId, functionId);
        return new ResponseData();
    }

    @RequestMapping(value={"/queryResourceItems"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData queryResourceItems(HttpServletRequest request, @RequestParam(required=false) Long userId, @RequestParam(required=false) Long functionId) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.userService.queryResourceItems(requestContext, userId, functionId));
    }

    @RequestMapping(value={"/queryFunction"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData queryFunction(HttpServletRequest request, @RequestParam(required=false) Long userId) {
        IRequest requestContext = this.createRequestContext(request);
        return new ResponseData(this.userService.queryFunction(requestContext, userId));
    }

    @RequestMapping(value={"/query"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData selectUsers(HttpServletRequest request, @ModelAttribute User user, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int pagesize) {
        IRequest iRequest = this.createRequestContext(request);
        return new ResponseData(this.userService.selectUsers(iRequest, user, page, pagesize));
    }

    @RequestMapping(value={"/submit"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData submitUsers(@RequestBody List<User> users, BindingResult result, HttpServletRequest request) throws BaseException {
        this.getValidator().validate(users, (Errors)result);
        if (result.hasErrors()) {
            ResponseData rd = new ResponseData(false);
            rd.setMessage(this.getErrorMessage((Errors)result, request));
            return rd;
        }
        return new ResponseData(this.userService.batchUpdate(this.createRequestContext(request), users));
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResponseData updateUserInfo(HttpServletRequest request, @RequestBody User user) throws BaseException {
        IRequest iRequest = this.createRequestContext(request);
        this.userService.validateEmail(user.getEmail());
        this.userService.validatePhone(user.getPhone());
        user.setUserId(iRequest.getUserId());
        this.userInfoService.update(iRequest, user);
        return new ResponseData(Arrays.asList(user));
    }

    @RequestMapping(value={"/remove"}, method={RequestMethod.POST})
    public ResponseData remove(@RequestBody List<User> users) throws BaseException {
        this.userService.batchDelete(users);
        return new ResponseData(users);
    }

    @RequestMapping(value={"/{userId}/roles"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseData selectUserAndRoles(HttpServletRequest request, @PathVariable Long userId) {
        IRequest iRequest = this.createRequestContext(request);
        ResponseData rd = new ResponseData();
        User user = new User();
        user.setUserId(userId);
        rd.setRows(this.roleService.selectRolesByUser(iRequest, user));
        return rd;
    }

    @RequestMapping(value={"/password/reset"}, method={RequestMethod.POST})
    public ResponseData updatePassword(HttpServletRequest request, String password, String passwordAgain, Long userId) throws UserException {
        IRequest iRequest = this.createRequestContext(request);
        this.userService.validatePassword(iRequest, password, passwordAgain);
        this.userService.updatePassword(userId, password);
        this.userService.updateNotFirstLogin(userId, "Y");
        return new ResponseData(true);
    }

    @RequestMapping(value={"/password/update"}, method={RequestMethod.POST})
    public ResponseData updatePassword(HttpServletRequest request, String oldPwd, String newPwd, String newPwdAgain) throws UserException {
        IRequest iRequest = this.createRequestContext(request);
        Long accountId = iRequest.getUserId();
        HttpSession session = request.getSession(false);
        Object expire = session.getAttribute("PASSWORD_UPDATE_REASON");
        iRequest.setAttribute("PASSWORD_UPDATE_REASON", expire);
        this.userService.validatePassword(iRequest, newPwd, newPwdAgain);
        if (StringUtils.isEmpty((String)oldPwd)) {
            throw new UserException("error.user.password_not_empty", null);
        }
        User tmp = new User();
        tmp.setUserId(accountId);
        User userInDB = this.userService.selectByPrimaryKey(iRequest, tmp);
        String pwd = userInDB.getPasswordEncrypted();
        if (!this.passwordManager.matches(oldPwd, pwd)) {
            throw new UserException("error.password.current_password", null);
        }
        if (this.passwordManager.matches(newPwd, pwd)) {
            throw new UserException("error.system.not_allowed_same_with_old_password", null);
        }
        this.userService.updatePassword(accountId, newPwd);
        if (expire != null) {
            session.removeAttribute("PASSWORD_UPDATE_REASON");
            this.userService.updateNotFirstLogin(accountId, "N");
        }
        return new ResponseData(true);
    }
}

