/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.zhongDengWang.service.impl;

import com.hand.app.zhongDengWang.dto.FndAtmAttachmentDto;
import com.hand.app.zhongDengWang.dto.FndZhongDengBatch;
import com.hand.app.zhongDengWang.dto.FndZhongDengHeads;
import com.hand.app.zhongDengWang.dto.FndZhongDengLines;
import com.hand.app.zhongDengWang.dto.HlsWsRequests;
import com.hand.app.zhongDengWang.dto.ZdwLoginTokenInterface;
import com.hand.app.zhongDengWang.mapper.FndAtmAttachmentMapper;
import com.hand.app.zhongDengWang.mapper.FndZhongDengBatchMapper;
import com.hand.app.zhongDengWang.mapper.FndZhongDengHeadsMapper;
import com.hand.app.zhongDengWang.mapper.FndZhongDengLinesMapper;
import com.hand.app.zhongDengWang.mapper.HlsWsRequestsMapper;
import com.hand.app.zhongDengWang.mapper.ZdwLoginTokenInterfaceMapper;
import com.hand.app.zhongDengWang.service.IFndZhongDengHeadsService;
import com.hand.app.zhongDengWang.service.IFndZhongDengLinesService;
import com.hand.app.zhongDengWang.service.IZdwWsRequestsService;
import com.hand.app.zhongDengWang.utils.ClientUtils;
import com.hand.app.zhongDengWang.ws.amend.WSAmendRegisterService;
import com.hand.app.zhongDengWang.ws.amend.WSAmendRegisterServiceService;
import com.hand.app.zhongDengWang.ws.extend.WSExtendRegisterService;
import com.hand.app.zhongDengWang.ws.extend.WSExtendRegisterServiceService;
import com.hand.app.zhongDengWang.ws.init.WSInitRegisterService;
import com.hand.app.zhongDengWang.ws.init.WSInitRegisterServiceService;
import com.hand.app.zhongDengWang.ws.login.WSLoginService;
import com.hand.app.zhongDengWang.ws.login.WSLoginServiceService;
import com.hand.app.zhongDengWang.ws.terminate.WSTerminateRegisterService;
import com.hand.app.zhongDengWang.ws.terminate.WSTerminateRegisterServiceService;
import com.hand.hap.core.IRequest;
import com.hand.hap.lock.components.DatabaseLockProvider;
import com.rfp.sm.utils.SM2Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONObject;
import org.json.XML;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ZdwWsRequestsServiceImpl
implements IZdwWsRequestsService {
    @Autowired
    ZdwLoginTokenInterfaceMapper zdwLoginTokenInterfaceMapper;
    @Autowired
    FndZhongDengHeadsMapper fndZhongDengHeadsMapper;
    @Autowired
    FndZhongDengLinesMapper fndZhongDengLinesMapper;
    @Autowired
    IFndZhongDengHeadsService fndZhongDengHeadsService;
    @Autowired
    IFndZhongDengLinesService fndZhongDengLinesService;
    @Autowired
    IZdwWsRequestsService zdwWsRequestsService;
    @Autowired
    HlsWsRequestsMapper hlsWsRequestsMapper;
    @Autowired
    FndAtmAttachmentMapper fndAtmAttachmentMapper;
    @Autowired
    FndZhongDengBatchMapper fndZhongDengBatchMapper;
    @Autowired
    private DatabaseLockProvider databaseLockProvider;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Object lock = new Object();
    @Value(value="${zdw.login.clientKey}")
    private String clientKey;
    @Value(value="${zdw.login.userName}")
    private String userName;
    @Value(value="${zdw.login.password}")
    private String userPassword;
    @Value(value="${zdw.login.authCode}")
    private String platformAuthCode;
    private String loginToken;

    public String clintLogin(String clientKey, String userName, String userPassword, String platformAuthCode) {
        String returnMsg = "";
        String encryUserName = "";
        String encryUserPassword = "";
        String encryPlatformAuthCode = "";
        try {
            encryUserName = SM2Utils.encryptByKeyStr((String)userName, (String)clientKey);
            encryUserPassword = SM2Utils.encryptByKeyStr((String)userPassword, (String)clientKey);
            encryPlatformAuthCode = SM2Utils.encryptByKeyStr((String)platformAuthCode, (String)clientKey);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        WSLoginServiceService service = new WSLoginServiceService();
        WSLoginService login = service.getWSLoginServicePort();
        HlsWsRequests hlsWsRequests = new HlsWsRequests();
        hlsWsRequests = this.createRequestLog(service.getWSDLDocumentLocation().toString(), "userName:" + userName + ";userPassword:" + userPassword + ";platformAuthCode:" + platformAuthCode, null);
        try {
            byte[] returns = login.login(encryUserName.getBytes(), encryUserPassword.getBytes(), encryPlatformAuthCode.getBytes());
            returnMsg = new String(returns, "UTF-8");
            this.logger.info("get token success token: {}", (Object)returnMsg);
        }
        catch (Exception e) {
            e.printStackTrace();
            returnMsg = "LoginError";
            this.logger.info("get token fail message: {}", (Object)e.getMessage());
        }
        this.hlsWsRequestsMapper.updateByPrimaryKeySelective(hlsWsRequests);
        return returnMsg;
    }

    private String getRegisterToken() {
        ZdwLoginTokenInterface zdwLoginTokenInterface = new ZdwLoginTokenInterface();
        zdwLoginTokenInterface.setEnableFlag("Y");
        zdwLoginTokenInterface = this.zdwLoginTokenInterfaceMapper.selectOne(zdwLoginTokenInterface);
        String assesstoken = "";
        if (Objects.isNull(zdwLoginTokenInterface)) {
            assesstoken = this.clintLogin(this.clientKey, this.userName, this.userPassword, this.platformAuthCode);
            if (!assesstoken.contains("Error")) {
                this.zdwLoginTokenInterfaceMapper.updateToken(assesstoken);
            }
        } else {
            assesstoken = zdwLoginTokenInterface.getToken();
        }
        return assesstoken;
    }

    private HlsWsRequests createRequestLog(String wsdlUrl, String requestClob, Long pkValue) {
        HlsWsRequests hlsWsRequests = new HlsWsRequests();
        hlsWsRequests.setRequestDate(new Date());
        hlsWsRequests.setRequestWsdlUrl(wsdlUrl);
        hlsWsRequests.setFunctionName("INIT_REGISTER");
        hlsWsRequests.setRequestClob(requestClob);
        hlsWsRequests.setStatusDate(new Date());
        hlsWsRequests.setParameterType("XML");
        hlsWsRequests.setPkValue(pkValue);
        this.hlsWsRequestsMapper.insertSelective(hlsWsRequests);
        return hlsWsRequests;
    }

    public void setErrData(com.alibaba.fastjson.JSONObject resultJson, HlsWsRequests hlsWsRequests, Exception e) {
        resultJson.put("code", (Object)"-1");
        resultJson.put("info", (Object)("\u8bf7\u6c42\u5931\u8d25\uff1a" + e.getMessage()));
        hlsWsRequests.setReturnStatus("E");
        hlsWsRequests.setResponsedDate(new Date());
    }

    public void setResData(com.alibaba.fastjson.JSONObject resultJson, HlsWsRequests hlsWsRequests, String resData) {
        resultJson.put("code", (Object)"0");
        resultJson.put("info", (Object)resData);
        hlsWsRequests.setReturnStatus("S");
        hlsWsRequests.setResponseClob(resData);
        hlsWsRequests.setResponsedDate(new Date());
    }

    public com.alibaba.fastjson.JSONObject registerInit(String platformAuthCode, String loginToken, String xmlFileContent, FndZhongDengLines line, FndAtmAttachmentDto attachmentDto) {
        com.alibaba.fastjson.JSONObject resultJson = new com.alibaba.fastjson.JSONObject();
        WSInitRegisterServiceService service = new WSInitRegisterServiceService();
        WSInitRegisterService reg = service.getWSInitRegisterServicePort();
        HlsWsRequests hlsWsRequests = new HlsWsRequests();
        hlsWsRequests = this.createRequestLog(service.getWSDLDocumentLocation().toString(), xmlFileContent, line.getLineId());
        try {
            String encryXmlFileContent = SM2Utils.encryptByKeyStr((String)xmlFileContent, (String)this.clientKey);
            String encryLoginToken = SM2Utils.encryptByKeyStr((String)loginToken, (String)this.clientKey);
            String attachmentZipPath = "";
            String encryPlatformAuthCode = SM2Utils.encryptByKeyStr((String)platformAuthCode, (String)this.clientKey);
            byte[] returns = reg.initRegister(line.getTypebz().getBytes(), encryPlatformAuthCode.getBytes(), encryLoginToken.getBytes(), attachmentDto.getFileName().getBytes(), encryXmlFileContent.getBytes(), ClientUtils.getAttachmentZip(attachmentZipPath));
            String resData = new String(returns, "UTF-8");
            this.setResData(resultJson, hlsWsRequests, resData);
            this.logger.info("register init success line_id:{}, returns: {}", (Object)line.getLineId(), (Object)resData);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setErrData(resultJson, hlsWsRequests, e);
            this.logger.info("register init fail line_id:{},message: {}", (Object)line.getLineId(), (Object)e.getMessage());
        }
        this.hlsWsRequestsMapper.updateByPrimaryKeySelective(hlsWsRequests);
        return resultJson;
    }

    public com.alibaba.fastjson.JSONObject registerAmend(String platformAuthCode, String loginToken, String xmlFileContent, FndZhongDengHeads heads, FndZhongDengLines line, FndAtmAttachmentDto attachmentDto) {
        com.alibaba.fastjson.JSONObject resultJson = new com.alibaba.fastjson.JSONObject();
        WSAmendRegisterServiceService service = new WSAmendRegisterServiceService();
        WSAmendRegisterService amend = service.getWSAmendRegisterServicePort();
        HlsWsRequests hlsWsRequests = new HlsWsRequests();
        hlsWsRequests = this.createRequestLog(service.getWSDLDocumentLocation().toString(), xmlFileContent, line.getLineId());
        try {
            String encryLoginToken = SM2Utils.encryptByKeyStr((String)loginToken, (String)this.clientKey);
            String encryXmlFileContent = SM2Utils.encryptByKeyStr((String)xmlFileContent, (String)this.clientKey);
            String encryPlatformAuthCode = SM2Utils.encryptByKeyStr((String)platformAuthCode, (String)this.clientKey);
            String encryAuthorizationCode = SM2Utils.encryptByKeyStr((String)heads.getAuthorizationCode(), (String)this.clientKey);
            String encryRegisterCode = SM2Utils.encryptByKeyStr((String)heads.getInitRegisterNumber(), (String)this.clientKey);
            String attachmentZipPath = "";
            byte[] returns = amend.amendRegister(line.getTypebz().getBytes(), encryPlatformAuthCode.getBytes(), encryLoginToken.getBytes(), encryRegisterCode.getBytes(), encryAuthorizationCode.getBytes(), attachmentDto.getFileName().getBytes(), encryXmlFileContent.getBytes(), ClientUtils.getAttachmentZip(attachmentZipPath));
            String resData = new String(returns, "UTF-8");
            this.setResData(resultJson, hlsWsRequests, resData);
            this.logger.info("register amend success line_id:{},returns: {}", (Object)line.getLineId(), (Object)resData);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setErrData(resultJson, hlsWsRequests, e);
            this.logger.info("register amend fail line_id:{},message: {}", (Object)line.getLineId(), (Object)e.getMessage());
        }
        this.hlsWsRequestsMapper.updateByPrimaryKeySelective(hlsWsRequests);
        return resultJson;
    }

    public com.alibaba.fastjson.JSONObject registerExtend(String platformAuthCode, String loginToken, String xmlFileContent, FndZhongDengHeads heads, FndZhongDengLines line, FndAtmAttachmentDto attachmentDto) {
        com.alibaba.fastjson.JSONObject resultJson = new com.alibaba.fastjson.JSONObject();
        WSExtendRegisterServiceService service = new WSExtendRegisterServiceService();
        WSExtendRegisterService extend = service.getWSExtendRegisterServicePort();
        HlsWsRequests hlsWsRequests = new HlsWsRequests();
        hlsWsRequests = this.createRequestLog(service.getWSDLDocumentLocation().toString(), xmlFileContent, line.getLineId());
        try {
            String encryLoginToken = SM2Utils.encryptByKeyStr((String)loginToken, (String)this.clientKey);
            String encryXmlFileContent = SM2Utils.encryptByKeyStr((String)xmlFileContent, (String)this.clientKey);
            String encryPlatformAuthCode = SM2Utils.encryptByKeyStr((String)platformAuthCode, (String)this.clientKey);
            String encryAuthorizationCode = SM2Utils.encryptByKeyStr((String)heads.getAuthorizationCode(), (String)this.clientKey);
            String encryRegisterCode = SM2Utils.encryptByKeyStr((String)heads.getInitRegisterNumber(), (String)this.clientKey);
            String attachmentZipPath = "";
            byte[] returns = extend.extendRegister(line.getTypebz().getBytes(), encryPlatformAuthCode.getBytes(), encryLoginToken.getBytes(), encryRegisterCode.getBytes(), encryAuthorizationCode.getBytes(), attachmentDto.getFileName().getBytes(), encryXmlFileContent.getBytes(), ClientUtils.getAttachmentZip(attachmentZipPath));
            String resData = new String(returns, "UTF-8");
            this.setResData(resultJson, hlsWsRequests, resData);
            this.logger.info("register extend success line_id:{},returns: {}", (Object)line.getLineId(), (Object)resData);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setErrData(resultJson, hlsWsRequests, e);
            this.logger.info("register extend fail line_id:{},message: {}", (Object)line.getLineId(), (Object)e.getMessage());
        }
        this.hlsWsRequestsMapper.updateByPrimaryKeySelective(hlsWsRequests);
        return resultJson;
    }

    public com.alibaba.fastjson.JSONObject registerTerminate(String platformAuthCode, String loginToken, String xmlFileContent, FndZhongDengHeads heads, FndZhongDengLines line, FndAtmAttachmentDto attachmentDto) {
        com.alibaba.fastjson.JSONObject resultJson = new com.alibaba.fastjson.JSONObject();
        WSTerminateRegisterServiceService service = new WSTerminateRegisterServiceService();
        WSTerminateRegisterService terminate = service.getWSTerminateRegisterServicePort();
        HlsWsRequests hlsWsRequests = new HlsWsRequests();
        hlsWsRequests = this.createRequestLog(service.getWSDLDocumentLocation().toString(), xmlFileContent, line.getLineId());
        try {
            String encryLoginToken = SM2Utils.encryptByKeyStr((String)loginToken, (String)this.clientKey);
            String encryXmlFileContent = SM2Utils.encryptByKeyStr((String)xmlFileContent, (String)this.clientKey);
            String encryPlatformAuthCode = SM2Utils.encryptByKeyStr((String)platformAuthCode, (String)this.clientKey);
            String encryAuthorizationCode = SM2Utils.encryptByKeyStr((String)heads.getAuthorizationCode(), (String)this.clientKey);
            String encryRegisterCode = SM2Utils.encryptByKeyStr((String)heads.getInitRegisterNumber(), (String)this.clientKey);
            byte[] returns = terminate.terminateRegister(line.getTypebz().getBytes(), encryPlatformAuthCode.getBytes(), encryLoginToken.getBytes(), encryRegisterCode.getBytes(), encryAuthorizationCode.getBytes(), attachmentDto.getFileName().getBytes(), encryXmlFileContent.getBytes());
            String resData = new String(returns, "UTF-8");
            this.setResData(resultJson, hlsWsRequests, resData);
            this.logger.info("register terminate success line_id:{},returns: {}", (Object)line.getLineId(), (Object)resData);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setErrData(resultJson, hlsWsRequests, e);
            this.logger.info("register terminate fail line_id:{},message: {}", (Object)line.getLineId(), (Object)e.getMessage());
        }
        this.hlsWsRequestsMapper.updateByPrimaryKeySelective(hlsWsRequests);
        return resultJson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerThread(IRequest request, List<FndZhongDengBatch> fndZhongDengBatches, String loginToken) {
        com.alibaba.fastjson.JSONObject resultJson = new com.alibaba.fastjson.JSONObject();
        ArrayList<FndZhongDengLines> fndZhongDengLinesList = new ArrayList<FndZhongDengLines>();
        ArrayList<FndZhongDengHeads> fndZhongDengHeadsList = new ArrayList<FndZhongDengHeads>();
        Object object = this.lock;
        synchronized (object) {
            for (FndZhongDengBatch batch : fndZhongDengBatches) {
                FndZhongDengLines fndZhongDengLines = new FndZhongDengLines();
                fndZhongDengLines.setLineId(batch.getLineId());
                if (!Objects.nonNull(fndZhongDengLines = (FndZhongDengLines)this.fndZhongDengLinesMapper.selectByPrimaryKey(fndZhongDengLines)) || !"UPING".equalsIgnoreCase(fndZhongDengLines.getUpStatus()) || !"NORMAL".equalsIgnoreCase(fndZhongDengLines.getDataClass())) continue;
                try {
                    FndZhongDengHeads fndZhongDengHeads = new FndZhongDengHeads();
                    fndZhongDengHeads.setHeadId(fndZhongDengLines.getHeadId());
                    fndZhongDengHeads = (FndZhongDengHeads)this.fndZhongDengHeadsMapper.selectByPrimaryKey(fndZhongDengHeads);
                    FndAtmAttachmentDto fndAtmAttachmentDto = new FndAtmAttachmentDto();
                    fndAtmAttachmentDto.setAttachmentId(fndZhongDengLines.getAttachmentXmlId());
                    fndAtmAttachmentDto = (FndAtmAttachmentDto)this.fndAtmAttachmentMapper.selectByPrimaryKey(fndAtmAttachmentDto);
                    String xmlFileContent = new String(Objects.requireNonNull(ClientUtils.getxmlFileContent(fndAtmAttachmentDto.getFilePath())), "UTF-8");
                    if ("01".equalsIgnoreCase(fndZhongDengLines.getUpStage())) {
                        resultJson = this.registerInit(this.platformAuthCode, loginToken, xmlFileContent, fndZhongDengLines, fndAtmAttachmentDto);
                    } else if ("02".equalsIgnoreCase(fndZhongDengLines.getUpStage())) {
                        resultJson = this.registerAmend(this.platformAuthCode, loginToken, xmlFileContent, fndZhongDengHeads, fndZhongDengLines, fndAtmAttachmentDto);
                    } else if ("03".equalsIgnoreCase(fndZhongDengLines.getUpStage())) {
                        resultJson = this.registerExtend(this.platformAuthCode, loginToken, xmlFileContent, fndZhongDengHeads, fndZhongDengLines, fndAtmAttachmentDto);
                    } else if ("05".equalsIgnoreCase(fndZhongDengLines.getUpStage())) {
                        resultJson = this.registerTerminate(this.platformAuthCode, loginToken, xmlFileContent, fndZhongDengHeads, fndZhongDengLines, fndAtmAttachmentDto);
                    }
                    String returns = "";
                    returns = "0".equalsIgnoreCase(resultJson.getString("code")) ? resultJson.getString("info") : "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<feedback>\n\t<registertype>" + fndZhongDengLines.getUpStage() + "</registertype>\n\t<registerresult>002</registerresult>\n\t<errors>\n\t\t<error>" + resultJson.getString("info") + "</error>\n\t</errors>\n</feedback>";
                    JSONObject returnJson = XML.toJSONObject((String)returns);
                    String registerResult = returnJson.getJSONObject("feedback").getString("registerresult");
                    if (Objects.nonNull(registerResult) && "001".equalsIgnoreCase(registerResult)) {
                        if (!returnJson.getJSONObject("feedback").isNull("registernumber")) {
                            String registerNumber = returnJson.getJSONObject("feedback").getString("registernumber");
                            fndZhongDengLines.setRegisterNumber(registerNumber);
                            if ("01".equalsIgnoreCase(fndZhongDengLines.getUpStage())) {
                                fndZhongDengHeads.setInitRegisterNumber(registerNumber);
                            } else if ("02".equalsIgnoreCase(fndZhongDengLines.getUpStage())) {
                                fndZhongDengHeads.setAmendRegisterNumber(registerNumber);
                            } else if ("03".equalsIgnoreCase(fndZhongDengLines.getUpStage())) {
                                fndZhongDengHeads.setExtendRegisterNumber(registerNumber);
                            } else if ("05".equalsIgnoreCase(fndZhongDengLines.getUpStage())) {
                                fndZhongDengHeads.setAbolishRegisterNumber(registerNumber);
                            }
                        }
                        if (!returnJson.getJSONObject("feedback").isNull("authorizationcode")) {
                            String authorizationCode = returnJson.getJSONObject("feedback").getString("authorizationcode");
                            fndZhongDengLines.setAuthorizationCode(authorizationCode);
                            fndZhongDengHeads.setAuthorizationCode(authorizationCode);
                        }
                        fndZhongDengHeads.set__status("update");
                        fndZhongDengHeadsList.add(fndZhongDengHeads);
                        fndZhongDengLines.setUpStatus("SUCCESS");
                        fndZhongDengLines.setReturnMsg("\u4e0a\u62a5\u6210\u529f");
                    } else {
                        String error = returnJson.getJSONObject("feedback").getJSONObject("errors").toString();
                        fndZhongDengLines.setUpStatus("FAIL");
                        fndZhongDengLines.setReturnMsg(error);
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    fndZhongDengLines.setUpStatus("FAIL");
                    fndZhongDengLines.setReturnMsg(e.getMessage());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    fndZhongDengLines.setUpStatus("FAIL");
                    fndZhongDengLines.setReturnMsg(e.getMessage());
                }
                fndZhongDengLines.setUpDate(new Date());
                fndZhongDengLines.set__status("update");
                fndZhongDengLinesList.add(fndZhongDengLines);
            }
            if (fndZhongDengHeadsList.size() > 0) {
                this.fndZhongDengHeadsService.batchUpdate(request, fndZhongDengHeadsList);
            }
            if (fndZhongDengLinesList.size() > 0) {
                this.fndZhongDengLinesService.batchUpdate(request, fndZhongDengLinesList);
            }
        }
    }

    @Override
    public com.alibaba.fastjson.JSONObject initRegisterService(final IRequest request, com.alibaba.fastjson.JSONObject params) {
        com.alibaba.fastjson.JSONObject resultJson = new com.alibaba.fastjson.JSONObject();
        Long batchId = params.getLongValue("batchId");
        if (Objects.isNull(batchId)) {
            resultJson.put("code", (Object)"001");
            resultJson.put("info", (Object)"\u5fc5\u987b\u4f20\u5165\u53c2\u6570batchId\u7f3a\u5931\uff0c\u8bf7\u68c0\u67e5");
            return resultJson;
        }
        List<Object> fndZhongDengBatches = new ArrayList();
        FndZhongDengBatch fndZhongDengBatch = new FndZhongDengBatch();
        fndZhongDengBatch.setBatchId(batchId);
        fndZhongDengBatches = this.fndZhongDengBatchMapper.select(fndZhongDengBatch);
        if (fndZhongDengBatches.size() == 0) {
            resultJson.put("code", (Object)"000");
            resultJson.put("info", (Object)"000");
            return resultJson;
        }
        this.loginToken = this.getRegisterToken();
        if (this.loginToken.contains("Error")) {
            String errorCode = "-1";
            String errorInfo = "-1";
            if (errorCode.contains(":") && (errorCode = this.loginToken.split(":")[1]).contains("_")) {
                errorCode = this.loginToken.split("_")[0];
                errorInfo = this.loginToken.split("_")[1];
            }
            resultJson.put("code", (Object)errorCode);
            resultJson.put("info", (Object)errorInfo);
        } else {
            final List<Object> fndZhongDengBatchList = fndZhongDengBatches;
            ExecutorService cachedThreadPool = Executors.newCachedThreadPool();
            cachedThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ZdwWsRequestsServiceImpl.this.registerThread(request, fndZhongDengBatchList, ZdwWsRequestsServiceImpl.this.loginToken);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            cachedThreadPool.shutdown();
            resultJson.put("code", (Object)"000");
            resultJson.put("info", (Object)"000");
        }
        return resultJson;
    }
}

