/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.hms.controllers;

import com.alibaba.fastjson.JSONObject;
import com.codahale.metrics.annotation.Timed;
import com.hand.hap.intergration.beans.HapInvokeInfo;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.exception.HapApiException;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import com.hand.hap.system.controllers.BaseController;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/r/api"})
public class RiskstormController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(RiskstormController.class);
    @Autowired
    IHapInterfaceHeaderService headerService;

    @RequestMapping(value={"/app/riskQuery"})
    @ResponseBody
    @Timed
    public JSONObject getRisk(HttpServletRequest request, @RequestBody(required=false) JSONObject params) throws HapApiException, IOException {
        String sysName = request.getParameter("sysName");
        String apiName = request.getParameter("apiName");
        HapInterfaceHeader hapInterfaceHeader = this.headerService.getHeaderAndLine(sysName, apiName);
        this.logger.info("return hapInterfaceHeader:{}", (Object)hapInterfaceHeader);
        String url = hapInterfaceHeader.getDomainUrl() + hapInterfaceHeader.getIftUrl();
        String data = this.get(url, hapInterfaceHeader, params);
        return JSONObject.parseObject((String)data.toString().replaceAll("null", "\"\""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String get(String url, HapInterfaceHeader headerAndLineDTO, JSONObject params) {
        String resultData = "";
        if (url.indexOf("{companyOrg}") != -1) {
            url = url.replace("{companyOrg}", params.getString("companyOrg"));
        }
        if (params != null && params.size() > 0) {
            url = url + "?";
            for (Map.Entry entry : params.entrySet()) {
                String key = (String)entry.getKey();
                if (key == "companyOrg") continue;
                url = url + key + "=" + entry.getValue() + "&";
            }
            url = url.substring(0, url.length() - 1);
        }
        this.logger.info("request url:{}", (Object)url);
        HttpURLConnection httpURLConnection1 = null;
        try {
            String line;
            URL e1 = new URL(url);
            httpURLConnection1 = (HttpURLConnection)e1.openConnection();
            httpURLConnection1.setRequestMethod("GET");
            if (headerAndLineDTO.getRequestAccept() != null) {
                httpURLConnection1.setRequestProperty("Accept", headerAndLineDTO.getRequestAccept());
            }
            httpURLConnection1.connect();
            HapInvokeInfo.HTTP_RESPONSE_CODE.set(httpURLConnection1.getResponseCode());
            int responseCode1 = httpURLConnection1.getResponseCode();
            if (responseCode1 != 200) {
                throw new RuntimeException("HTTP GET Request Failed with Error code : " + httpURLConnection1.getResponseCode());
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(httpURLConnection1.getInputStream(), "utf-8"));
            StringBuilder results = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                results.append(line);
            }
            reader.close();
            resultData = results.toString();
            httpURLConnection1.disconnect();
        }
        catch (MalformedURLException var14) {
            var14.printStackTrace();
            this.logger.error(var14.getMessage());
        }
        catch (IOException var15) {
            var15.printStackTrace();
            this.logger.error(var15.getMessage());
        }
        finally {
            if (httpURLConnection1 != null) {
                httpURLConnection1.disconnect();
            }
        }
        this.logger.info("responseData:{}", (Object)resultData);
        return resultData;
    }
}

