/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.hms.controllers;

import com.alibaba.fastjson.JSONObject;
import com.codahale.metrics.annotation.Timed;
import com.github.pagehelper.StringUtil;
import com.hand.app.hms.service.IHanvonService;
import com.hand.app.hms.service.impl.PureNetUtilImpl;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.exception.HapApiException;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.service.ISysConfigService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/r/api"})
public class HanvonApiController
extends BaseController {
    private final Logger logger = LoggerFactory.getLogger(HanvonApiController.class);
    @Autowired
    IHapInterfaceHeaderService headerService;
    @Autowired
    ISysConfigService sysConfigService;
    @Autowired
    IHanvonService hanvonService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/app/hanvon"}, method={RequestMethod.POST})
    @ResponseBody
    @Timed
    public JSONObject sentRequest(HttpServletRequest request) throws HapApiException, IOException {
        String sysName = request.getParameter("sysName");
        String apiName = request.getParameter("apiName");
        String idCardPath = request.getParameter("cardPath");
        HapInterfaceHeader hapInterfaceHeader = this.headerService.getHeaderAndLine(sysName, apiName);
        this.logger.info("return hapInterfaceHeader:{}", (Object)hapInterfaceHeader);
        String iftUrl = hapInterfaceHeader.getIftUrl();
        String hanvonKey = this.sysConfigService.getConfigValue("HANVON.KEY");
        String newUrl = iftUrl.replace("YOURKEY", hanvonKey);
        if (hapInterfaceHeader == null) {
            throw new HapApiException("error.request.url.not.found", "\u6839\u636esysName\u548capiName\u6ca1\u6709\u627e\u5230\u6570\u636e");
        }
        if (!hapInterfaceHeader.getRequestFormat().equals("raw")) {
            throw new HapApiException("error.requestFormat.not.support", "\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u5f62\u5f0f");
        }
        JSONObject json = new JSONObject();
        OutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            MultipartHttpServletRequest req;
            Map fileMap;
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
            if (!isMultipart) {
                json.put("error", (Object)"\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
            }
            if (request instanceof MultipartHttpServletRequest && (fileMap = (req = (MultipartHttpServletRequest)request).getFileMap()) != null) {
                for (Map.Entry next : fileMap.entrySet()) {
                    String fileKey = (String)next.getKey();
                    MultipartFile filePart = (MultipartFile)next.getValue();
                    Long size = filePart.getSize();
                    inputStream = filePart.getInputStream();
                    String fileName = UUID.randomUUID().toString().replace("-", "").toUpperCase();
                    String tomcatPath = this.sysConfigService.getConfigValue("HANVON.PICTURE.PATH");
                    File file = new File(tomcatPath);
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    tomcatPath = tomcatPath + File.separator + fileName;
                    outputStream = new FileOutputStream(tomcatPath);
                    int len = -1;
                    byte[] bytes = new byte[1024];
                    while ((len = inputStream.read(bytes)) != -1) {
                        outputStream.write(bytes, 0, len);
                    }
                    outputStream.flush();
                    outputStream.close();
                    inputStream.close();
                    String imageStr = PureNetUtilImpl.GetBase64(tomcatPath);
                    String uid = InetAddress.getLocalHost().getHostAddress();
                    String inboundParam = "";
                    if (StringUtil.isNotEmpty(idCardPath)) {
                        String idcardImage = PureNetUtilImpl.GetBase64(idCardPath);
                        inboundParam = "{\"uid\":\"" + uid + "\" ,\"idcardImage\":\"" + idcardImage + "\",\"faceImage\":\"" + imageStr + "\"}";
                    } else {
                        inboundParam = "{\"uid\":\"" + uid + "\" ,\"image\":\"" + imageStr + "\"}";
                    }
                    String url = hapInterfaceHeader.getDomainUrl() + newUrl;
                    json = this.hanvonService.post(inboundParam, url);
                    json.put("file_path", (Object)tomcatPath);
                }
            }
        }
        catch (Exception e) {
            this.logger.info(e.toString());
            json.put("error", (Object)e.getMessage());
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return json;
    }
}

