/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.faceCard.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import hls.support.core.wechat.utils.WechatHttpUtils;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    public static final int CODE_REQUEST_FAILED = -1;
    private static Logger logger = LoggerFactory.getLogger(WechatHttpUtils.class);

    public static JSONObject postJson(String url, JSONObject params, String appCode) {
        JSONObject jsonObject = new JSONObject();
        HttpResponse execute = null;
        HttpClient httpClient = HttpUtil.wrapClient(url);
        try {
            HttpPost post = new HttpPost(url);
            post.setHeader("Authorization", "APPCODE " + appCode);
            post.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            if (params != null) {
                ArrayList<BasicNameValuePair> nameValuePairList = new ArrayList<BasicNameValuePair>();
                for (String key : params.keySet()) {
                    nameValuePairList.add(new BasicNameValuePair(key, params.get((Object)key).toString()));
                }
                UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(nameValuePairList, "utf-8");
                formEntity.setContentType("application/x-www-form-urlencoded; charset=UTF-8");
                post.setEntity((HttpEntity)formEntity);
            }
            execute = httpClient.execute((HttpUriRequest)post);
        }
        catch (IOException e) {
            jsonObject.put("code", (Object)-1);
            jsonObject.put("message", (Object)e.getMessage());
            logger.error("client execute failed: ", (Throwable)e);
        }
        if (execute != null) {
            HttpEntity entity = execute.getEntity();
            try {
                String s = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
                jsonObject = JSON.parseObject((String)s);
            }
            catch (IOException e) {
                logger.error("entity parse failed: ", (Throwable)e);
            }
        }
        return jsonObject;
    }

    private static HttpClient wrapClient(String url) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        if (url.startsWith("https://")) {
            HttpUtil.sslClient((HttpClient)httpClient);
        }
        return httpClient;
    }

    private static void sslClient(HttpClient httpClient) {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] xcs, String str) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] xcs, String str) {
                }
            };
            ctx.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory ssf = new SSLSocketFactory(ctx);
            ssf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            ClientConnectionManager ccm = httpClient.getConnectionManager();
            SchemeRegistry registry = ccm.getSchemeRegistry();
            registry.register(new Scheme("https", 443, (SchemeSocketFactory)ssf));
        }
        catch (KeyManagementException ex) {
            throw new RuntimeException(ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }
}

