/*
 * Decompiled with CFR 0.152.
 */
package com.hand.app.esignHclc.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.hand.app.esign.utils.AlgorithmHelper;
import com.hand.app.esignHclc.dto.SignFlowsInfoHclc;
import com.hand.app.esignHclc.dto.SignUserAttachInfo;
import com.hand.app.esignHclc.dto.SignUserFaceHclc;
import com.hand.app.esignHclc.dto.SignUserInfoHclc;
import com.hand.app.esignHclc.mapper.SignInfoHclcMapper;
import com.hand.app.esignHclc.service.ISignFlowsInfoHclcService;
import com.hand.app.esignHclc.service.ISignInfoHclcFaceService;
import com.hand.app.esignHclc.service.ISignInfoHclcService;
import com.hand.app.esignHclc.service.ISignUserAttachInfoService;
import com.hand.app.esignHclc.utils.SignHclcUtils;
import com.hand.hap.core.IRequest;
import com.hand.hap.intergration.dto.HapInterfaceHeader;
import com.hand.hap.intergration.service.IHapInterfaceHeaderService;
import com.hand.hap.intergration.utils.HttpUtil;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import hls.support.core.wechat.formbean.AttachmentInfo;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.CharsetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SignInfoHclcServiceImpl
extends BaseServiceImpl<SignUserInfoHclc>
implements ISignInfoHclcService {
    @Value(value="${tsign.project.id}")
    private String projectId;
    @Value(value="${tsign.project.secret}")
    private String projectSecret;
    @Value(value="${tsign.api.notifyUrl}")
    private String notifyUrl;
    @Value(value="${tsign.face.api.appId}")
    private String appId;
    @Value(value="${tsign.face.api.secret}")
    private String secret;
    @Value(value="${wx.apiKey}")
    private String apiKey;
    @Value(value="${wx.image.path}")
    private String imagePath;
    @Value(value="${tsign.api.listenSignUrl}")
    private String listenSignUrl;
    @Value(value="${tsign.api.signRedirectUrl}")
    private String signRedirectUrl;
    @Value(value="${tsign.face.api.url}")
    private String faceApiUrl;
    private CloseableHttpClient httpClient;
    public static final String RESULT_ERROR = "-1";
    public static final String indivSysName = "HCLC_FACE_API";
    public static final String tokenApiName = "getToken";
    public static final String indivApiName = "getIndivAuthUrl";
    public static final String getAccIdApiName = "getAccByThirdId";
    public static final String getLicenseApiName = "getLicenseInfo";
    public static final String wxSysName = "wxgzh_hitachics";
    public static final String wxDownLoadApiName = "media_download";
    public static final String wxSendTemplateApiName = "sendTemplate";
    public static final String hclcSysName = "HCL_UPLOAD_FILE";
    public static final String hclcUpLoadApiName = "upload";
    public static final String hclcDownloadApiName = "download";
    public static final String signSendApiName = "SignSendApiName";
    public static final String signFileDownApiName = "elecContractDownload";
    public static final String signatureSysName = "HCLC_ELECTRONIC_SIGNATURE";
    public static final String accountsApiName = "outerAccounts";
    public static final String deleteApiName = "accountsDelete";
    public static final String signatureUpLoadApiName = "fileUpload";
    public static final String signFlowsApiName = "signFlows";
    public static final String getSignUrlsApiName = "getSignFlowDocUrls";
    public static final String createSealsApiName = "createTemplateSeals";
    private static final String HASH_ALGORITHM = "HmacSHA256";
    private static final int HTTP_OK = 200;
    @Autowired
    IHapInterfaceHeaderService headerService;
    @Autowired
    private ISignInfoHclcFaceService signInfoHclcFaceService;
    @Autowired
    private SignInfoHclcMapper signInfoHclcMapper;
    @Autowired
    private ISignFlowsInfoHclcService iSignFlowsInfoHclcService;
    @Autowired
    private ISignUserAttachInfoService iSignUserAttachInfoService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Map<String, Object> getIndividualFaceUrl(IRequest iRequest, SignUserInfoHclc info) {
        Map<String, Object> map = new HashMap<String, Object>();
        if (Objects.isNull(info.getOpenId()) || "undefined".equalsIgnoreCase(info.getOpenId())) {
            this.logger.info("\u5173\u952e\u53c2\u6570openId\u4e0d\u5b58\u5728\uff0c\u8c03\u7528\u5931\u8d25!");
            map.put("code", "000001");
            map.put("message", "\u5173\u952e\u53c2\u6570openId\u4e0d\u5b58\u5728\uff0c\u8c03\u7528\u5931\u8d25!");
            return map;
        }
        SignUserInfoHclc signInfoHclc = (SignUserInfoHclc)this.mapper.selectByPrimaryKey(info);
        String accountStatus = null;
        if (Objects.isNull(signInfoHclc)) {
            info.setCtitype(1L);
            info.setAuthFlag("N");
            signInfoHclc = this.insertSelective(iRequest, info);
            accountStatus = "ADD";
        } else {
            signInfoHclc.setCtitype(1L);
            if ("Y".equalsIgnoreCase(signInfoHclc.getAuthFlag())) {
                map.put("code", "000002");
                map.put("message", "\u4eba\u8138\u6838\u8eab\u8ba4\u8bc1\u5df2\u5b8c\u6210\uff0c\u65e0\u9700\u91cd\u590d\u9a8c\u8bc1\uff01");
                return map;
            }
            if (!(info.getIdNo().equalsIgnoreCase(signInfoHclc.getIdNo()) && info.getName().equalsIgnoreCase(signInfoHclc.getName()) && info.getMobile().equalsIgnoreCase(signInfoHclc.getMobile()))) {
                accountStatus = Objects.isNull(signInfoHclc.getAccountId()) ? "ADD" : "MODIFY";
            } else {
                SignUserFaceHclc signInfoHclcFace = new SignUserFaceHclc();
                if (Objects.nonNull(signInfoHclc.getFaceAuthId())) {
                    signInfoHclcFace.setAuthId(signInfoHclc.getFaceAuthId());
                    signInfoHclcFace = this.signInfoHclcFaceService.selectByPrimaryKey(iRequest, signInfoHclcFace);
                    if ("SUCCESS".equalsIgnoreCase(signInfoHclcFace.getAuthStatus())) {
                        map.put("code", "000002");
                        map.put("message", "\u4eba\u8138\u6838\u8eab\u8ba4\u8bc1\u5df2\u5b8c\u6210\uff0c\u65e0\u9700\u91cd\u590d\u9a8c\u8bc1\uff01");
                        return map;
                    }
                    if (!"FAIL".equalsIgnoreCase(signInfoHclcFace.getAuthStatus())) {
                        map.put("code", "0");
                        map.put("url", signInfoHclcFace.getUrl());
                        map.put("message", "\u83b7\u53d6url\u6210\u529f\uff01");
                        return map;
                    }
                    accountStatus = "EXISTS";
                } else {
                    accountStatus = Objects.isNull(signInfoHclc.getAccountId()) ? "ADD" : "EXISTS";
                }
            }
        }
        if (!"EXISTS".equalsIgnoreCase(accountStatus)) {
            if ("MODIFY".equalsIgnoreCase(accountStatus) && ("0".equalsIgnoreCase((map = this.deletePersonAccount(iRequest, signInfoHclc)).get("code").toString()) || "40051667".equalsIgnoreCase(map.get("code").toString()))) {
                signInfoHclc.setAccountId("");
                signInfoHclc.setAuthAccountId("");
                signInfoHclc.setIdNo(info.getIdNo());
                signInfoHclc.setName(info.getName());
                signInfoHclc.setMobile(info.getMobile());
                signInfoHclc.setFaceAuthId(null);
            }
            if (map.size() == 0 || "0".equalsIgnoreCase(map.get("code").toString()) || "40051667".equalsIgnoreCase(map.get("code").toString())) {
                SignUserInfoHclc signInfo = new SignUserInfoHclc();
                signInfo.setOpenId(signInfoHclc.getOpenId());
                signInfo.setIdNo(info.getIdNo());
                signInfo.setMobile(info.getMobile());
                signInfo.setName(info.getName());
                map = this.addPersonAccount(signInfo);
                if ("0".equalsIgnoreCase(map.get("code").toString())) {
                    signInfoHclc.setAccountId(map.get("accountId").toString());
                    signInfoHclc.setSealId(map.get("sealId").toString());
                    if ("ADD".equalsIgnoreCase(accountStatus)) {
                        signInfoHclc.setIdNo(info.getIdNo());
                        signInfoHclc.setName(info.getName());
                        signInfoHclc.setMobile(info.getMobile());
                    }
                }
                signInfoHclc.setCreateCode(map.get("code").toString());
                signInfoHclc.setCreateMessage(map.get("message").toString());
            }
        }
        if (map.size() == 0 || "0".equalsIgnoreCase(map.get("code").toString())) {
            SignHclcUtils signHclcUtils = new SignHclcUtils();
            signInfoHclc = SignHclcUtils.initProject(signInfoHclc, this.appId, this.secret, this.notifyUrl);
            String tokenApiUrl = this.getApiUrl(indivSysName, tokenApiName);
            this.logger.info("token url: {}", (Object)tokenApiUrl);
            String token = signHclcUtils.getFaceApiToken(tokenApiUrl, signInfoHclc.getAppId(), signInfoHclc.getSecret());
            if (Objects.nonNull(token)) {
                signInfoHclc.setRedirectUrl(info.getRedirectUrl());
                map = this.getFaceUrlHttp(iRequest, signInfoHclc, token);
                if ("0".equalsIgnoreCase(map.get("code").toString())) {
                    signInfoHclc.setFaceAuthId(Long.valueOf(map.get("faceAuthId").toString()));
                }
            } else {
                map.put("code", "000007");
                map.put("message", "\u83b7\u53d6\u9274\u6743Token\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        this.updateByPrimaryKey(iRequest, signInfoHclc);
        return map;
    }

    @Override
    public String getApiUrl(String sysName, String apiName) {
        HapInterfaceHeader headerAndLineDTO = this.headerService.getHeaderAndLine(sysName, apiName);
        if (headerAndLineDTO == null) {
            this.logger.info("headerAndLineDTO is null\uff0c apiName:{}, sysName:{}", (Object)apiName, (Object)sysName);
            return null;
        }
        return headerAndLineDTO.getDomainUrl() + headerAndLineDTO.getIftUrl();
    }

    @Override
    public Map<String, Object> getFaceUrlHttp(IRequest iRequest, SignUserInfoHclc info, String token) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        SignUserFaceHclc signInfoHclcFace = new SignUserFaceHclc();
        signInfoHclcFace.setOpenId(info.getOpenId());
        signInfoHclcFace.setAuthStatus("NEW");
        signInfoHclcFace.setAuthType("1");
        signInfoHclcFace = this.signInfoHclcFaceService.insertSelective(iRequest, signInfoHclcFace);
        JSONObject json1 = new JSONObject();
        json1.put("contextId", (Object)signInfoHclcFace.getAuthId());
        json1.put("notifyUrl", (Object)info.getNotifyUrl());
        json1.put("redirectUrl", (Object)info.getRedirectUrl());
        JSONObject json2 = new JSONObject();
        json2.put("name", (Object)info.getName());
        json2.put("certType", (Object)"INDIVIDUAL_CH_IDCARD");
        json2.put("certNo", (Object)info.getIdNo());
        json2.put("mobileNo", (Object)info.getMobile());
        JSONObject json3 = new JSONObject();
        String[] str = new String[]{"name", "certNo", "mobileNo", "bankCardNo"};
        json3.put("indivUneditableInfo", (Object)str);
        JSONObject result = new JSONObject();
        result.put("authType", (Object)"PSN_FACEAUTH_BYURL");
        result.put("contextInfo", (Object)json1);
        result.put("indivInfo", (Object)json2);
        result.put("configParams", (Object)json3);
        JSONObject json = new JSONObject((Map)result);
        HashMap<String, String> headInfo = new HashMap<String, String>();
        headInfo.put("X-Tsign-Open-App-Id", info.getAppId());
        headInfo.put("X-Tsign-Open-Token", token);
        try {
            String faceApiurl = this.getApiUrl(indivSysName, indivApiName);
            this.logger.info("get face api url: {}", (Object)faceApiurl);
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.postString(faceApiurl, json, headInfo, "application/json");
            JSONObject jsonResult = JSONObject.parseObject((String)stringResult);
            if ("0".equalsIgnoreCase(jsonResult.getString("code"))) {
                JSONObject data = jsonResult.getJSONObject("data");
                signInfoHclcFace.setFlowId(data.getString("flowId") == null ? "" : data.getString("flowId"));
                signInfoHclcFace.setUrl(data.getString("url") == null ? "" : data.getString("url"));
                signInfoHclcFace.setShortLink(data.getString("shortLink") == null ? "" : data.getString("shortLink"));
                signInfoHclcFace.setAuthStatus("AUTHING");
                map.put("code", "0");
                map.put("faceAuthId", signInfoHclcFace.getAuthId());
                map.put("AuthType", "FACE");
                map.put("url", data.getString("url"));
                map.put("message", "\u83b7\u53d6url\u6210\u529f\uff01");
            } else {
                map.put("code", "000008");
                map.put("message", "\u83b7\u53d6\u4eba\u8138\u6838\u8eab\u8ba4\u8bc1url\u5931\u8d25\uff0c" + jsonResult.getString("message"));
            }
            signInfoHclcFace.setReturnCode(jsonResult.getString("code"));
            signInfoHclcFace.setReturnMessage(jsonResult.getString("message"));
        }
        catch (Exception e) {
            map.put("code", "000009");
            map.put("message", "\u8bbf\u95eee\u7b7e\u5b9d\u4eba\u8138\u6838\u8eab\u5730\u5740\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01");
            signInfoHclcFace.setReturnCode("000009");
            signInfoHclcFace.setReturnMessage(e.getMessage());
        }
        this.signInfoHclcFaceService.updateByPrimaryKey(iRequest, signInfoHclcFace);
        return map;
    }

    @Override
    public Map<String, Object> getByThirdId(SignUserInfoHclc info, String token) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        JSONObject headInfo = new JSONObject();
        headInfo.put("X-Tsign-Open-App-Id", (Object)info.getAppId());
        headInfo.put("X-Tsign-Open-Token", (Object)token);
        String param = "thirdPartyUserId=" + info.getAccountId();
        try {
            String accIdApiurl = this.getApiUrl(indivSysName, getAccIdApiName) + "?" + param;
            this.logger.info("get accountId api url: {}", (Object)accIdApiurl);
            HttpResponse execute = HttpUtil.getJson(accIdApiurl, headInfo);
            String stringResult = null;
            JSONObject responseBody = new JSONObject();
            if (execute != null) {
                int httpReponseCode = execute.getStatusLine().getStatusCode();
                if (httpReponseCode != 200) {
                    responseBody.put("code", (Object)httpReponseCode);
                    responseBody.put("message", (Object)execute.getStatusLine().getReasonPhrase());
                    stringResult = responseBody.toString();
                } else {
                    stringResult = HttpUtil.HttpResponseParseJson(execute);
                }
                JSONObject jsonResult = JSONObject.parseObject((String)stringResult);
                if ("0".equalsIgnoreCase(jsonResult.getString("code"))) {
                    JSONObject data = jsonResult.getJSONObject("data");
                    map.put("code", "0");
                    map.put("authAccountId", data.getString("accountId"));
                    map.put("message", "\u83b7\u53d6\u4e2a\u4eba\u4e91\u8d26\u6237\u6210\u529f\uff01");
                } else {
                    map.put("code", "000008");
                    map.put("message", "\u83b7\u53d6\u4e2a\u4eba\u4e91\u8d26\u6237\u5931\u8d25," + jsonResult.getString("message"));
                }
            } else {
                map.put("code", "000010");
                map.put("message", "\u83b7\u53d6\u4e2a\u4eba\u4e91\u8d26\u6237\u53d1\u9001\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4e2a\u4eba\u4e91\u5730\u5740\u4fe1\u606f\uff01");
            }
        }
        catch (Exception e) {
            map.put("code", "000009");
            map.put("message", e.getMessage());
        }
        return map;
    }

    public JSONObject idcard(IRequest iRequest, String img) {
        JSONObject resultjson = new JSONObject();
        JSONObject result = new JSONObject();
        result.put("img", (Object)img);
        JSONObject json = new JSONObject((Map)result);
        SignHclcUtils signHclcUtils = new SignHclcUtils();
        String tokenApiUrl = this.getApiUrl(indivSysName, tokenApiName);
        this.logger.info("token url: {}", (Object)tokenApiUrl);
        String token = signHclcUtils.getFaceApiToken(tokenApiUrl, this.appId, this.secret);
        HashMap<String, String> headInfo = new HashMap<String, String>();
        headInfo.put("X-Tsign-Open-App-Id", this.appId);
        headInfo.put("X-Tsign-Open-Token", token);
        JSONObject jsonResult = null;
        try {
            String url = this.faceApiUrl + "/v2/identity/auth/api/ocr/idcard";
            this.logger.info("get ocr result url: {}", (Object)url);
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.postString(url, json, headInfo, "application/json");
            jsonResult = JSONObject.parseObject((String)stringResult);
            if ("0".equalsIgnoreCase(jsonResult.getString("code"))) {
                JSONObject data = jsonResult.getJSONObject("data");
                resultjson.put("\u59d3\u540d", (Object)data.getString("name"));
                resultjson.put("\u6c11\u65cf", (Object)data.getString("nation"));
                resultjson.put("\u4f4f\u5740", (Object)data.getString("address"));
                resultjson.put("\u516c\u6c11\u8eab\u4efd\u53f7\u7801", (Object)data.getString("idNo"));
                resultjson.put("\u51fa\u751f", (Object)data.getString("birthDay"));
                resultjson.put("\u6027\u522b", (Object)data.getString("gender"));
                resultjson.put("code", (Object)"0");
                resultjson.put("message", (Object)"e\u7b7e\u5b9d\u8eab\u4efd\u8bc1OCR\u6210\u529f\uff01");
            } else {
                this.logger.info("get ocr result failed, code:{} ,message:{}", (Object)jsonResult.getString("code"), (Object)jsonResult.getString("message"));
                resultjson.put("code", (Object)jsonResult.getString("code"));
                resultjson.put("message", (Object)("e\u7b7e\u5b9d\u8eab\u4efd\u8bc1OCR\u5931\u8d25," + jsonResult.getString("message")));
            }
        }
        catch (Exception var15) {
            this.logger.info("get ocr result failed, msg:{}", (Object)var15.getMessage());
            resultjson.put("code", (Object)"000006");
            resultjson.put("message", (Object)("e\u7b7e\u5b9d\u8eab\u4efd\u8bc1OCR\u5931\u8d25\uff0c" + var15.getMessage()));
        }
        return resultjson;
    }

    public JSONObject bankcard(IRequest iRequest, String img) {
        JSONObject resultjson = new JSONObject();
        JSONObject result = new JSONObject();
        result.put("img", (Object)img);
        JSONObject json = new JSONObject((Map)result);
        SignHclcUtils signHclcUtils = new SignHclcUtils();
        String tokenApiUrl = this.getApiUrl(indivSysName, tokenApiName);
        this.logger.info("token url: {}", (Object)tokenApiUrl);
        String token = signHclcUtils.getFaceApiToken(tokenApiUrl, this.appId, this.secret);
        HashMap<String, String> headInfo = new HashMap<String, String>();
        headInfo.put("X-Tsign-Open-App-Id", this.appId);
        headInfo.put("X-Tsign-Open-Token", token);
        JSONObject jsonResult = null;
        try {
            String url = this.faceApiUrl + "/v2/identity/auth/api/ocr/bankcard";
            this.logger.info("get ocr result url: {}", (Object)url);
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.postString(url, json, headInfo, "application/json");
            jsonResult = JSONObject.parseObject((String)stringResult);
            if ("0".equalsIgnoreCase(jsonResult.getString("code"))) {
                JSONObject data = jsonResult.getJSONObject("data");
                resultjson.put("\u94f6\u884c\u5361\u53f7", (Object)data.getString("bankCardNo"));
                resultjson.put("\u94f6\u884c\u540d\u79f0", (Object)data.getString("bankName"));
                resultjson.put("code", (Object)"0");
                resultjson.put("message", (Object)"e\u7b7e\u5b9d\u94f6\u884c\u5361OCR\u6210\u529f\uff01");
            } else {
                this.logger.info("get ocr result failed, code:{} ,message:{}", (Object)jsonResult.getString("code"), (Object)jsonResult.getString("message"));
                resultjson.put("code", (Object)jsonResult.getString("code"));
                resultjson.put("message", (Object)("e\u7b7e\u5b9d\u94f6\u884c\u5361OCR\u5931\u8d25," + jsonResult.getString("message")));
            }
        }
        catch (Exception var15) {
            this.logger.info("get ocr result failed, msg:{}", (Object)var15.getMessage());
            resultjson.put("code", (Object)"000006");
            resultjson.put("message", (Object)("e\u7b7e\u5b9d\u94f6\u884c\u5361OCR\u5931\u8d25\uff0c" + var15.getMessage()));
        }
        return resultjson;
    }

    @Override
    public JSONObject ocrLicense(IRequest iRequest, String img) {
        JSONObject resultjson = new JSONObject();
        JSONObject result = new JSONObject();
        result.put("img", (Object)img);
        JSONObject json = new JSONObject((Map)result);
        SignHclcUtils signHclcUtils = new SignHclcUtils();
        String tokenApiUrl = this.getApiUrl(indivSysName, tokenApiName);
        this.logger.info("token url: {}", (Object)tokenApiUrl);
        String token = signHclcUtils.getFaceApiToken(tokenApiUrl, this.appId, this.secret);
        HashMap<String, String> headInfo = new HashMap<String, String>();
        headInfo.put("X-Tsign-Open-App-Id", this.appId);
        headInfo.put("X-Tsign-Open-Token", token);
        JSONObject jsonResult = null;
        try {
            String url = this.faceApiUrl + "/v2/identity/auth/api/ocr/license";
            this.logger.info("get ocr result url: {}", (Object)url);
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.postString(url, json, headInfo, "application/json");
            jsonResult = JSONObject.parseObject((String)stringResult);
            if ("0".equalsIgnoreCase(jsonResult.getString("code"))) {
                JSONObject data = jsonResult.getJSONObject("data");
                resultjson.put("\u6cd5\u4eba", (Object)data.getString("legalRepName"));
                resultjson.put("\u5355\u4f4d\u540d\u79f0", (Object)data.getString("name"));
                resultjson.put("\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801", (Object)data.getString("certNo"));
                resultjson.put("\u5730\u5740", (Object)data.getString("address"));
                resultjson.put("\u6709\u6548\u671f", (Object)data.getString("validTerm"));
                resultjson.put("code", (Object)"0");
                resultjson.put("message", (Object)"e\u7b7e\u5b9d\u8425\u4e1a\u6267\u7167OCR\u6210\u529f\uff01");
            } else {
                this.logger.info("get ocr result failed, code:{} ,message:{}", (Object)jsonResult.getString("code"), (Object)jsonResult.getString("message"));
                resultjson.put("code", (Object)jsonResult.getString("code"));
                resultjson.put("message", (Object)("e\u7b7e\u5b9d\u8425\u4e1a\u6267\u7167OCR\u5931\u8d25," + jsonResult.getString("message")));
            }
        }
        catch (Exception e) {
            this.logger.info("get ocr result failed, msg:{}", (Object)e.getMessage());
            resultjson.put("code", (Object)"000006");
            resultjson.put("message", (Object)("e\u7b7e\u5b9d\u8425\u4e1a\u6267\u7167OCR\u5931\u8d25\uff0c" + e.getMessage()));
        }
        return resultjson;
    }

    @Override
    public JSONObject uploadHlsFromWx(IRequest iRequest, AttachmentInfo attachmentInfo) {
        JSONObject json = new JSONObject();
        if (Objects.isNull(attachmentInfo.getMediaId())) {
            this.logger.info("upload attachment failed, attachmentInfo:{} \u5173\u952e\u53c2\u6570mediaId\u4e0d\u5b58\u5728\uff0c\u8c03\u7528\u5931\u8d25!", (Object)JSON.toJSONString((Object)attachmentInfo));
            json.put("code", (Object)"000003");
            json.put("message", (Object)"\u5173\u952e\u53c2\u6570mediaId\u4e0d\u5b58\u5728\uff0c\u8c03\u7528\u5931\u8d25");
            return json;
        }
        SignUserAttachInfo signUserAttachInfo = new SignUserAttachInfo();
        signUserAttachInfo.setOpenId(attachmentInfo.getOpenId());
        signUserAttachInfo.setAttachmentType(attachmentInfo.getSourceType());
        List<Object> signUserAttachInfos = new ArrayList();
        signUserAttachInfos = this.iSignUserAttachInfoService.select(iRequest, signUserAttachInfo, 1, 1);
        signUserAttachInfo = signUserAttachInfos.size() > 0 ? (SignUserAttachInfo)signUserAttachInfos.get(0) : this.iSignUserAttachInfoService.insertSelective(iRequest, signUserAttachInfo);
        signUserAttachInfo.setMediaId(attachmentInfo.getMediaId());
        try {
            AttachmentInfo downloadInfo = new AttachmentInfo();
            downloadInfo.setUploadSysName(wxSysName);
            downloadInfo.setUploadApiName(wxDownLoadApiName);
            downloadInfo.setMediaId(attachmentInfo.getMediaId());
            InputStream inputStream = this.downloadFileFromWx(downloadInfo);
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            if (!ArrayUtils.isEmpty((byte[])bytes)) {
                SignHclcUtils signHclcUtils = new SignHclcUtils();
                if ("app_file_id_card".equalsIgnoreCase(attachmentInfo.getSourceType())) {
                    json = signHclcUtils.idcard(bytes);
                } else if ("app_file_id_bank".equalsIgnoreCase(attachmentInfo.getSourceType())) {
                    json = signHclcUtils.bankcard(bytes);
                } else {
                    String idNOBlob = Base64.encodeBase64String((byte[])bytes);
                    json = this.ocrLicense(iRequest, idNOBlob);
                }
                json.put("code", (Object)"0");
                attachmentInfo.setUserId("admin");
                attachmentInfo.setUploadSysName(hclcSysName);
                attachmentInfo.setUploadApiName(hclcUpLoadApiName);
                attachmentInfo.setPkValue(attachmentInfo.getOpenId());
                String attchmentId = this.uploadFileToHclc(bytes, attachmentInfo);
                if (Objects.nonNull(attchmentId)) {
                    signUserAttachInfo.setAttachmentIdHclc(Long.valueOf(attchmentId));
                    json.put("attchmentId", (Object)attchmentId);
                } else {
                    json.put("code", (Object)"000005");
                    json.put("message", (Object)"\u4e0a\u4f20\u4e1a\u52a1\u7cfb\u7edf\u56fe\u7247\u5931\u8d25,OCR\u8bc6\u522b\u5931\u8d25");
                }
            } else {
                json.put("code", (Object)"000001");
                json.put("message", (Object)"\u4e0b\u8f7d\u670d\u52a1\u5668\u56fe\u7247\u5931\u8d25,OCR\u8bc6\u522b\u5931\u8d25");
            }
            this.iSignUserAttachInfoService.updateByPrimaryKey(iRequest, signUserAttachInfo);
            this.logger.info("upload attachment  json:{}", (Object)json.toString());
            return json;
        }
        catch (Exception e) {
            this.logger.info("upload attachment failed, attachmentInfo:{}", (Object)JSON.toJSONString((Object)attachmentInfo), (Object)e);
            json.put("code", (Object)"000002");
            json.put("message", (Object)e.getMessage());
            return json;
        }
    }

    public InputStream downloadFileFromWx(AttachmentInfo info) throws IOException {
        JSONObject parameters = new JSONObject();
        parameters.put("apiKey", (Object)this.apiKey);
        parameters.put("mediaId", (Object)info.getMediaId());
        String url = this.getApiUrl(info.getUploadSysName(), info.getUploadApiName());
        this.logger.info("upload url: {}", (Object)url);
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/json");
        httpPost.setHeader("Accept", "application/json");
        StringEntity se = new StringEntity(parameters.toString(), "utf-8");
        se.setContentType("text/json");
        httpPost.setEntity((HttpEntity)se);
        RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(60000).build();
        this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
        InputStream inputStream = response.getEntity().getContent();
        return inputStream;
    }

    @Override
    public JSONObject sendWxTemplateMsg(JSONObject json) {
        JSONObject result = new JSONObject();
        if (json.getString("templateId") == null || json.getString("first") == null || json.getString("openId") == null) {
            result.put("errCode", (Object)"000001");
            result.put("msg", (Object)"message data is empty or templateId is empty or target user is empty");
            return result;
        }
        JSONObject parameters = new JSONObject();
        parameters.put("apiKey", (Object)this.apiKey);
        parameters.put("templateId", (Object)json.getString("templateId"));
        parameters.put("toUser", (Object)json.getString("openId"));
        parameters.put("first", (Object)json.getString("first"));
        parameters.put("keyword1", (Object)json.getString("keyword1"));
        parameters.put("keyword2", (Object)json.getString("keyword2"));
        parameters.put("keyword3", (Object)json.getString("keyword3"));
        parameters.put("keyword4", (Object)json.getString("keyword4"));
        parameters.put("keyword5", (Object)json.getString("keyword5"));
        parameters.put("remark", (Object)json.getString("remark"));
        parameters.put("url", (Object)json.getString("url"));
        String url = this.getApiUrl(wxSysName, wxSendTemplateApiName);
        this.logger.info("upload url: {}", (Object)url);
        SignHclcUtils signHclcUtils1 = new SignHclcUtils();
        String stringResult = signHclcUtils1.postString(url, parameters, null, "application/json");
        JSONObject jsonResult = JSONObject.parseObject((String)stringResult);
        if ("00".equalsIgnoreCase(jsonResult.getString("resultCode"))) {
            result.put("code", (Object)"0");
            result.put("message", (Object)"\u5fae\u4fe1\u6d88\u606f\u53d1\u9001\u6210\u529f\uff01");
        } else {
            this.logger.info("send wx message failed, errCode:{} ,msg:{}", (Object)jsonResult.getString("resultCode"), (Object)jsonResult.getString("resultMessage"));
            result.put("code", (Object)jsonResult.getString("resultCode"));
            result.put("message", (Object)("\u5fae\u4fe1\u6d88\u606f\u53d1\u9001\u5931\u8d25," + jsonResult.getString("resultMessage")));
        }
        return result;
    }

    public String uploadFileToHclc(byte[] bytes, AttachmentInfo info) {
        this.logger.info("params, attachmentInfo:{}", (Object)JSON.toJSONString((Object)info));
        if (ArrayUtils.isEmpty((byte[])bytes) || info == null || StringUtils.isBlank((CharSequence)info.getPkValue()) || StringUtils.isBlank((CharSequence)info.getSourceType())) {
            return null;
        }
        String url = this.getApiUrl(info.getUploadSysName(), info.getUploadApiName());
        this.logger.info("upload url: {}", (Object)url);
        HttpPost httpPost = new HttpPost(url);
        StringBody pkValue = new StringBody(info.getPkValue(), ContentType.MULTIPART_FORM_DATA);
        StringBody userId = new StringBody(info.getUserId(), ContentType.MULTIPART_FORM_DATA);
        StringBody sourceType = new StringBody(info.getSourceType(), ContentType.MULTIPART_FORM_DATA);
        ContentType pdfType = ContentType.create((String)"image/jpeg", (Charset)Consts.UTF_8);
        try {
            HttpEntity entity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addPart("pkvalue", (ContentBody)pkValue).addPart("user_id", (ContentBody)userId).addPart("source_type", (ContentBody)sourceType).addBinaryBody("file", bytes, pdfType, info.getFileName()).setCharset(CharsetUtils.get((String)"utf-8")).build();
            httpPost.setEntity(entity);
            RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(60000).build();
            this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
            InputStream content = response.getEntity().getContent();
            String result = IOUtils.toString((InputStream)content);
            this.logger.info("upload attachment , attchmentId:{}", (Object)result);
            if (StringUtils.equals((CharSequence)RESULT_ERROR, (CharSequence)result)) {
                return null;
            }
            return result;
        }
        catch (IOException e) {
            this.logger.info("upload attachment failed, attachmentInfo:{}", (Object)JSON.toJSONString((Object)info), (Object)e);
            return null;
        }
    }

    @Override
    public Map<String, Object> signFileUpload(IRequest iRequest, AttachmentInfo dto) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (Objects.isNull(dto.getAttachmentId())) {
            this.logger.info("\u5173\u952e\u53c2\u6570AttachmentId\u4e0d\u5b58\u5728\uff0c\u8c03\u7528\u5931\u8d25!");
            map.put("success", "false");
            map.put("message", "\u5173\u952e\u53c2\u6570AttachmentId\u4e0d\u5b58\u5728\uff0c\u8c03\u7528\u5931\u8d25!");
            return map;
        }
        String downloadUrl = this.getApiUrl(hclcSysName, hclcDownloadApiName);
        byte[] bytes = this.downloadFileFromHclc(dto.getAttachmentId(), downloadUrl);
        if (!ArrayUtils.isEmpty((byte[])bytes)) {
            String uploadUrl = this.getApiUrl(signatureSysName, signatureUpLoadApiName);
            String fileKey = this.fileUpload(bytes, uploadUrl, dto.getFileName());
            if (fileKey == null) {
                map.put("success", "true");
                map.put("message", "\u4e0a\u4f20e\u7b7e\u5b9d\u6587\u4ef6\u5931\u8d25\u8bf7\u68c0\u67e5e\u7b7e\u5b9d\u670d\u52a1\u5668!");
            } else {
                map.put("success", "true");
                map.put("fileKey", fileKey);
                map.put("message", "\u4e0a\u4f20\u6210\u529f");
            }
        } else {
            this.logger.info("\u4e1a\u52a1\u7cfb\u7edf\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\u8bf7\u68c0\u67e5\u6587\u4ef6\u4e0b\u8f7d\u8def\u5f84!");
            map.put("success", "false");
            map.put("message", "\u4e1a\u52a1\u7cfb\u7edf\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\u8bf7\u68c0\u67e5\u6587\u4ef6\u4e0b\u8f7d\u8def\u5f84!");
        }
        return map;
    }

    public byte[] downloadFileFromHclc(String attachmentId, String downloadUrl) {
        String url = downloadUrl;
        try {
            url = url + (url.indexOf("?") > 0 ? "&attachment_id=" : "?attachment_id=") + attachmentId;
            HttpGet httpGet = new HttpGet(url);
            RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(60000).build();
            this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);
            if (200 != response.getStatusLine().getStatusCode()) {
                this.logger.info("request target attachment({}) failed,sysName:{}, apiName:{}", new Object[]{attachmentId, hclcSysName, hclcDownloadApiName});
                return null;
            }
            InputStream content = response.getEntity().getContent();
            return IOUtils.toByteArray((InputStream)content);
        }
        catch (Exception e) {
            this.logger.info("request target attachment({}) failed,sysName:{}, apiName:{}", new Object[]{attachmentId, hclcSysName, hclcDownloadApiName});
            return null;
        }
    }

    private String fileUpload(byte[] bytes, String uploadUrl, String fileName) {
        String res = "";
        this.logger.info("upload url: {}", (Object)uploadUrl);
        try {
            HttpPost httpPost = new HttpPost(uploadUrl);
            AlgorithmHelper algorithmHelper = new AlgorithmHelper();
            String EncryptedString = AlgorithmHelper.getXtimevaleSignature("", this.projectSecret, HASH_ALGORITHM, "UTF-8");
            httpPost.addHeader("x-timevale-project-id", this.projectId);
            httpPost.addHeader("x-timevale-signature", EncryptedString);
            HttpEntity entity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addBinaryBody("file", bytes, ContentType.MULTIPART_FORM_DATA, fileName).setCharset(CharsetUtils.get((String)"utf-8")).build();
            httpPost.setEntity(entity);
            RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(60000).build();
            this.httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
            InputStream content = response.getEntity().getContent();
            res = IOUtils.toString((InputStream)content);
            if (StringUtils.equals((CharSequence)RESULT_ERROR, (CharSequence)res)) {
                return null;
            }
            String fileKey = null;
            JSONObject jsonResult = JSONObject.parseObject((String)res);
            if (!"".equalsIgnoreCase(jsonResult.getString("data")) && jsonResult.getString("data") != null) {
                fileKey = jsonResult.getJSONObject("data").getString("fileKey");
            }
            return fileKey;
        }
        catch (Exception e) {
            this.logger.info("\u6587\u4ef6\u4e0a\u4f20\uff0c\u53d1\u9001POST\u8bf7\u6c42\u51fa\u9519==>" + uploadUrl);
            this.logger.info("\u6587\u4ef6\u4e0a\u4f20\uff0c\u5f02\u5e38\u4fe1\u606f==>" + e.getMessage());
            return null;
        }
    }

    @Override
    public Map<String, Object> addPersonAccount(SignUserInfoHclc signInfoHclc) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        JSONObject result = new JSONObject();
        result.put("cardNo", (Object)"");
        result.put("contactsEmail", (Object)"");
        result.put("contactsMobile", (Object)signInfoHclc.getMobile());
        result.put("licenseNumber", (Object)signInfoHclc.getIdNo());
        result.put("licenseType", (Object)"IDCard");
        result.put("loginEmail", (Object)"");
        result.put("loginMobile", (Object)signInfoHclc.getMobile());
        result.put("name", (Object)signInfoHclc.getName());
        result.put("uniqueId", (Object)signInfoHclc.getOpenId());
        JSONObject json = new JSONObject((Map)result);
        String param = json.toString();
        AlgorithmHelper algorithmHelper = new AlgorithmHelper();
        String EncryptedString = AlgorithmHelper.getXtimevaleSignature(param, this.projectSecret, HASH_ALGORITHM, "UTF-8");
        HashMap<String, String> headInfo = new HashMap<String, String>();
        headInfo.put("x-timevale-project-id", this.projectId);
        headInfo.put("x-timevale-signature", EncryptedString);
        try {
            String url = this.getApiUrl(signatureSysName, accountsApiName);
            this.logger.info("add person account url: {}", (Object)url);
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.postString(url, json, headInfo, "application/json");
            JSONObject jsonResult = JSONObject.parseObject((String)stringResult);
            if ("0".equalsIgnoreCase(jsonResult.getString("errCode"))) {
                JSONObject data = jsonResult.getJSONObject("data");
                map.put("accountId", data.getString("accountId"));
                String sealId = this.createTemplateSeals(data.getString("accountId"), signInfoHclc.getOpenId());
                map.put("sealId", sealId);
                map.put("code", "0");
                map.put("message", "\u4e2a\u4ebae\u7b7e\u5b9d\u8d26\u6237\u521b\u5efa\u6210\u529f\uff01");
            } else {
                this.logger.info("create person account failed, errCode:{} ,msg:{}", (Object)jsonResult.getString("errCode"), (Object)jsonResult.getString("msg"));
                map.put("code", jsonResult.getString("errCode"));
                map.put("message", "\u4e2a\u4ebae\u7b7e\u5b9d\u8d26\u6237\u521b\u5efa\u5931\u8d25," + jsonResult.getString("msg"));
            }
        }
        catch (Exception e) {
            this.logger.info("create person account failed, msg:{}", (Object)e.getMessage());
            map.put("code", "000006");
            map.put("message", "\u4e2a\u4ebae\u7b7e\u5b9d\u8d26\u6237\u521b\u5efa\u5931\u8d25\uff0c" + e.getMessage());
        }
        return map;
    }

    @Override
    public String createTemplateSeals(String accountId, String openId) {
        JSONObject result = new JSONObject();
        result.put("accountId", (Object)accountId);
        result.put("color", (Object)"BLACK");
        result.put("templateType", (Object)"BORDERLESS");
        result.put("uniqueId", (Object)openId);
        JSONObject json = new JSONObject((Map)result);
        String param = json.toString();
        AlgorithmHelper algorithmHelper = new AlgorithmHelper();
        String EncryptedString = AlgorithmHelper.getXtimevaleSignature(param, this.projectSecret, HASH_ALGORITHM, "UTF-8");
        HashMap<String, String> headInfo = new HashMap<String, String>();
        headInfo.put("x-timevale-project-id", this.projectId);
        headInfo.put("x-timevale-signature", EncryptedString);
        try {
            String url = this.getApiUrl(signatureSysName, createSealsApiName);
            this.logger.info("create seals url: {}", (Object)url);
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.postString(url, json, headInfo, "application/json");
            JSONObject jsonResult = JSONObject.parseObject((String)stringResult);
            if ("0".equalsIgnoreCase(jsonResult.getString("errCode"))) {
                JSONObject data = jsonResult.getJSONObject("data");
                return data.getString("sealId");
            }
            this.logger.info("create seals failed, errCode:{} ,msg:{}", (Object)jsonResult.getString("errCode"), (Object)jsonResult.getString("msg"));
            return RESULT_ERROR;
        }
        catch (Exception e) {
            this.logger.info("create seals failed, msg:{}", (Object)e.getMessage());
            return RESULT_ERROR;
        }
    }

    @Override
    public Map<String, Object> deletePersonAccount(IRequest iRequest, SignUserInfoHclc signInfoHclc) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (Objects.isNull(signInfoHclc = this.selectByPrimaryKey(iRequest, signInfoHclc))) {
            this.logger.info("\u672a\u627e\u5230\u5bf9\u5e94e\u7b7e\u5b9d\u4e2a\u4eba\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01");
            map.put("code", "000002");
            map.put("message", "\u672a\u627e\u5230\u5bf9\u5e94e\u7b7e\u5b9d\u4e2a\u4eba\u7528\u6237\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01");
            return map;
        }
        String accountId = "";
        accountId = signInfoHclc.getCtitype().compareTo(1L) == 0 ? signInfoHclc.getAccountId() : signInfoHclc.getAgentAccountId();
        if (Objects.isNull(accountId) || "".equalsIgnoreCase(accountId)) {
            this.logger.info("e\u7b7e\u5b9d\u4e2a\u4eba\u8d26\u6237\u4e0d\u5b58\u5728\uff0c\u65e0\u9700\u6ce8\u9500\uff01");
            map.put("code", "40051667");
            map.put("message", "e\u7b7e\u5b9d\u4e2a\u4eba\u8d26\u6237\u4e0d\u5b58\u5728\uff0c\u65e0\u9700\u6ce8\u9500\uff01");
            return map;
        }
        JSONObject result = new JSONObject();
        result.put("accountId", (Object)accountId);
        result.put("uniqueId", (Object)signInfoHclc.getOpenId());
        JSONObject json = new JSONObject((Map)result);
        String param = json.toString();
        AlgorithmHelper algorithmHelper = new AlgorithmHelper();
        String EncryptedString = AlgorithmHelper.getXtimevaleSignature(param, this.projectSecret, HASH_ALGORITHM, "UTF-8");
        HashMap<String, String> headInfo = new HashMap<String, String>();
        headInfo.put("x-timevale-project-id", this.projectId);
        headInfo.put("x-timevale-signature", EncryptedString);
        try {
            String url = this.getApiUrl(signatureSysName, deleteApiName);
            this.logger.info("delete person account  url: {}", (Object)url);
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.postString(url, json, headInfo, "application/json");
            JSONObject jsonResult = JSONObject.parseObject((String)stringResult);
            if ("0".equalsIgnoreCase(jsonResult.getString("errCode")) || "40051667".equalsIgnoreCase(jsonResult.getString("errCode")) || RESULT_ERROR.equalsIgnoreCase(jsonResult.getString("errCode")) && "\u7528\u6237\u4e0d\u5b58\u5728".equalsIgnoreCase(jsonResult.getString("msg"))) {
                map.put("code", "0");
                map.put("message", "e\u7b7e\u5b9d\u4e2a\u4eba\u7528\u6237\u6ce8\u9500\u6210\u529f\uff01");
            } else {
                this.logger.info("delete person account failed, errCode:{} ,msg:{}", (Object)jsonResult.getString("errCode"), (Object)jsonResult.getString("msg"));
                map.put("code", jsonResult.getString("errCode"));
                map.put("message", "e\u7b7e\u5b9d\u4e2a\u4eba\u7528\u6237\u6ce8\u9500\u5931\u8d25," + jsonResult.getString("msg"));
            }
        }
        catch (Exception e) {
            this.logger.info("delete person account failed, msg:{}", (Object)e.getMessage());
            map.put("code", "000004");
            map.put("message", "e\u7b7e\u5b9d\u4e2a\u4eba\u7528\u6237\u6ce8\u9500\u5931\u8d25\uff0c" + e.getMessage());
        }
        return map;
    }

    @Override
    public JSONObject createSignFlows(IRequest requestContext, JSONObject params) {
        JSONObject jsonResult = new JSONObject();
        JSONArray signers = params.getJSONArray("signers");
        JSONArray signersNew = new JSONArray();
        String initiatorAccountId = "";
        ArrayList<String> wxOpenIds = new ArrayList<String>();
        SignUserInfoHclc signInfo = new SignUserInfoHclc();
        signInfo.setOpenId("1");
        signInfo = (SignUserInfoHclc)this.signInfoHclcMapper.selectByPrimaryKey(signInfo);
        initiatorAccountId = signInfo.getAccountId();
        for (int i = 0; i < signers.size(); ++i) {
            List<SignUserInfoHclc> signInfoHclcs;
            JSONObject json1 = signers.getJSONObject(i);
            String idNo = json1.getString("idNo");
            String agentIdNo = null;
            String name = json1.getString("name");
            String role = json1.getString("role");
            if (!"HCLC".equalsIgnoreCase(role) && !"AGENT".equalsIgnoreCase(role)) {
                agentIdNo = json1.getString("agentIdNo");
            }
            SignUserInfoHclc signInfoHclc = new SignUserInfoHclc();
            signInfoHclc.setAuthFlag("Y");
            signInfoHclc.setName(name);
            if (Objects.nonNull(idNo) && !"".equalsIgnoreCase(idNo)) {
                signInfoHclc.setIdNo(idNo);
            }
            if (Objects.nonNull(agentIdNo) && !"".equalsIgnoreCase(agentIdNo)) {
                signInfoHclc.setAgentIdNo(agentIdNo);
            }
            if ("HCLC".equalsIgnoreCase(role) || "AGENT".equalsIgnoreCase(role)) {
                signInfoHclc.setIsManagerFlag("Y");
            }
            if ((signInfoHclcs = this.signInfoHclcMapper.queryUserInfo(signInfoHclc)).size() == 0) {
                this.logger.info("create sign flows failed, account:{} is not defined in wx", (Object)(name + idNo));
                jsonResult.put("errCode", (Object)"2");
                jsonResult.put("msg", (Object)("\u521b\u5efa\u7b7e\u7f72\u6d41\u7a0b\u5931\u8d25\uff0c\u7528\u6237" + name + idNo + (Objects.nonNull(agentIdNo) && !"".equalsIgnoreCase(agentIdNo) ? "\u7ecf\u529e\u4eba" + agentIdNo : "") + "\u5728\u79fb\u52a8\u7aef\u672a\u5b8c\u6210\u5b9e\u540d\u8ba4\u8bc1\u6388\u6743\uff0c\u8bf7\u5148\u8ba4\u8bc1\u6388\u6743\uff01"));
                return jsonResult;
            }
            signInfoHclc = signInfoHclcs.get(0);
            if (!"HCLC".equalsIgnoreCase(role)) {
                json1.put("contactMobile", (Object)signInfoHclc.getMobile());
            }
            if (signInfoHclc.getCtitype().compareTo(1L) == 0) {
                json1.put("accountId", (Object)signInfoHclc.getAccountId());
                json1.put("uniqueId", (Object)signInfoHclc.getOpenId().replace("personHclc", ""));
            } else {
                json1.put("accountId", (Object)signInfoHclc.getAgentAccountId());
                json1.put("authorizationOrganizeId", (Object)signInfoHclc.getAccountId());
                json1.put("uniqueId", (Object)signInfoHclc.getOpenId());
            }
            if ("TENANT".equalsIgnoreCase(role) && !wxOpenIds.contains(signInfoHclc.getOpenId())) {
                wxOpenIds.add(signInfoHclc.getOpenId());
            }
            if (json1.getBooleanValue("autoSign") && Objects.nonNull(signInfoHclc.getSealId()) && !RESULT_ERROR.equalsIgnoreCase(signInfoHclc.getSealId())) {
                JSONArray signDocDetails = json1.getJSONArray("signDocDetails");
                JSONArray signDocDetailsNew = new JSONArray();
                for (int j = 0; j < signDocDetails.size(); ++j) {
                    JSONObject detail = signDocDetails.getJSONObject(j);
                    JSONArray signPos = detail.getJSONArray("signPos");
                    JSONArray signPosNew = new JSONArray();
                    for (int k = 0; k < signPos.size(); ++k) {
                        JSONObject pos = signPos.getJSONObject(k);
                        if (signInfoHclc.getCtitype().compareTo(1L) == 0) {
                            pos.put("sealId", (Object)signInfoHclc.getSealId());
                        } else {
                            String signIdentity = pos.getString("signIdentity");
                            if ("PERSON".equalsIgnoreCase(signIdentity)) {
                                pos.put("sealId", (Object)signInfoHclc.getSealId());
                            }
                        }
                        signPosNew.add((Object)pos);
                    }
                    detail.put("signPos", (Object)signPosNew);
                    signDocDetailsNew.add((Object)detail);
                }
                json1.put("signDocDetails", (Object)signDocDetailsNew);
            }
            json1.put("accountType", (Object)"2");
            json1.remove((Object)"idNo");
            json1.remove((Object)"agentIdNo");
            json1.remove((Object)"name");
            json1.remove((Object)"role");
            signersNew.add((Object)json1);
        }
        JSONObject wxParams = new JSONObject();
        wxParams.put("templateId", (Object)"lyMDp1r6Jp5r7eSiho0otSby4tY0pXjZg1gbcA1poNI");
        wxParams.put("first", (Object)"\u60a8\u597d\uff0c\u60a8\u7533\u8bf7\u7684\u878d\u8d44\u79df\u8d41\u5408\u540c\u5df2\u7ecf\u901a\u8fc7\u5ba1\u6838\uff0c\u53ef\u4ee5\u8fdb\u884c\u7b7e\u7ea6\u6d41\u7a0b\uff01");
        wxParams.put("keyword1", (Object)("\u627f\u79df\u4eba\uff1a" + params.getString("customername")));
        wxParams.put("keyword2", (Object)("\u5408\u540c\u53f7\uff1a" + params.getString("contractno")));
        wxParams.put("keyword3", (Object)("\u673a\u53f7\uff1a" + params.getString("serialno")));
        wxParams.put("keyword4", (Object)("\u7b7e\u7ea6\u65f6\u95f4\uff1a" + params.getString("leasebgndt")));
        wxParams.put("remark", (Object)"\u8bf7\u70b9\u51fb\u4e92\u52a8\u4e2d\u5fc3-\u878d\u8d44\u79df\u8d41\u8fdb\u884c\u7b7e\u7ea6\u3002\u8c22\u8c22\uff01");
        wxParams.put("url", (Object)"");
        JSONObject result = new JSONObject();
        result.put("attachments", params.get((Object)"attachments"));
        result.put("bizNo", params.get((Object)"bizNo"));
        result.put("callbackUrl", (Object)this.listenSignUrl);
        result.put("comments", params.get((Object)"comments"));
        result.put("initiatorAccountId", (Object)initiatorAccountId);
        result.put("redirectUrl", (Object)this.signRedirectUrl);
        result.put("signDocs", params.get((Object)"signDocs"));
        result.put("signers", (Object)signersNew);
        result.put("subject", params.get((Object)"subject"));
        JSONObject json = new JSONObject((Map)result);
        String param = json.toString();
        AlgorithmHelper algorithmHelper = new AlgorithmHelper();
        String EncryptedString = AlgorithmHelper.getXtimevaleSignature(param, this.projectSecret, HASH_ALGORITHM, "UTF-8");
        HashMap<String, String> headInfo = new HashMap<String, String>();
        headInfo.put("x-timevale-project-id", this.projectId);
        headInfo.put("x-timevale-signature", EncryptedString);
        SignFlowsInfoHclc signFlowsInfoHclc = new SignFlowsInfoHclc();
        try {
            String url = this.getApiUrl(signatureSysName, signFlowsApiName);
            this.logger.info("sign flows url: {}", (Object)url);
            signFlowsInfoHclc.setContractNo(params.getString("bizNo"));
            signFlowsInfoHclc.setSignAction("SIGN_CREATE");
            signFlowsInfoHclc.setStatus("0");
            signFlowsInfoHclc.setRequestClob(param);
            signFlowsInfoHclc = this.iSignFlowsInfoHclcService.insertSelective(requestContext, signFlowsInfoHclc);
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.postString(url, json, headInfo, "application/json");
            jsonResult = JSONObject.parseObject((String)stringResult);
            signFlowsInfoHclc.setResponseClob(stringResult);
            if (!"0".equalsIgnoreCase(jsonResult.getString("errCode"))) {
                this.logger.info("create sign flows failed, errCode:{} ,msg:{}", (Object)jsonResult.getString("errCode"), (Object)jsonResult.getString("msg"));
            } else {
                JSONObject data = jsonResult.getJSONObject("data");
                signFlowsInfoHclc.setSignFlowId(data.getString("signFlowId"));
                signFlowsInfoHclc.setReturnCode(jsonResult.getString("errCode"));
                signFlowsInfoHclc.setReturnMsg(jsonResult.getString("msg"));
                JSONArray signUrls = data.getJSONArray("signUrls");
                for (int i = 0; i < signUrls.size(); ++i) {
                    JSONObject signUrl = signUrls.getJSONObject(i);
                    SignUserInfoHclc signInfoHclc = new SignUserInfoHclc();
                    signInfoHclc.setOpenId(signUrl.getString("uniqueId"));
                    signInfoHclc = this.selectByPrimaryKey(requestContext, signInfoHclc);
                    if (signInfoHclc.getCtitype().compareTo(2L) == 0 && !signUrl.getString("signUrl").contains("organizeId")) {
                        SignUserInfoHclc signInfoHclcP = new SignUserInfoHclc();
                        signInfoHclcP.setAccountId(signInfoHclc.getAgentAccountId());
                        signInfoHclcP = this.signInfoHclcMapper.select(signInfoHclcP).get(0);
                        signUrl.put("idNo", (Object)signInfoHclcP.getIdNo());
                        signUrl.put("name", (Object)signInfoHclcP.getName());
                    } else {
                        signUrl.put("idNo", (Object)signInfoHclc.getIdNo());
                        signUrl.put("name", (Object)signInfoHclc.getName());
                    }
                    signUrl.remove((Object)"accountId");
                    signUrl.remove((Object)"accountName");
                }
                if (Objects.nonNull(wxOpenIds) && wxOpenIds.size() > 0) {
                    for (String id : wxOpenIds) {
                        if (id.contains("personHclc")) {
                            id = id.replace("personHclc", "");
                        }
                        wxParams.put("openId", (Object)id);
                        this.sendWxTemplateMsg(wxParams);
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.info("create sign flows failed, msg:{}", (Object)e.getMessage());
            jsonResult.put("errCode", (Object)"000004");
            jsonResult.put("msg", (Object)("\u521b\u5efa\u7b7e\u7f72\u6d41\u7a0b\u5931\u8d25\uff0c" + e.getMessage()));
        }
        if (Objects.nonNull(signFlowsInfoHclc)) {
            this.iSignFlowsInfoHclcService.updateByPrimaryKey(requestContext, signFlowsInfoHclc);
        }
        return jsonResult;
    }

    @Override
    public void postSignFlowsResult(IRequest iRequest, JSONObject params) {
        if (Objects.isNull(params.get((Object)"flowId"))) {
            return;
        }
        SignFlowsInfoHclc signFlowsInfoHclc = new SignFlowsInfoHclc();
        signFlowsInfoHclc.setSignAction(params.getString("action"));
        signFlowsInfoHclc.setSignFlowId(params.getString("flowId"));
        signFlowsInfoHclc.setResponseClob(params.toString());
        signFlowsInfoHclc.setStatus(params.getString("status"));
        signFlowsInfoHclc.setContractNo(params.getString("bizNo"));
        signFlowsInfoHclc.setSendFlag("N");
        signFlowsInfoHclc = this.iSignFlowsInfoHclcService.insertSelective(iRequest, signFlowsInfoHclc);
        if ("2".equalsIgnoreCase(params.getString("status"))) {
            Map<Object, Object> map = new HashMap();
            map = this.getSignFlowDocUrls(signFlowsInfoHclc.getSignFlowId());
            params.put("finishDocUrlBeans", map.get("signDocUrlList"));
        }
        if ("SIGN_FLOW_UPDATE".equalsIgnoreCase(params.getString("action"))) {
            JSONObject accountInfo = params.getJSONObject("accountInfo");
            SignUserInfoHclc signUserInfoHclc = new SignUserInfoHclc();
            if (Objects.isNull(accountInfo.getString("authOrgId")) || "".equalsIgnoreCase(accountInfo.getString("authOrgId"))) {
                signUserInfoHclc.setAccountId(accountInfo.getString("accountId"));
            } else {
                signUserInfoHclc.setAccountId(accountInfo.getString("authOrgId"));
                if (Objects.nonNull(accountInfo.getString("accountId"))) {
                    signUserInfoHclc.setAgentAccountId(accountInfo.getString("accountId"));
                }
            }
            signUserInfoHclc = this.signInfoHclcMapper.selectOne(signUserInfoHclc);
            JSONObject accountInfoNew = new JSONObject();
            accountInfoNew.put("ctino", (Object)signUserInfoHclc.getIdNo());
            accountInfoNew.put("name", (Object)signUserInfoHclc.getName());
            params.put("accountInfo", (Object)accountInfoNew);
        }
        try {
            String url = this.getApiUrl(hclcSysName, signSendApiName);
            this.logger.info("sign flow url: {}", (Object)url);
            HashMap<String, String> headInfo = new HashMap<String, String>();
            headInfo.put("Content-Type", "application/x-www-form-urlencoded");
            JSONObject requestData = new JSONObject();
            requestData.put("requestData", (Object)params.toString());
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.postString(url, requestData, headInfo, "application/x-www-form-urlencoded");
            JSONObject jsonResult = JSONObject.parseObject((String)stringResult);
            if ("true".equalsIgnoreCase(jsonResult.getString("success"))) {
                signFlowsInfoHclc.setSendFlag("Y");
                this.iSignFlowsInfoHclcService.updateByPrimaryKey(iRequest, signFlowsInfoHclc);
            } else {
                this.logger.info("post sign flow failed, errCode:{} ,msg:{}", (Object)jsonResult.getJSONObject("error").getString("code"), (Object)jsonResult.getJSONObject("error").getString("message"));
            }
            if ("2".equalsIgnoreCase(params.getString("status"))) {
                String signUrl = this.getApiUrl(hclcSysName, signFileDownApiName);
                this.logger.info("sign flow url: {}", (Object)url);
                HashMap<String, String> downHeadInfo = new HashMap<String, String>();
                headInfo.put("Content-Type", "application/x-www-form-urlencoded");
                String stringResult2 = signHclcUtils1.postString(signUrl, params, downHeadInfo, "application/x-www-form-urlencoded");
                JSONObject jsonResult2 = JSONObject.parseObject((String)stringResult2);
                if (!"true".equalsIgnoreCase(jsonResult2.getString("success"))) {
                    this.logger.info("down sign file failed, errCode:{} ,msg:{}", (Object)jsonResult2.getJSONObject("error").getString("code"), (Object)jsonResult2.getJSONObject("error").getString("message"));
                }
            }
        }
        catch (Exception e) {
            this.logger.info("post sign flow failed ,msg:{}", (Object)e.getMessage());
        }
    }

    public Map<String, Object> getSignFlowDocUrls(String signFlowId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String param = "signFlowId=" + signFlowId + "&intranetFlag=Y";
        AlgorithmHelper algorithmHelper = new AlgorithmHelper();
        String EncryptedString = AlgorithmHelper.getXtimevaleSignature("", this.projectSecret, HASH_ALGORITHM, "UTF-8");
        HashMap<String, String> headInfo = new HashMap<String, String>();
        headInfo.put("x-timevale-project-id", this.projectId);
        headInfo.put("x-timevale-signature", EncryptedString);
        try {
            String url = this.getApiUrl(signatureSysName, getSignUrlsApiName);
            this.logger.info("upload url: {}", (Object)url);
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = SignHclcUtils.getStr(url, param, headInfo);
            JSONObject jsonResult = JSONObject.parseObject((String)stringResult);
            if ("0".equalsIgnoreCase(jsonResult.getString("errCode"))) {
                JSONObject data = jsonResult.getJSONObject("data");
                map.put("signDocUrlList", data.getJSONArray("signDocUrlList"));
                map.put("code", "0");
                map.put("message", "\u83b7\u53d6\u7b7e\u7f72\u6d41\u7a0b\u6587\u6863\u4e0b\u8f7d\u5730\u5740\u6210\u529f\uff01");
            } else {
                this.logger.info("get sign flow doc urls failed, errCode:{} ,msg:{}", (Object)jsonResult.getString("errCode"), (Object)jsonResult.getString("msg"));
                map.put("code", jsonResult.getString("errCode"));
                map.put("message", "\u83b7\u53d6\u7b7e\u7f72\u6d41\u7a0b\u6587\u6863\u4e0b\u8f7d\u5730\u5740\u5931\u8d25," + jsonResult.getString("msg"));
            }
        }
        catch (Exception e) {
            this.logger.info("create person account failed, msg:{}", (Object)e.getMessage());
            map.put("code", "000001");
            map.put("message", "\u83b7\u53d6\u7b7e\u7f72\u6d41\u7a0b\u6587\u6863\u4e0b\u8f7d\u5730\u5740\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01" + e.getMessage());
        }
        return map;
    }

    @Override
    public Map<String, Object> signFileDownload(IRequest requestContext, AttachmentInfo dto) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String filekey = dto.getMediaId();
        String param = "fileKey=" + filekey;
        AlgorithmHelper algorithmHelper = new AlgorithmHelper();
        String EncryptedString = AlgorithmHelper.getXtimevaleSignature("", this.projectSecret, HASH_ALGORITHM, "UTF-8");
        HashMap<String, String> headInfo = new HashMap<String, String>();
        headInfo.put("x-timevale-project-id", this.projectId);
        headInfo.put("x-timevale-signature", EncryptedString);
        try {
            String url = "http://139.196.20.44:8035/v1/files/getDownloadUrl";
            this.logger.info("download url: {}", (Object)url);
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = SignHclcUtils.getStr(url, param, headInfo);
            JSONObject jsonResult = JSONObject.parseObject((String)stringResult);
            if ("0".equalsIgnoreCase(jsonResult.getString("errCode"))) {
                JSONObject data = jsonResult.getJSONObject("data");
                map.put("downloadUrl", data.getString("downloadUrl"));
                map.put("code", "0");
                map.put("message", "\u83b7\u53d6\u7b7e\u7f72\u6d41\u7a0b\u6587\u6863\u4e0b\u8f7d\u5730\u5740\u6210\u529f\uff01");
            } else {
                this.logger.info("get sign flow doc urls failed, errCode:{} ,msg:{}", (Object)jsonResult.getString("errCode"), (Object)jsonResult.getString("msg"));
                map.put("code", jsonResult.getString("errCode"));
                map.put("message", "\u83b7\u53d6\u7b7e\u7f72\u6d41\u7a0b\u6587\u6863\u4e0b\u8f7d\u5730\u5740\u5931\u8d25," + jsonResult.getString("msg"));
            }
        }
        catch (Exception e) {
            this.logger.info("create person account failed, msg:{}", (Object)e.getMessage());
            map.put("code", "000001");
            map.put("message", "\u83b7\u53d6\u7b7e\u7f72\u6d41\u7a0b\u6587\u6863\u4e0b\u8f7d\u5730\u5740\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01" + e.getMessage());
        }
        return map;
    }

    @Override
    public JSONObject cancelSignFlows(IRequest requestContext, JSONObject params) {
        JSONObject jsonResult = new JSONObject();
        JSONObject result = new JSONObject();
        result.put("bizNo", (Object)params.getString("bizNo"));
        result.put("reason", (Object)"");
        result.put("signFlowId", (Object)params.getString("signFlowId"));
        JSONObject json = new JSONObject((Map)result);
        String param = json.toString();
        AlgorithmHelper algorithmHelper = new AlgorithmHelper();
        String EncryptedString = AlgorithmHelper.getXtimevaleSignature(param, this.projectSecret, HASH_ALGORITHM, "UTF-8");
        HashMap<String, String> headInfo = new HashMap<String, String>();
        headInfo.put("x-timevale-project-id", this.projectId);
        headInfo.put("x-timevale-signature", EncryptedString);
        try {
            String url = "http://139.196.20.44:8035/V1/signFlows/cancel";
            this.logger.info("cancel sign url: {}", (Object)url);
            SignHclcUtils signHclcUtils1 = new SignHclcUtils();
            String stringResult = signHclcUtils1.postString(url, json, headInfo, "application/json");
            jsonResult = JSONObject.parseObject((String)stringResult);
        }
        catch (Exception e) {
            this.logger.info("cancel sign flow failed, msg:{}", (Object)e.getMessage());
            jsonResult.put("code", (Object)RESULT_ERROR);
            jsonResult.put("code", (Object)("\u4f5c\u5e9f\u5931\u8d25" + e.getMessage()));
        }
        return jsonResult;
    }
}

